/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.imports.DistrictImportUtils;
import org.simantics.district.imports.ui.CSVImportModel;
import org.simantics.district.imports.ui.CSVImportWizardFirstPage;
import org.simantics.district.imports.ui.CSVImportWizardPage;
import org.simantics.district.imports.ui.ComponentMappingPage;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.DNEdgeBuilder;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ExceptionUtils;

public class CSVImportWizard
extends Wizard
implements IImportWizard {
    private CSVImportModel model;

    public CSVImportWizard() {
        this.setWindowTitle("Import CSV data");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.model = new CSVImportModel();
        this.addPage((IWizardPage)new CSVImportWizardFirstPage(this.model));
        this.addPage((IWizardPage)new CSVImportWizardPage(this.model));
        this.addPage((IWizardPage)new ComponentMappingPage(this.model));
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Path csvFile = CSVImportWizard.this.model.getSource();
                        char delim = CSVImportWizard.this.model.getDelimiter();
                        final List rows = DistrictImportUtils.readRows((Path)csvFile, (char)delim, (int)-1);
                        monitor.beginTask("Importing CSV", rows.size());
                        final int xCoordColumnIndex = CSVImportWizard.this.model.getXCoordIndex();
                        final int yCoordColumnIndex = CSVImportWizard.this.model.getYCoordIndex();
                        final int zCoordColumnIndex = CSVImportWizard.this.model.getZCoordIndex();
                        final int supplyTempColumnIndex = CSVImportWizard.this.model.getSupplyTempIndex();
                        final int returnTempColumnIndex = CSVImportWizard.this.model.getReturnTempIndex();
                        final int supplyPressureColumnIndex = CSVImportWizard.this.model.getSupplyPressureIndex();
                        final int returnPressureColumnIndex = CSVImportWizard.this.model.getReturnPressureIndex();
                        final int dpIndex = CSVImportWizard.this.model.getDeltaPressureIndex();
                        final int dtIndex = CSVImportWizard.this.model.getDeltaTemperatureIndex();
                        final int heatPowerIndex = CSVImportWizard.this.model.getHeatPowerIndex();
                        final int valvePositionIndex = CSVImportWizard.this.model.getValvePositionIndx();
                        final int nominalHeadMIndex = CSVImportWizard.this.model.getNominalHeadMIndex();
                        final int nominalHeadBIndex = CSVImportWizard.this.model.getNominalHeadBIndex();
                        final int nominalFlowIndex = CSVImportWizard.this.model.getNominalFlowIndex();
                        final int maximumHeadMIndex = CSVImportWizard.this.model.getMaximumHeadMIndex();
                        final int heatLoadDsIndex = CSVImportWizard.this.model.getHeatLoadDsIndex();
                        final int massFlowIndex = CSVImportWizard.this.model.getMassFlowIndex();
                        final int volFlowIndex = CSVImportWizard.this.model.getVolFlowIndex();
                        final int velocityIndex = CSVImportWizard.this.model.getVelocityIndex();
                        final int flowAreaIndex = CSVImportWizard.this.model.getFlowAreaIndex();
                        final int nominalPressureLossIndex = CSVImportWizard.this.model.getNominalPressureLossIndex();
                        final int addressIndex = CSVImportWizard.this.model.getAddressIndex();
                        final int startXCoordColumnIndex = CSVImportWizard.this.model.getStartXCoordIndex();
                        final int startYCoordColumnIndex = CSVImportWizard.this.model.getStartYCoordIndex();
                        CSVImportWizard.this.model.getStartZCoordIndex();
                        final int endXCoordColumnIndex = CSVImportWizard.this.model.getEndXCoordIndex();
                        final int endYCoordColumnIndex = CSVImportWizard.this.model.getEndYCoordIndex();
                        CSVImportWizard.this.model.getEndZCoordIndex();
                        final int diameterColumnIndex = CSVImportWizard.this.model.getDiameterIndex();
                        final int outerDiameterColumnIndex = CSVImportWizard.this.model.getOuterDiamterIndex();
                        final int nominalMassFlowIndex = CSVImportWizard.this.model.getNominalMassFlowIndex();
                        final int tGroundIndex = CSVImportWizard.this.model.gettGroundIndex();
                        final int edgeFlowAreaIndex = CSVImportWizard.this.model.getEdgeFlowAreaIndex();
                        final int kReturnIndex = CSVImportWizard.this.model.getkReturnIndex();
                        final int kSupplyIndex = CSVImportWizard.this.model.getkSupplyIndex();
                        final int lengthIndex = CSVImportWizard.this.model.getLengthIndex();
                        final int mappingColumn = CSVImportWizard.this.model.getComponentMappingIndex();
                        final int idColumn = CSVImportWizard.this.model.getIdIndex();
                        final double padding = CSVImportWizard.this.model.getEdgePadding();
                        String sourceEPSGCRS = CSVImportWizard.this.model.getSourceCRS();
                        MathTransform transform = null;
                        boolean doTransform = false;
                        if (sourceEPSGCRS != null && !sourceEPSGCRS.isEmpty()) {
                            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEPSGCRS);
                            CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
                            transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
                            doTransform = true;
                        }
                        final boolean actualDoTransform = doTransform;
                        final MathTransform actualTransform = transform;
                        Simantics.getSession().syncRequest(new Write(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                graph.markUndoPoint();
                                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                                Collection vertices = (Collection)graph.syncRequest((Read)new ObjectsWithType(CSVImportWizard.this.model.getParentDiagram(), Layer0.getInstance((ReadGraph)graph).ConsistsOf, DistrictNetworkResource.getInstance((ReadGraph)graph).Vertex));
                                ArrayList<DNEdgeBuilder.ResourceVertex> vv = new ArrayList<DNEdgeBuilder.ResourceVertex>(vertices.size());
                                for (Resource vertex : vertices) {
                                    double[] existingCoords = (double[])graph.getRelatedValue2(vertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
                                    vv.add(new DNEdgeBuilder.ResourceVertex(vertex, existingCoords));
                                }
                                int k = 1;
                                while (k < rows.size()) {
                                    block12: {
                                        CSVRecord row = (CSVRecord)rows.get(k);
                                        String mappingValue = row.get(mappingColumn);
                                        try {
                                            double[] endCoords;
                                            double[] startCoords;
                                            if (CSVImportWizard.this.model.isVertexImport()) {
                                                double[] coords;
                                                String zs;
                                                String xCoords = row.get(xCoordColumnIndex);
                                                String yCoords = row.get(yCoordColumnIndex);
                                                double xCoord = Double.parseDouble(xCoords);
                                                double yCoord = Double.parseDouble(yCoords);
                                                double z = 0.0;
                                                if (zCoordColumnIndex != -1 && !(zs = row.get(zCoordColumnIndex)).isEmpty()) {
                                                    try {
                                                        z = Double.parseDouble(zs);
                                                    }
                                                    catch (NumberFormatException e) {
                                                        throw new DatabaseException((Throwable)e);
                                                    }
                                                }
                                                if (actualDoTransform) {
                                                    DirectPosition2D targetPos = new DirectPosition2D();
                                                    DirectPosition2D sourcePos = new DirectPosition2D(xCoord, yCoord);
                                                    DirectPosition res = actualTransform.transform((DirectPosition)sourcePos, (DirectPosition)targetPos);
                                                    coords = res.getCoordinate();
                                                } else {
                                                    coords = new double[]{xCoord, yCoord};
                                                }
                                                Resource vertex = DistrictNetworkUtil.createVertex((WriteGraph)graph, (Resource)CSVImportWizard.this.model.getParentDiagram(), (double[])coords, (Resource)CSVImportWizard.this.model.getComponentMappings().get(mappingValue));
                                                CSVImportWizard.writeStringValue(graph, row, idColumn, vertex, DN.HasId);
                                                graph.claimLiteral(vertex, DN.Vertex_HasElevation, (Object)z, (Binding)Bindings.DOUBLE);
                                                CSVImportWizard.writeValue(graph, row, supplyTempColumnIndex, vertex, DN.Vertex_HasSupplyTemperature);
                                                CSVImportWizard.writeValue(graph, row, returnTempColumnIndex, vertex, DN.Vertex_HasReturnTemperature);
                                                CSVImportWizard.writeValue(graph, row, supplyPressureColumnIndex, vertex, DN.Vertex_HasSupplyPressure);
                                                CSVImportWizard.writeValue(graph, row, returnPressureColumnIndex, vertex, DN.Vertex_HasReturnPressure);
                                                CSVImportWizard.writeValue(graph, row, dpIndex, vertex, DN.Vertex_HasDeltaPressure);
                                                CSVImportWizard.writeValue(graph, row, dtIndex, vertex, DN.Vertex_HasDeltaTemperature);
                                                CSVImportWizard.writeValue(graph, row, heatPowerIndex, vertex, DN.Vertex_HasHeatPower);
                                                CSVImportWizard.writeValue(graph, row, valvePositionIndex, vertex, DN.Vertex_HasValvePosition);
                                                CSVImportWizard.writeValue(graph, row, nominalHeadMIndex, vertex, DN.Vertex_HasNominalHeadM);
                                                CSVImportWizard.writeValue(graph, row, nominalHeadBIndex, vertex, DN.Vertex_HasNominalHeadB);
                                                CSVImportWizard.writeValue(graph, row, nominalFlowIndex, vertex, DN.Vertex_HasNominalFlow);
                                                CSVImportWizard.writeValue(graph, row, maximumHeadMIndex, vertex, DN.Vertex_HasMaximumHeadM);
                                                CSVImportWizard.writeValue(graph, row, heatLoadDsIndex, vertex, DN.Vertex_HasHeatLoadDs);
                                                CSVImportWizard.writeValue(graph, row, massFlowIndex, vertex, DN.Vertex_HasMassFlow);
                                                CSVImportWizard.writeValue(graph, row, volFlowIndex, vertex, DN.Vertex_HasVolFlow);
                                                CSVImportWizard.writeValue(graph, row, velocityIndex, vertex, DN.Vertex_HasVelocity);
                                                CSVImportWizard.writeValue(graph, row, flowAreaIndex, vertex, DN.Vertex_HasFlowArea);
                                                CSVImportWizard.writeValue(graph, row, nominalPressureLossIndex, vertex, DN.Vertex_HasNominalPressureLoss);
                                                CSVImportWizard.writeStringValue(graph, row, addressIndex, vertex, DN.Vertex_HasAddress);
                                                break block12;
                                            }
                                            String startXCoords = row.get(startXCoordColumnIndex);
                                            String startYCoords = row.get(startYCoordColumnIndex);
                                            String endXCoords = row.get(endXCoordColumnIndex);
                                            String endYCoords = row.get(endYCoordColumnIndex);
                                            double startXCoord = Double.parseDouble(startXCoords);
                                            double startYCoord = Double.parseDouble(startYCoords);
                                            double endXCoord = Double.parseDouble(endXCoords);
                                            double endYCoord = Double.parseDouble(endYCoords);
                                            if (actualDoTransform) {
                                                DirectPosition2D startTargetPos = new DirectPosition2D();
                                                DirectPosition2D startSourcePos = new DirectPosition2D(startXCoord, startYCoord);
                                                DirectPosition startRes = actualTransform.transform((DirectPosition)startSourcePos, (DirectPosition)startTargetPos);
                                                startCoords = startRes.getCoordinate();
                                                DirectPosition2D endTargetPos = new DirectPosition2D();
                                                DirectPosition2D endSourcePos = new DirectPosition2D(endXCoord, endYCoord);
                                                DirectPosition endRes = actualTransform.transform((DirectPosition)endSourcePos, (DirectPosition)endTargetPos);
                                                endCoords = endRes.getCoordinate();
                                            } else {
                                                startCoords = new double[]{startXCoord, startYCoord};
                                                endCoords = new double[]{endXCoord, endYCoord};
                                            }
                                            Resource edge = DNEdgeBuilder.create((WriteGraph)graph, vv, (Resource)CSVImportWizard.this.model.getParentDiagram(), (Resource)CSVImportWizard.this.model.getComponentMappings().get(mappingValue), (double[])startCoords, (double[])endCoords, (double)padding, (boolean)true);
                                            CSVImportWizard.writeStringValue(graph, row, idColumn, edge, DN.HasId);
                                            CSVImportWizard.writeValue(graph, row, diameterColumnIndex, edge, DN.Edge_HasDiameter);
                                            CSVImportWizard.writeValue(graph, row, outerDiameterColumnIndex, edge, DN.Edge_HasOuterDiameter);
                                            CSVImportWizard.writeValue(graph, row, nominalMassFlowIndex, edge, DN.Edge_HasNominalMassFlow);
                                            CSVImportWizard.writeValue(graph, row, tGroundIndex, edge, DN.Edge_HasTGround);
                                            CSVImportWizard.writeValue(graph, row, kReturnIndex, edge, DN.Edge_HasKReturn);
                                            CSVImportWizard.writeValue(graph, row, kSupplyIndex, edge, DN.Edge_HasKSupply);
                                            CSVImportWizard.writeValue(graph, row, edgeFlowAreaIndex, edge, DN.Edge_HasFlowArea);
                                            CSVImportWizard.writeValue(graph, row, lengthIndex, edge, DN.Edge_HasLength);
                                        }
                                        catch (MismatchedDimensionException | TransformException | DatabaseException e) {
                                            throw new DatabaseException(e);
                                        }
                                    }
                                    monitor.worked(1);
                                    ++k;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            cp.setErrorMessage(t.getMessage());
            ExceptionUtils.logAndShowError((Throwable)t);
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return false;
        }
    }

    private static void writeValue(WriteGraph graph, CSVRecord row, int index, Resource subject, Resource relation) throws DatabaseException {
        String stringValue;
        if (index != -1 && !(stringValue = row.get(index)).isEmpty()) {
            try {
                graph.claimLiteral(subject, relation, (Object)Double.parseDouble(stringValue), (Binding)Bindings.DOUBLE);
            }
            catch (NumberFormatException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    private static void writeStringValue(WriteGraph graph, CSVRecord row, int index, Resource subject, Resource relation) throws DatabaseException {
        String stringValue;
        if (index != -1 && !(stringValue = row.get(index)).isEmpty()) {
            try {
                graph.claimLiteral(subject, relation, (Object)stringValue, (Binding)Bindings.STRING);
            }
            catch (NumberFormatException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }
}

