/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.Files;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.java.JavaRecord;
import org.simantics.databoard.annotations.Arguments;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.modelica.data.DataSet;
import org.simantics.modelica.data.SimulationResult;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.manager.SysdynResult;

public class MemoryResult
extends SysdynResult {
    private THashMap<String, SysdynDataSet> results = new THashMap();
    private File resultFile;
    private Integer resultIndex = null;
    private SimulationResult simulationResult;
    private boolean filter = false;
    private double startTime;
    private double stopTime;
    private double timeStep;

    public MemoryResult(SimulationResult result, String resultName) {
        super(resultName);
        if (result != null) {
            this.setResult(result);
        }
    }

    @Override
    public SysdynDataSet getDataSet(String variable) {
        SysdynDataSet result = (SysdynDataSet)((Object)this.results.get((Object)variable));
        if (result != null) {
            return result;
        }
        SimulationResult simulationResult = this.getSimulationResult();
        try {
            if (simulationResult != null) {
                DataSet ds = simulationResult.getDataSet(variable);
                if (ds == null) {
                    ds = simulationResult.readVariable(variable, this.resultFile);
                }
                if (ds != null) {
                    if (this.filter) {
                        ds.filter(this.startTime, this.stopTime, this.timeStep);
                    }
                    SysdynDataSet sds = new SysdynDataSet(ds.name, this.getResultName(), ds.times, ds.values, this.resultIndex);
                    this.results.put((Object)variable, (Object)sds);
                    return sds;
                }
            }
        }
        catch (FileNotFoundException e1) {
            System.err.println("Variable " + variable + " not found in OpenModelica result file");
            return null;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public void setFilter(double start, double stop, double step) {
        this.filter = true;
        this.startTime = start;
        this.stopTime = stop;
        this.timeStep = step;
    }

    public void unsetFilter() {
        this.filter = false;
    }

    public void setResultFile(File resFile) {
        this.resultFile = resFile;
    }

    public int numberOfVariables() {
        return this.simulationResult.getVariableDataSets().size();
    }

    public void setResult(SimulationResult result) {
        this.simulationResult = result;
        this.results.clear();
        if (result != null) {
            this.addAllInitialValues(result);
        }
    }

    public SimulationResult getSimulationResult() {
        return this.simulationResult;
    }

    private void addAllInitialValues(SimulationResult result) {
        for (DataSet ds : result.getInitialValueDataSets()) {
            SysdynDataSet sds = new SysdynDataSet(ds.name, this.getResultName(), ds.times, ds.values);
            this.results.put((Object)ds.name, (Object)sds);
        }
    }

    @Override
    public void saveToFile(File file, IProgressMonitor progressMonitor) {
        try {
            JavaRecord accessor;
            Datatype recordingSessionType = Datatypes.getDatatype((String)"RecordingSession");
            RecordBinding sessionBinding = (RecordBinding)Bindings.getBinding((Datatype)recordingSessionType);
            Object session = sessionBinding.createDefault();
            JavaRecord jr = accessor = (JavaRecord)Accessors.getAccessor((Binding)sessionBinding, (Object)session);
            RecordBinding binding = jr.getBinding();
            Object value = jr.getObject();
            this.getSimulationResult().readMissingVariables(this.resultFile);
            this.addAllDataSetsToAccessor(accessor, progressMonitor);
            if (progressMonitor != null) {
                progressMonitor.subTask("Save results");
            }
            Files.createFile((File)file, (Binding)binding, (Object)value);
            progressMonitor.worked(this.numberOfVariables());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BindingException e) {
            e.printStackTrace();
        }
        catch (AccessorConstructionException e) {
            e.printStackTrace();
        }
    }

    private void addAllDataSetsToAccessor(JavaRecord accessor, IProgressMonitor progressMonitor) {
        try {
            MapAccessor recordings = (MapAccessor)accessor.getFieldAccessor("recordings");
            List datasets = this.getSimulationResult().getVariableDataSets();
            RecordBinding recordingBinding = (RecordBinding)Bindings.getBinding(Recording.class);
            if (progressMonitor != null) {
                progressMonitor.subTask("Prepare saving");
            }
            for (DataSet ds : datasets) {
                Variant dsNodeId;
                if (progressMonitor != null) {
                    progressMonitor.worked(1);
                }
                if (recordings.containsKey((Binding)Bindings.VARIANT, (Object)(dsNodeId = Variant.ofInstance((Object)ds.name)))) continue;
                Recording recording = this.createRecording(ds);
                recordings.put((Binding)Bindings.VARIANT, (Object)recording.nodeId, (Binding)Bindings.VARIANT, (Object)new Variant((Binding)recordingBinding, (Object)recording));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Recording createRecording(DataSet ds) throws BindingException {
        RecordBinding recordingBinding = (RecordBinding)Bindings.getBindingUnchecked(Recording.class);
        Recording recording = (Recording)recordingBinding.createDefault();
        recording.nodeId = Variant.ofInstance((Object)ds.name);
        recording.labels.put("en", ds.name);
        TreeMap<Double, Double> segment = new TreeMap<Double, Double>();
        recording.segments = new TreeMap[]{segment};
        int length = ds.values.length;
        int i = 0;
        while (i < length) {
            double time = ds.times[i];
            double value = ds.values[i];
            segment.put(time, value);
            ++i;
        }
        return recording;
    }

    public void setResultIndex(int resultIndex) {
        this.resultIndex = resultIndex;
    }

    public static class Recording {
        public Variant nodeId;
        @Arguments(value={String.class, String.class})
        public TreeMap<String, String> labels;
        @Arguments(value={TreeMap.class, Double.class, Double.class})
        public TreeMap<Double, Double>[] segments;
    }
}

