/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionField;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;
import org.simantics.sysdyn.ui.properties.widgets.expressions.IExpression;
import org.simantics.sysdyn.ui.utils.ExpressionUtils;

public class BasicExpression
implements IExpression {
    protected ExpressionField expression;
    protected Resource expressionType;
    protected ExpressionWidgetInput input;

    public BasicExpression(ExpressionWidgetInput input) {
        this.input = input;
    }

    @Override
    public void createExpressionFields(Composite parent, Map<String, Object> data, Table allowedVariables) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        String equation = data.get("equation") != null ? (String)data.get("equation") : "";
        Label l = new Label(parent, 0);
        l.setText("=");
        this.expression = new ExpressionField(parent, 2048, null, false, this.input);
        this.expression.setExpression(equation);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.expression);
    }

    @Override
    public void focus() {
        this.expression.focus();
    }

    @Override
    public List<ExpressionField> getExpressionFields() {
        return Arrays.asList(this.expression);
    }

    @Override
    public void readData(final Resource expression, Map<String, Object> data) {
        String equation = null;
        if (expression != null && data.get("equation") == null) {
            try {
                equation = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                    public String perform(ReadGraph graph) throws DatabaseException {
                        String equation;
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        if (expression != null && (equation = (String)graph.getPossibleRelatedValue(expression, sr.Expression_equation)) != null) {
                            return equation;
                        }
                        return "";
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
            data.put("equation", equation);
        }
    }

    @Override
    public void replaceSelection(String var) {
        if (this.expression != null) {
            IDocument doc = this.expression.getDocument();
            try {
                Point selection = this.expression.getSelection();
                doc.replace(selection.x, selection.y, var);
                this.expression.setSelection(selection.x + var.length());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void save(final Resource expression, Map<String, Object> data) {
        final String currentText = this.expression.getExpression();
        final String oldEquation = (String)data.get("equation");
        if (oldEquation == null || currentText != null && this.expressionType != null) {
            data.put("equation", currentText);
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph g) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                    if (oldEquation != null && expression != null && g.isInstanceOf(expression, BasicExpression.this.expressionType) && currentText.equals(oldEquation)) {
                        return;
                    }
                    if (ExpressionUtils.isParameter(currentText)) {
                        if (!BasicExpression.this.expressionType.equals(sr.ConstantExpression)) {
                            BasicExpression.this.expressionType = sr.ParameterExpression;
                        }
                    } else {
                        BasicExpression.this.expressionType = sr.NormalExpression;
                    }
                    g.markUndoPoint();
                    CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
                    g.addMetadata((Metadata)cm.add("Set equation"));
                    if (!g.isInstanceOf(expression, BasicExpression.this.expressionType)) {
                        Resource variable;
                        final Resource newExpression = GraphUtils.create2((WriteGraph)g, (Resource)BasicExpression.this.expressionType, (Object[])new Object[]{sr.Expression_equation, currentText});
                        String arrayRange = (String)g.getPossibleRelatedValue(expression, sr.Expression_arrayRange, (Binding)Bindings.STRING);
                        if (arrayRange != null) {
                            g.claimLiteral(newExpression, sr.Expression_arrayRange, (Object)arrayRange);
                        }
                        if ((variable = g.getPossibleObject(expression, l0.PartOf)) == null) {
                            return;
                        }
                        Resource ownerList = g.getPossibleObject(variable, sr.Variable_expressionList);
                        if (ownerList == null) {
                            return;
                        }
                        ListUtils.replace((WriteGraph)g, (Resource)ownerList, (Resource)expression, (Resource)newExpression);
                        g.deny(expression, l0.PartOf);
                        g.claim(newExpression, l0.PartOf, variable);
                        VirtualGraphSupport support = (VirtualGraphSupport)g.getService(VirtualGraphSupport.class);
                        g.syncRequest((Write)new WriteRequest(support.getWorkspacePersistent("expressions")){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                                if (variable != null) {
                                    if (graph.hasStatement(variable, sr.IndependentVariable_activeExpression)) {
                                        graph.deny(variable, sr.IndependentVariable_activeExpression);
                                    }
                                    graph.claim(variable, sr.IndependentVariable_activeExpression, newExpression);
                                }
                            }
                        });
                    } else {
                        g.claimLiteral(expression, sr.Expression_equation, (Object)currentText);
                    }
                }
            });
        }
    }

    @Override
    public void updateData(Map<String, Object> data) {
        if (this.expression != null && this.expression.getExpression() != null) {
            data.put("equation", this.expression.getExpression());
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.expression.getSourceViewer().getTextWidget().addKeyListener(listener);
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
        this.expression.getSourceViewer().getTextWidget().addModifyListener(listener);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.expression.getSourceViewer().getTextWidget().addFocusListener(listener);
    }

    @Override
    public void addVerifyKeyListener(VerifyKeyListener listener) {
        this.expression.getSourceViewer().getTextWidget().addVerifyKeyListener(listener);
    }

    @Override
    public IUndoManager getUndoManager() {
        return null;
    }
}

