/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.ui.ISelectionUtils;

public class ArrowHeadWidget
implements Widget {
    List<Resource> variables = null;
    Button arrowheadButton;

    public ArrowHeadWidget(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        this.arrowheadButton = new Button(parent, support, style |= 0x20);
        this.arrowheadButton.setText("Arrowhead");
    }

    public void setInput(ISessionContext context, Object input) {
        ISelection selection;
        if (input instanceof ISelection && (selection = (ISelection)input) instanceof IStructuredSelection) {
            List resources = ISelectionUtils.filterSelection((ISelection)selection, Resource.class);
            if (resources != null && !resources.isEmpty()) {
                this.variables = resources;
            } else {
                List resourceLists = ISelectionUtils.filterSelection((ISelection)selection, ArrayList.class);
                this.variables = (List)resourceLists.get(0);
            }
        }
        if (this.variables == null) {
            return;
        }
        try {
            context.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    boolean hasArrowheads = false;
                    boolean hasNotArrowheads = false;
                    for (Resource variable : ArrowHeadWidget.this.variables) {
                        if (!graph.hasStatement(variable, sr.DependencyConnection_hideArrow)) {
                            hasArrowheads = true;
                            continue;
                        }
                        hasNotArrowheads = true;
                    }
                    final org.eclipse.swt.widgets.Button button = ArrowHeadWidget.this.getWidget();
                    final boolean arrowhead = hasArrowheads;
                    final boolean mixedArrowheads = hasArrowheads && hasNotArrowheads;
                    button.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (button.isDisposed()) {
                                return;
                            }
                            button.setSelection(arrowhead);
                            button.setGrayed(mixedArrowheads);
                        }
                    });
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.arrowheadButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<ArrayList<Resource>>(context){

            public void apply(WriteGraph graph, ArrayList<Resource> inputs) throws DatabaseException {
                if (inputs == null) {
                    return;
                }
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                boolean nextState = true;
                for (Resource variable : ArrowHeadWidget.this.variables) {
                    if (graph.hasStatement(variable, sr.DependencyConnection_hideArrow)) continue;
                    nextState = false;
                    break;
                }
                try {
                    if (nextState) {
                        for (Resource input : inputs) {
                            graph.deny(input, sr.DependencyConnection_hideArrow);
                        }
                    } else {
                        for (Resource input : inputs) {
                            graph.claim(input, SysdynResource.getInstance((ReadGraph)graph).DependencyConnection_hideArrow, null, input);
                        }
                    }
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                final org.eclipse.swt.widgets.Button button = ArrowHeadWidget.this.getWidget();
                button.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        button.setGrayed(false);
                    }
                });
            }
        });
        this.arrowheadButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                if (input == null) {
                    return;
                }
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                if (graph.hasStatement(input, sr.DependencyConnection_hideArrow)) {
                    graph.deny(input, sr.DependencyConnection_hideArrow);
                } else {
                    graph.claim(input, SysdynResource.getInstance((ReadGraph)graph).DependencyConnection_hideArrow, null, input);
                }
            }
        });
    }

    public org.eclipse.swt.widgets.Button getWidget() {
        return this.arrowheadButton.getWidget();
    }
}

