/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.menu;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynPlaybackExperiment;

public class PlaybackSliderContribution
extends WorkbenchWindowControlContribution {
    private Runnable timeListener;
    private SysdynPlaybackExperiment spe;
    private Double startTime;
    private Double endTime;
    boolean ignoreChange = false;
    private Slider slider;
    private Composite composite;
    public static String COMMAND = "org.simantics.sysdyn.ui.playbackSliderContribution";

    public PlaybackSliderContribution() {
        super(COMMAND);
    }

    public void dispose() {
        super.dispose();
        if (this.timeListener != null && this.spe != null) {
            this.spe.removeTimeListener(this.timeListener);
            this.timeListener = null;
        }
        if (this.composite != null) {
            this.composite.dispose();
        }
        if (this.slider != null) {
            this.slider.dispose();
        }
    }

    protected Control createControl(Composite parent) {
        IProject project = Simantics.peekProject();
        if (project == null) {
            return null;
        }
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment == null || !(experiment instanceof SysdynPlaybackExperiment)) {
            return null;
        }
        this.spe = (SysdynPlaybackExperiment)experiment;
        Double[] numbers = new Double[2];
        try {
            numbers = (Double[])Simantics.getSession().syncRequest((Read)new Read<Double[]>(){

                public Double[] perform(ReadGraph graph) throws DatabaseException {
                    Double[] numbers = new Double[2];
                    Resource model = PlaybackSliderContribution.this.spe.getModel();
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    numbers[0] = (Double)graph.getRelatedValue(model, sr.SysdynModel_startTime);
                    numbers[1] = (Double)graph.getRelatedValue(model, sr.SysdynModel_stopTime);
                    return numbers;
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        ISessionContext context = Simantics.getSessionContext();
        WidgetSupportImpl support = new WidgetSupportImpl();
        this.composite = new Composite(parent, 0);
        this.composite.setLayout(parent.getLayout());
        this.slider = new Slider(this.composite, 0);
        this.slider.setMinimum(0);
        this.slider.setMaximum(100);
        this.slider.setIncrement(1);
        this.slider.setPageIncrement(1);
        this.slider.setThumb(1);
        final Label label = new Label(this.composite, 16384);
        label.setText("0.0");
        support.fireInput(context, (Object)this.spe.getResource());
        this.startTime = numbers[0];
        this.endTime = numbers[1];
        final DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(2);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(' ');
        format.setDecimalFormatSymbols(symbols);
        this.slider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Slider s = (Slider)e.widget;
                Double time = (double)s.getSelection() / 99.0 * (PlaybackSliderContribution.this.endTime - PlaybackSliderContribution.this.startTime) + PlaybackSliderContribution.this.startTime;
                PlaybackSliderContribution.this.spe.setTimeAndContinue(time.doubleValue());
                if (!label.isDisposed()) {
                    label.setText(format.format(time));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.timeListener != null) {
            this.spe.removeTimeListener(this.timeListener);
        }
        this.timeListener = new Runnable(){

            @Override
            public void run() {
                PlaybackSliderContribution.this.slider.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!PlaybackSliderContribution.this.startTime.equals(PlaybackSliderContribution.this.spe.getStartTime()) || !PlaybackSliderContribution.this.endTime.equals(PlaybackSliderContribution.this.spe.getEndTime())) {
                            PlaybackSliderContribution.this.startTime = PlaybackSliderContribution.this.spe.getStartTime();
                            PlaybackSliderContribution.this.endTime = PlaybackSliderContribution.this.spe.getEndTime();
                        }
                        int value = (int)Math.round((PlaybackSliderContribution.this.spe.getTime() - PlaybackSliderContribution.this.startTime) / (PlaybackSliderContribution.this.endTime - PlaybackSliderContribution.this.startTime) * 99.0);
                        PlaybackSliderContribution.this.slider.setSelection(value);
                        label.setText(format.format(PlaybackSliderContribution.this.spe.getTime()));
                    }
                });
            }
        };
        this.spe.addTimeListener(this.timeListener);
        return this.composite;
    }
}

