/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.listeners;

import java.util.HashMap;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.profile.Profiles;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynPlaybackExperiment;
import org.simantics.sysdyn.ui.editor.DiagramViewer;

public class SysdynPlaybackExperimentListener
implements IExperimentListener {
    private Resource model;
    private Resource previousProfile;
    HashMap<Resource, DiagramInfo> previousRuntimeDiagramsAndModelUris = new HashMap();

    public SysdynPlaybackExperimentListener(SysdynPlaybackExperiment experiment) {
        this.model = experiment.getModel();
        this.activatePlaybackProfile();
    }

    public void stateChanged(ExperimentState state) {
        switch (state) {
            case DISPOSED: {
                this.revertPlaybackProfiles();
            }
        }
    }

    private void activatePlaybackProfile() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SysdynPlaybackExperimentListener.this.previousRuntimeDiagramsAndModelUris.clear();
                SysdynPlaybackExperimentListener.this.previousRuntimeDiagramsAndModelUris = SysdynPlaybackExperimentListener.this.getCurrentRuntimeDiagramInfos();
                SysdynPlaybackExperimentListener.this.activatePlaybackProfileRequest(SysdynPlaybackExperimentListener.this.previousRuntimeDiagramsAndModelUris);
            }
        });
    }

    private void revertPlaybackProfiles() {
        IProject project = Simantics.getProject();
        if (project == null) {
            return;
        }
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment != null && experiment instanceof SysdynPlaybackExperiment && this.model.equals(experiment.getModel())) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                final HashMap runtimeDiagramsAndModelUris = SysdynPlaybackExperimentListener.this.getCurrentRuntimeDiagramInfos();
                VirtualGraphSupport support = (VirtualGraphSupport)Simantics.getSession().getService(VirtualGraphSupport.class);
                Simantics.getSession().asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("profiles")){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Resource model = SysdynPlaybackExperimentListener.this.model;
                        if (model == null) {
                            return;
                        }
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        Resource defaultProfile = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(model, l0.ConsistsOf, sr.DefaultProfile));
                        if (defaultProfile == null) {
                            return;
                        }
                        SysdynPlaybackExperimentListener.this.setProfileForModel(graph, model, SysdynPlaybackExperimentListener.this.previousProfile == null ? defaultProfile : SysdynPlaybackExperimentListener.this.previousProfile);
                        HashMap infos = SysdynPlaybackExperimentListener.this.getRuntimesForModel(graph, runtimeDiagramsAndModelUris, model);
                        for (Resource runtimeDiagram : infos.keySet()) {
                            Resource previous = null;
                            if ((this).SysdynPlaybackExperimentListener.this.previousRuntimeDiagramsAndModelUris.containsKey(runtimeDiagram)) {
                                previous = (this).SysdynPlaybackExperimentListener.this.previousRuntimeDiagramsAndModelUris.get((Object)runtimeDiagram).previousProfile;
                            }
                            SysdynPlaybackExperimentListener.this.setProfileForDiagram(graph, runtimeDiagram, previous == null ? defaultProfile : previous);
                        }
                    }
                });
            }
        });
    }

    private HashMap<Resource, DiagramInfo> getCurrentRuntimeDiagramInfos() {
        IWorkbenchPage[] pages;
        HashMap<Resource, DiagramInfo> runtimeDiagramsAndModelUris = new HashMap<Resource, DiagramInfo>();
        IWorkbench workBench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workBench.getActiveWorkbenchWindow();
        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n3 = iEditorReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                DiagramEditor editor;
                IEditorReference reference = iEditorReferenceArray[n4];
                IEditorPart iep = reference.getEditor(false);
                if (iep instanceof DiagramEditor && (editor = (DiagramEditor)iep).getViewer() instanceof DiagramViewer) {
                    DiagramViewer viewer = (DiagramViewer)editor.getViewer();
                    Resource runtime = viewer.getRuntime();
                    Resource model = viewer.getResourceInput2().getModel(null);
                    DiagramInfo info = new DiagramInfo();
                    info.model = model;
                    runtimeDiagramsAndModelUris.put(runtime, info);
                }
                ++n4;
            }
            ++n2;
        }
        return runtimeDiagramsAndModelUris;
    }

    private HashMap<Resource, DiagramInfo> getRuntimesForModel(WriteGraph graph, HashMap<Resource, DiagramInfo> allInfos, Resource model) throws DatabaseException {
        HashMap<Resource, DiagramInfo> runtimeDiagramsAndModelUris = new HashMap<Resource, DiagramInfo>();
        for (Resource runtimeDiagram : allInfos.keySet()) {
            Resource m;
            DiagramInfo di = allInfos.get(runtimeDiagram);
            if (di == null || (m = di.model) == null || !model.equals(m)) continue;
            runtimeDiagramsAndModelUris.put(runtimeDiagram, di);
        }
        return runtimeDiagramsAndModelUris;
    }

    private void activatePlaybackProfileRequest(final HashMap<Resource, DiagramInfo> allDiagramInfos) {
        VirtualGraphSupport support = (VirtualGraphSupport)Simantics.getSession().getService(VirtualGraphSupport.class);
        Simantics.getSession().asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("profiles")){

            public void perform(WriteGraph graph) throws DatabaseException {
                Resource model = SysdynPlaybackExperimentListener.this.model;
                if (model == null) {
                    return;
                }
                Resource profile = SysdynPlaybackExperimentListener.this.getSimulationPlaybackProfile(graph, model);
                if (profile == null) {
                    return;
                }
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                Resource current = graph.getPossibleObject(model, DIA.HasActiveProfile);
                SysdynPlaybackExperimentListener.this.previousProfile = current;
                if (!profile.equals(current)) {
                    SysdynPlaybackExperimentListener.this.setProfileForModel(graph, model, profile);
                }
                HashMap infos = SysdynPlaybackExperimentListener.this.getRuntimesForModel(graph, allDiagramInfos, model);
                for (Resource runtimeDiagram : infos.keySet()) {
                    DiagramInfo di = (DiagramInfo)infos.get(runtimeDiagram);
                    di.previousProfile = current = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
                    if (profile.equals(current)) continue;
                    SysdynPlaybackExperimentListener.this.setProfileForDiagram(graph, runtimeDiagram, profile);
                }
            }
        });
    }

    private void setProfileForDiagram(WriteGraph graph, Resource runtimeDiagram, Resource profile) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource current = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
        if (profile.equals(current)) {
            return;
        }
        if (current != null) {
            graph.deny(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile, null, current);
        }
        graph.claim(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile, null, profile);
        Resource configuration = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        graph.deny(configuration, DIA.HasActiveProfile);
        graph.claim(configuration, DIA.HasActiveProfile, profile);
    }

    private void setProfileForModel(WriteGraph graph, Resource model, Resource profile) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        graph.deny(model, DIA.HasActiveProfile);
        graph.claim(model, DIA.HasActiveProfile, profile);
    }

    private Resource getSimulationPlaybackProfile(WriteGraph graph, Resource model) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource profile = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(model, l0.ConsistsOf, sr.SimulationPlaybackProfile));
        if (profile == null) {
            profile = Profiles.createProfile((WriteGraph)graph, (String)"Simulation Playback", (Resource[])new Resource[]{sr.Profiles_SimulationPlaybackColours});
            graph.deny(profile, l0.InstanceOf);
            graph.claim(profile, l0.InstanceOf, null, sr.SimulationPlaybackProfile);
            graph.claim(model, l0.ConsistsOf, profile);
        }
        if (!graph.hasStatement(profile, SIMU.IsActive)) {
            graph.claim(profile, SIMU.IsActive, sr.Profiles_SimulationPlaybackColours);
        }
        return profile;
    }

    class DiagramInfo {
        public Resource model = null;
        public Resource previousProfile = null;

        DiagramInfo() {
        }
    }
}

