/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.connections;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.connection.ConnectionVisuals;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteGraphConnectionClass;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.rendering.ConnectionStyle;
import org.simantics.diagram.connection.rendering.StyledRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.content.TerminalMap;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.RouteGraphConnection;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.routing.algorithm2.Router4;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.nodes.connection.IRouteGraphListener;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphChangeEvent;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.IAttachmentRelationMap;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.ValveFactory;
import org.simantics.sysdyn.ui.elements.connections.FlowArrowLineStyle;
import org.simantics.sysdyn.ui.elements.connections.FlowConnectionStyle;
import org.simantics.sysdyn.ui.elements.connections.RouteFlowEdgeClass;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPreferences;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPropertyExternalRead;
import org.simantics.utils.datastructures.Pair;

public class RouteFlowConnectionFactory
extends SyncElementFactory {
    public static final ElementClass CLASS = RouteFlowEdgeClass.FLOW_CLASS;
    Layer0 L0;
    DiagramResource DIA;
    StructuralResource2 STR;
    ModelingResources MOD;

    public RouteFlowConnectionFactory(ReadGraph graph) {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
    }

    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)CLASS.newClassWith(false, new ElementHandler[]{new StaticObjectAdapter((Object)elementType)}));
    }

    protected Resource getElementClassBaseType(AsyncReadGraph graph) {
        return ((SysdynResource)graph.getService(SysdynResource.class)).FlowConnection;
    }

    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, final Resource connection, IElement element) throws DatabaseException {
        element.setHint(DiagramHints.ROUTE_ALGORITHM, (Object)new Router4(false));
        IModelingRules modelingRules = (IModelingRules)diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        Color color = null;
        DiagramResource DR = DiagramResource.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(connection, DR.ColorProvider)) {
            Statement colorStatement = graph.getPossibleStatement(connection, G2D.HasColor);
            if (colorStatement != null && !colorStatement.isAsserted(connection)) {
                element.setHint(ElementHints.KEY_TEXT_COLOR, (Object)G2DUtils.getColor((ReadGraph)graph, (Resource)colorStatement.getObject()));
            } else {
                RGB rgb;
                String colorString = (String)graph.syncRequest((ExternalRead)new SysdynDiagramPropertyExternalRead((Pair<Resource, String>)new Pair((Object)connection, (Object)SysdynDiagramPreferences.getColorPreferenceName(graph, connection))));
                if (colorString != null && (rgb = StringConverter.asRGB((String)colorString, null)) != null) {
                    color = new Color(rgb.red, rgb.green, rgb.blue);
                    element.setHint(ElementHints.KEY_TEXT_COLOR, (Object)color);
                }
            }
        }
        RouteGraph rg = new RouteGraph();
        HashSet<Resource> nodes = new HashSet<Resource>();
        HashSet<EdgeResource> links = new HashSet<EdgeResource>();
        HashMap<Resource, Object> nodeByData = new HashMap<Resource, Object>();
        HashSet<BackendConnection> backendonnections = new HashSet<BackendConnection>();
        for (Resource interiorNode : graph.getObjects(connection, this.DIA.HasInteriorRouteNode)) {
            if (graph.isInstanceOf(interiorNode, this.DIA.RouteLine)) {
                Boolean isHorizontal = (Boolean)graph.getRelatedValue(interiorNode, this.DIA.IsHorizontal, (Binding)Bindings.BOOLEAN);
                Double position = (Double)graph.getRelatedValue(interiorNode, this.DIA.HasPosition, (Binding)Bindings.DOUBLE);
                RouteLine line = rg.addLine(isHorizontal.booleanValue(), position.doubleValue());
                line.setData(RouteGraphConnection.serialize((ServiceLocator)graph, (Resource)interiorNode));
                nodes.add(interiorNode);
                nodeByData.put(interiorNode, line);
                for (Resource connectedTo : graph.getObjects(interiorNode, this.DIA.AreConnected)) {
                    links.add(new EdgeResource(interiorNode, connectedTo));
                }
                continue;
            }
            graph.isInstanceOf(interiorNode, this.DIA.RoutePoint);
        }
        Rectangle2D bounds = new Rectangle2D.Double();
        for (Statement toConnector : graph.getStatements(connection, this.DIA.HasConnector)) {
            IAttachmentRelationMap map;
            Resource att;
            Resource terminalElement;
            Resource terminalElementType;
            Resource connector = toConnector.getObject();
            Resource attachmentRelation = toConnector.getPredicate();
            Statement terminalStm = RouteFlowConnectionFactory.findTerminalStatement(graph, this.STR, connection, connector);
            if (terminalStm == null || (terminalElementType = graph.getPossibleType(terminalElement = terminalStm.getObject(), this.DIA.Element)) == null) continue;
            Resource connectionRelation = graph.getInverse(terminalStm.getPredicate());
            TerminalMap terminals = (TerminalMap)graph.syncRequest(DiagramRequests.elementTypeTerminals((Resource)terminalElementType), (Listener)TransientCacheListener.instance());
            Resource terminal = terminals.getTerminal(connectionRelation);
            if (terminal == null) {
                System.err.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": Could not find terminal for connection point " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectionRelation, (boolean)true) + " in element " + NameUtils.getSafeName((ReadGraph)graph, (Resource)terminalElement, (boolean)true));
                continue;
            }
            double[] position = (double[])graph.getRelatedValue(connector, this.DIA.HasRelativeLocation, (Binding)Bindings.DOUBLE_ARRAY);
            if (position.length != 2) {
                position = new double[]{0.0, 0.0};
            }
            AffineTransform terminalElementTr = RouteFlowConnectionFactory.getWorldTransform(graph, terminalElement);
            double x = terminalElementTr.getTranslateX();
            double y = terminalElementTr.getTranslateY();
            double minx = x - 1.0;
            double miny = y - 1.0;
            double maxx = x + 1.0;
            double maxy = y + 1.0;
            int direction = 0;
            if (modelingRules != null && (att = (map = modelingRules.getAttachmentRelations(graph, connection)).get(graph, new CPTerminal(terminalElement, terminal))) != null) {
                attachmentRelation = att;
            }
            IElement te = (IElement)graph.syncRequest(DiagramRequests.getElement((ICanvasContext)canvas, (IDiagram)diagram, (Resource)terminalElement, null));
            float lw = 1.0f;
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            Float width = (Float)graph.getPossibleRelatedValue(connection, sr.FlowConnection_width, (Binding)Bindings.FLOAT);
            if (width != null) {
                lw = width.floatValue();
            }
            if (te.getElementClass().containsClass(ValveFactory.ValveSceneGraph.class)) {
                ValveFactory.ValveSceneGraph vs = (ValveFactory.ValveSceneGraph)te.getElementClass().getSingleItem(ValveFactory.ValveSceneGraph.class);
                Rectangle2D size = new Rectangle2D.Double();
                vs.getValveBounds(te, size);
                Shape shp = GeometryUtils.transformShape((Shape)size, (AffineTransform)terminalElementTr);
                size = (Rectangle2D)shp;
                bounds.setFrame(new Rectangle2D.Double(size.getCenterX() - (double)(lw / 2.0f), size.getCenterY() - (double)(lw / 2.0f), lw, lw));
            } else {
                bounds = ElementUtils.getElementShape((IElement)te).getBounds2D();
                Shape shp = GeometryUtils.transformShape((Shape)bounds, (AffineTransform)terminalElementTr);
                bounds.setFrame(shp.getBounds2D());
            }
            x = bounds.getCenterX();
            y = bounds.getCenterY();
            minx = bounds.getMinX();
            miny = bounds.getMinY();
            maxx = bounds.getMaxX();
            maxy = bounds.getMaxY();
            Integer allowedDirections = (Integer)graph.getPossibleRelatedValue(terminal, this.DIA.Terminal_AllowedDirections, (Binding)Bindings.INTEGER);
            if (te.getElementClass().containsClass(ValveFactory.ValveSceneGraph.class)) {
                allowedDirections = graph.hasStatement(terminalElement, sr.ValveSymbol_orientation, sr.Vertical) ? Integer.valueOf(10) : Integer.valueOf(5);
            }
            direction = allowedDirections != null ? (direction |= allowedDirections.intValue()) : (direction |= RouteGraphConnectionClass.shortestDirectionOutOfBounds((double)x, (double)y, (Rectangle2D)bounds));
            backendonnections.add(new BackendConnection(this.toEdgeEnd(graph, attachmentRelation, EdgeVisuals.EdgeEnd.Begin), terminalElement, terminal));
            if (direction == 0) {
                direction = 15;
            }
            ILineEndStyle endStyle = this.loadLineEndStyle(graph, te, attachmentRelation, color, lw);
            RouteTerminal routeTerminal = rg.addBigTerminal(minx, miny, maxx, maxy, endStyle);
            routeTerminal.setData(RouteGraphConnection.serialize((ServiceLocator)graph, (Resource)connector));
            nodes.add(connector);
            nodeByData.put(connector, routeTerminal);
            for (Resource connectedTo : graph.getObjects(connector, this.DIA.AreConnected)) {
                links.add(new EdgeResource(connectedTo, connector));
            }
        }
        for (EdgeResource link : links) {
            RouteNode n1 = (RouteNode)nodeByData.get(link.first());
            RouteNode n2 = (RouteNode)nodeByData.get(link.second());
            if (n1 == null || n2 == null) {
                System.err.println("Stray connection link found: " + link.toString(graph));
                continue;
            }
            rg.link(n1, n2);
        }
        ConnectionStyle style = this.readConnectionStyle(graph, modelingRules, connection, element);
        StyledRouteGraphRenderer renderer = new StyledRouteGraphRenderer(style);
        element.setHint(RouteGraphConnectionClass.KEY_ROUTEGRAPH, (Object)rg);
        element.setHint(RouteGraphConnectionClass.KEY_RENDERER, (Object)renderer);
        element.setHint(RouteGraphConnectionClass.KEY_PICK_TOLERANCE, (Object)0.5);
        element.setHint(ElementHints.KEY_CONNECTION_ENTITY, (Object)new CE(diagram, connection, element, backendonnections));
        final Session session = graph.getSession();
        element.setHint(RouteGraphConnectionClass.KEY_RG_LISTENER, (Object)new IRouteGraphListener(){

            public void routeGraphChanged(RouteGraphChangeEvent event) {
                RouteFlowConnectionFactory.this.scheduleSynchronize(session, connection, event);
            }
        });
        HashMap<String, Pair> properties = new HashMap<String, Pair>();
        for (Resource predicate : graph.getPredicates(connection)) {
            if (!graph.isSubrelationOf(predicate, this.L0.HasProperty)) continue;
            String name = (String)graph.getPossibleRelatedValue(predicate, this.L0.HasName, (Binding)Bindings.STRING);
            Object value = graph.getPossibleRelatedValue(connection, predicate);
            if (name == null || value == null) continue;
            properties.put(name, Pair.make((Object)predicate, (Object)value));
        }
        element.setHint(DiagramHints.PROPERTIES, properties);
    }

    private EdgeVisuals.EdgeEnd toEdgeEnd(ReadGraph graph, Resource attachmentRelation, EdgeVisuals.EdgeEnd defaultValue) throws DatabaseException {
        if (graph.isSubrelationOf(attachmentRelation, this.DIA.IsTailConnectorOf)) {
            return EdgeVisuals.EdgeEnd.Begin;
        }
        if (graph.isSubrelationOf(attachmentRelation, this.DIA.IsHeadConnectorOf)) {
            return EdgeVisuals.EdgeEnd.End;
        }
        return defaultValue;
    }

    private ConnectionStyle readConnectionStyle(ReadGraph graph, IModelingRules modelingRules, Resource connection, IElement element) throws DatabaseException {
        Stroke lineStroke;
        Color lineColor;
        Resource connectionType = null;
        if (modelingRules != null) {
            connectionType = modelingRules.getConnectionType(graph, connection);
        }
        if (connectionType == null) {
            connectionType = graph.getPossibleObject(connection, this.STR.HasConnectionType);
        }
        ConnectionVisuals cv = null;
        if (connectionType != null) {
            cv = (ConnectionVisuals)graph.syncRequest(DiagramRequests.getConnectionVisuals((Resource)connectionType), (Listener)TransientCacheListener.instance());
        }
        if ((lineColor = (Color)element.getHint(ElementHints.KEY_TEXT_COLOR)) == null) {
            lineColor = cv != null && cv.toColor() != null ? cv.toColor() : Color.DARK_GRAY;
        }
        Stroke stroke = lineStroke = cv != null ? cv.stroke : null;
        if (lineStroke == null) {
            lineStroke = new BasicStroke(0.1f, 0, 2, 10.0f, null, 0.0f);
        }
        return new FlowConnectionStyle(lineColor, lineStroke, connection);
    }

    private static Statement findTerminalStatement(ReadGraph graph, StructuralResource2 STR, Resource connection, Resource connector) throws DatabaseException {
        for (Statement stm : graph.getStatements(connector, STR.Connects)) {
            if (connection.equals(stm.getObject())) continue;
            return stm;
        }
        return null;
    }

    public ILineEndStyle loadLineEndStyle(ReadGraph graph, IElement te, Resource attachmentRelation, Color color, float lineWidth) throws DatabaseException {
        FlowArrowLineStyle style;
        if (te.getElementClass().containsClass(ValveFactory.ValveSceneGraph.class)) {
            style = new FlowArrowLineStyle("none 0 0 0", color);
        } else if (graph.isSubrelationOf(attachmentRelation, this.DIA.HasHeadConnector)) {
            float arrowSize = lineWidth * 1.3f;
            style = new FlowArrowLineStyle("fill " + arrowSize + " " + arrowSize + " 0", color);
        } else {
            style = new FlowArrowLineStyle("none 0 0 0", color);
        }
        return style;
    }

    private static AffineTransform getWorldTransform(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        AffineTransform result = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
        Resource parentComponent;
        while ((parentComponent = graph.getPossibleObject(element, MOD.HasParentComponent)) != null) {
            element = graph.getPossibleObject(parentComponent, MOD.ComponentToElement);
            if (element == null) {
                return result;
            }
            AffineTransform tr = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
            tr.setToTranslation(tr.getTranslateX(), tr.getTranslateY());
            result.preConcatenate(tr);
        }
        return result;
    }

    protected void scheduleSynchronize(Session session, Resource connection, RouteGraphChangeEvent event) {
        session.asyncRequest(RouteGraphConnection.synchronizer((Resource)connection, (RouteGraphChangeEvent)event));
    }

    public static class BackendConnection {
        public final Resource node;
        public final Resource terminal;
        public final EdgeVisuals.EdgeEnd end;

        public BackendConnection(EdgeVisuals.EdgeEnd end, Resource node, Resource terminal) {
            assert (end != null);
            assert (node != null);
            assert (terminal != null);
            this.end = end;
            this.node = node;
            this.terminal = terminal;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Topology.Connection)) {
                return false;
            }
            Topology.Connection other = (Topology.Connection)obj;
            return other.terminal == this.terminal && other.node == this.node && other.end == this.end;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end.hashCode();
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            result = 31 * result + (this.terminal == null ? 0 : this.terminal.hashCode());
            return result;
        }

        public String toString() {
            return "BackendConnection[node=" + this.node + ", terminal=" + this.terminal + ", end=" + this.end + "]";
        }
    }

    static class CE
    implements ConnectionEntity {
        private IDiagram diagram;
        private transient DataElementMap dataMap;
        final Resource connection;
        IElement connectionElement;
        final Set<BackendConnection> backendConnections;
        Set<Topology.Connection> terminalConnections;

        public CE(IDiagram diagram, Resource connection, IElement connectionElement, Set<BackendConnection> backendConnections) {
            if (connectionElement == null) {
                throw new NullPointerException("null connection element");
            }
            this.diagram = diagram;
            this.dataMap = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
            this.connection = connection;
            this.connectionElement = connectionElement;
            this.backendConnections = backendConnections;
            IElement ce = this.getConnection0();
            if (ce != null) {
                this.connectionElement = ce;
            }
        }

        public IElement getConnection0() {
            IElement connectionElement = this.dataMap.getElement(this.diagram, (Object)this.connection);
            return connectionElement;
        }

        public IElement getConnection() {
            IElement c = this.getConnection0();
            if (c == null) {
                c = this.connectionElement;
            }
            return c;
        }

        public Object getConnectionObject() {
            return this.connection;
        }

        public IElement getConnectionElement() {
            return this.connectionElement;
        }

        public Collection<IElement> getBranchPoints(Collection<IElement> result) {
            return result != null ? result : Collections.emptyList();
        }

        public Collection<IElement> getSegments(Collection<IElement> result) {
            return result != null ? result : Collections.emptyList();
        }

        public Collection<Topology.Connection> getTerminalConnections(Collection<Topology.Connection> result) {
            if (this.terminalConnections == null) {
                this.terminalConnections = this.calculateTerminalConnections();
            }
            if (result == null) {
                result = new ArrayList<Topology.Connection>(this.terminalConnections);
            } else {
                result.addAll(this.terminalConnections);
            }
            return this.terminalConnections;
        }

        private Set<Topology.Connection> calculateTerminalConnections() {
            DataElementMap dem = (DataElementMap)this.diagram.getDiagramClass().getSingleItem(DataElementMap.class);
            HashSet<Topology.Connection> result = new HashSet<Topology.Connection>();
            ArrayList ts = new ArrayList();
            block0: for (BackendConnection bc : this.backendConnections) {
                IElement e = dem.getElement(this.diagram, (Object)bc.node);
                if (e == null) continue;
                TerminalTopology tt = (TerminalTopology)e.getElementClass().getSingleItem(TerminalTopology.class);
                tt.getTerminals(e, ts);
                for (Topology.Terminal t : ts) {
                    ResourceTerminal rt;
                    if (!(t instanceof ResourceTerminal) || !bc.terminal.equals((rt = (ResourceTerminal)t).getResource())) continue;
                    result.add(new Topology.Connection(this.connectionElement, bc.end, e, t));
                    continue block0;
                }
            }
            return result;
        }

        public void setListener(ConnectionEntity.ConnectionListener listener) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[resource=" + this.connection + ", connectionElement=" + this.connectionElement + "]";
        }
    }
}

