/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.HashSet;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.internal.GENodeQueryManager;
import org.simantics.browsing.ui.common.internal.IGraphExplorerContext;
import org.simantics.browsing.ui.common.internal.UIElementReference;
import org.simantics.browsing.ui.content.PrunedChildrenResult;
import org.simantics.browsing.ui.swt.GraphExplorerImpl;
import org.simantics.browsing.ui.swt.TreeItemReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateRunner
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateRunner.class);
    final GraphExplorerImpl ge;

    UpdateRunner(GraphExplorerImpl ge) {
        this.ge = ge;
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable t) {
            LOGGER.error("", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        boolean doRoot;
        if (this.ge.isDisposed()) {
            return;
        }
        HashSet<TreeItem> items = new HashSet<TreeItem>();
        HashSet<TreeItem> hashSet = this.ge.pendingItems;
        synchronized (hashSet) {
            doRoot = this.ge.pendingRoot;
            for (TreeItem item : this.ge.pendingItems) {
                if (item == null) {
                    doRoot = true;
                    continue;
                }
                if (item.isDisposed()) continue;
                items.add(item);
            }
            this.ge.pendingItems = new HashSet();
            this.ge.pendingRoot = false;
        }
        if (doRoot) {
            GENodeQueryManager manager = new GENodeQueryManager((IGraphExplorerContext)this.ge.explorerContext, null, null, (UIElementReference)TreeItemReference.create(null));
            PrunedChildrenResult children = (PrunedChildrenResult)manager.query(this.ge.rootContext, BuiltinKeys.PRUNED_CHILDREN);
            int maxChildren = this.ge.getMaxChildren((NodeQueryManager)manager, this.ge.rootContext);
            int childCount = Math.min(children.getPrunedChildren().length, maxChildren);
            this.ge.tree.clearAll(true);
            this.ge.tree.setItemCount(childCount);
        } else {
            int itemIndex = 0;
            for (TreeItem item : items) {
                if (item.isDisposed()) continue;
                NodeContext context = (NodeContext)item.getData();
                assert (context != null);
                GENodeQueryManager manager = new GENodeQueryManager((IGraphExplorerContext)this.ge.explorerContext, null, null, (UIElementReference)TreeItemReference.create(item));
                PrunedChildrenResult children = (PrunedChildrenResult)manager.query(context, BuiltinKeys.PRUNED_CHILDREN);
                int maxChildren = this.ge.getMaxChildren((NodeQueryManager)manager, context);
                item.setItemCount(Math.min(children.getPrunedChildren().length, maxChildren));
                this.ge.setTextAndImage(item, (NodeQueryManager)manager, context, itemIndex);
                item.clearAll(true);
                boolean isExpanded = (Boolean)manager.query(context, BuiltinKeys.IS_EXPANDED);
                item.setExpanded(isExpanded);
                if ((((Control)this.ge.getControl()).getStyle() & 0x20) != 0) {
                    CheckedState checked = (CheckedState)manager.query(context, BuiltinKeys.IS_CHECKED);
                    item.setChecked(CheckedState.CHECKED_STATES.contains(checked));
                    item.setGrayed(CheckedState.GRAYED == checked);
                }
                ++itemIndex;
            }
        }
        HashSet<TreeItem> hashSet2 = this.ge.pendingItems;
        synchronized (hashSet2) {
            if (!this.ge.scheduleUpdater()) {
                this.ge.updating = false;
            }
        }
    }
}

