/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Session;
import org.simantics.db.services.AdaptionServiceInitializer;
import org.simantics.db.services.ServiceInitializer;

public class GlobalServiceInitializer
implements ServiceInitializer {
    private static final String PLUGIN_ID = "org.simantics.db.services";
    private static final String SERVICE_INITIALIZER = "serviceInitializer";
    public static final int INITIALIZER_ERROR = 1;

    @Override
    public IStatus initialize(Session s) {
        IExtensionPoint ep;
        MultiStatus problems = new MultiStatus(PLUGIN_ID, 1, "ServiceInitializer errors:", null);
        this.merge(problems, new AdaptionServiceInitializer().initialize(s));
        IExtensionRegistry er = Platform.getExtensionRegistry();
        if (er != null && (ep = er.getExtensionPoint(PLUGIN_ID, SERVICE_INITIALIZER)) != null) {
            IConfigurationElement[] iConfigurationElementArray = ep.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement conf = iConfigurationElementArray[n2];
                try {
                    ServiceInitializer initializer = (ServiceInitializer)conf.createExecutableExtension("class");
                    this.merge(problems, initializer.initialize(s));
                }
                catch (CoreException e) {
                    Status status = new Status(4, conf.getDeclaringExtension().getNamespaceIdentifier(), "ServiceInitializer instantiation failed, see exception for details.", (Throwable)e);
                    problems.merge((IStatus)status);
                }
                ++n2;
            }
        }
        if (problems.isOK()) {
            return Status.OK_STATUS;
        }
        return problems;
    }

    public IStatus initialize(Session s, String initializerId) {
        if (initializerId == null) {
            throw new IllegalArgumentException("null initializer id");
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SERVICE_INITIALIZER).getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement conf = iConfigurationElementArray[n2];
            try {
                String id = conf.getAttribute("id");
                if (initializerId.equals(id)) {
                    ServiceInitializer initializer = (ServiceInitializer)conf.createExecutableExtension("class");
                    return initializer.initialize(s);
                }
            }
            catch (CoreException e) {
                return new Status(4, conf.getDeclaringExtension().getNamespaceIdentifier(), "ServiceInitializer instantiation failed, see exception for details.", (Throwable)e);
            }
            ++n2;
        }
        return new Status(4, PLUGIN_ID, "ServiceInitializer extension with id '" + initializerId + "' not found.", null);
    }

    private void merge(MultiStatus result, IStatus status) {
        if (!status.isOK()) {
            result.add(status);
        }
    }
}

