/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.modules;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.JavaTypeClassMethod;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.MultiFunction;

public class TypeClassMethod {
    TypeClass typeClass;
    String name;
    String javaName;
    Type baseType;
    int arity;
    Name defaultImplementation;
    public long location;

    public TypeClassMethod(TypeClass typeClass, String name, String javaName, Type baseType, int arity, long location) {
        if (typeClass == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (javaName == null) {
            throw new NullPointerException();
        }
        if (baseType == null) {
            throw new NullPointerException();
        }
        this.typeClass = typeClass;
        this.name = name;
        this.javaName = javaName;
        this.baseType = baseType;
        this.arity = arity;
        this.location = location;
    }

    public void setDefaultImplementation(Name defaultImplementation) {
        if (this.defaultImplementation != null) {
            throw new InternalCompilerError("Default method implementation already defined");
        }
        this.defaultImplementation = defaultImplementation;
    }

    public Name getDefaultImplementation() {
        return this.defaultImplementation;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public int getArity() {
        return this.arity;
    }

    public Type getType() {
        return Types.closure(Types.constrained(this.typeClass.class_, this.baseType));
    }

    public TypeClass getTypeClass() {
        return this.typeClass;
    }

    public SCLValue createValue() {
        String moduleName = this.typeClass.name.module;
        SCLValue value = new SCLValue(Name.create(moduleName, this.name));
        MultiFunction mfun = Types.matchFunction(this.baseType);
        Type[] parameterTypes = new Type[mfun.parameterTypes.length + 1];
        System.arraycopy(mfun.parameterTypes, 0, parameterTypes, 1, mfun.parameterTypes.length);
        parameterTypes[0] = this.typeClass.class_;
        JavaTypeClassMethod constant = new JavaTypeClassMethod(this, this.typeClass.javaName, this.javaName, mfun.effect, mfun.returnType, parameterTypes);
        value.setValue(constant);
        value.setType(this.getType());
        return value;
    }
}

