/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.List;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.JavaComparisonToZeroOperation;
import org.simantics.scl.compiler.constants.JavaMathOperation;
import org.simantics.scl.compiler.constants.NoRepConstant;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.expressions.Assignment;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.EIf;
import org.simantics.scl.compiler.elaboration.expressions.ELet;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.MultiFunction;

public class Expressions {
    public static Expression apply(Expression function, Expression ... parameters) {
        if (parameters.length == 0) {
            return function;
        }
        Type ftype = function.getType();
        try {
            MultiFunction mfun = Types.matchFunction(ftype, parameters.length);
            EApply apply = new EApply(9223372034707292160L, mfun.effect, function, parameters);
            apply.setType(mfun.returnType);
            return apply;
        }
        catch (MatchException matchException) {
            throw new InternalCompilerError("Type of the function " + ftype + " is not compatible with the number of parameters.");
        }
    }

    public static Expression apply(Type effect, Expression function, Expression ... parameters) {
        return new EApply(9223372034707292160L, effect, function, parameters);
    }

    public static Expression apply(EnvironmentalContext context, Type effect, Name name, Expression ... parameters) {
        return Expressions.apply(effect, Expressions.constant(context, name), parameters);
    }

    public static Expression apply(EnvironmentalContext context, Type effect, Name name, Type typeParameter1, Expression ... parameters) {
        return Expressions.apply(effect, Expressions.constant(context, name, typeParameter1), parameters);
    }

    public static Expression apply(EnvironmentalContext context, Type effect, Name name, Type typeParameter1, Type typeParameter2, Expression ... parameters) {
        return Expressions.apply(effect, Expressions.constant(context, name, typeParameter1, typeParameter2), parameters);
    }

    public static Expression apply(EnvironmentalContext context, Type effect, Name name, Type typeParameter1, Type typeParameter2, Type typeParameter3, Expression ... parameters) {
        return Expressions.apply(effect, Expressions.constant(context, name, typeParameter1, typeParameter2, typeParameter3), parameters);
    }

    public static Expression constant(SCLValue value) {
        return new EConstant(value);
    }

    public static Expression constant(EnvironmentalContext context, Name name) {
        return new EConstant(context.getValue(name));
    }

    public static Expression constant(EnvironmentalContext context, Name name, Type ... typeParameters) {
        return new EConstant(context.getValue(name), typeParameters);
    }

    public static Expression if_(Expression condition, Expression then_, Expression else_) {
        return new EIf(condition, then_, else_);
    }

    public static Expression var(Variable variable) {
        return new EVariable(variable);
    }

    public static Variable newVar(String name, Type type) {
        return new Variable(name, type);
    }

    public static Variable newBlankVar(Type type) {
        return new Variable("_", type);
    }

    public static Expression computation(Type effect, Expression value) {
        return new ESimpleLambda(effect, Expressions.newBlankVar(Types.PUNIT), value);
    }

    public static Expression blank(Type type) {
        return new EVariable(Expressions.newBlankVar(type));
    }

    public static Expression integer(int value) {
        return new ELiteral(new IntegerConstant(value));
    }

    public static Expression string(String value) {
        return new ELiteral(new StringConstant(value));
    }

    public static Expression tuple() {
        return new EConstant(Builtins.TUPLE_CONSTRUCTORS[0]);
    }

    public static Expression punit() {
        return new ELiteral(NoRepConstant.PUNIT);
    }

    public static Expression tuple(Expression ... cs) {
        if (cs.length == 1) {
            return cs[0];
        }
        Type[] typeParameters = new Type[cs.length];
        int i = 0;
        while (i < cs.length) {
            typeParameters[i] = cs[i].getType();
            ++i;
        }
        EApply result = new EApply((Expression)new EConstant(Builtins.TUPLE_CONSTRUCTORS[cs.length], typeParameters), cs);
        result.setType(Types.tuple(Types.getTypes(cs)));
        return result;
    }

    public static Expression[] vars(Variable ... variables) {
        Expression[] expressions = new Expression[variables.length];
        int i = 0;
        while (i < variables.length) {
            expressions[i] = new EVariable(variables[i]);
            ++i;
        }
        return expressions;
    }

    public static Expression[] vars(List<Variable> variables) {
        Expression[] expressions = new Expression[variables.size()];
        int i = 0;
        while (i < variables.size()) {
            expressions[i] = new EVariable(variables.get(i));
            ++i;
        }
        return expressions;
    }

    public static Expression match(Expression scrutinee, Expression pattern1, Expression value1) {
        return new EMatch(scrutinee, new Case(pattern1, value1));
    }

    public static Expression match(Expression scrutinee, Expression pattern1, Expression value1, Expression pattern2, Expression value2) {
        return new EMatch(scrutinee, new Case(pattern1, value1), new Case(pattern2, value2));
    }

    public static Expression matchWithDefault(Expression scrutinee, Expression pattern1, Expression value1, Expression default_) {
        return new EMatch(scrutinee, new Case(pattern1, value1), new Case(Expressions.blank(pattern1.getType()), default_));
    }

    public static Expression let(Variable target, Expression value, Expression in) {
        return new ESimpleLet(target, value, in);
    }

    public static Expression letRec(Variable target, Expression value, Expression in) {
        return new ELet(9223372034707292160L, new Assignment[]{new Assignment(Expressions.var(target), value)}, in);
    }

    public static Expression letRec(Variable[] targets, Expression[] values, Expression in) {
        if (targets.length != values.length) {
            throw new InternalCompilerError();
        }
        Assignment[] assignments = new Assignment[targets.length];
        int i = 0;
        while (i < targets.length) {
            assignments[i] = new Assignment(Expressions.var(targets[i]), values[i]);
            ++i;
        }
        return new ELet(9223372034707292160L, assignments, in);
    }

    public static Expression lambda(Type effect, Variable var, Expression value) {
        return new ESimpleLambda(effect, var, value);
    }

    public static Expression lambda(Variable var, Expression value) {
        return new ESimpleLambda(value.getEffect(), var, value);
    }

    public static Expression lambda(Type effect, Variable[] vars, Expression value) {
        int i = vars.length - 1;
        while (i >= 0) {
            value = new ESimpleLambda(effect, vars[i], value);
            effect = Types.NO_EFFECTS;
            --i;
        }
        return value;
    }

    public static Expression lambda(Type effect, List<Variable> vars, Expression value) {
        int i = vars.size() - 1;
        while (i >= 0) {
            value = new ESimpleLambda(effect, vars.get(i), value);
            effect = Types.NO_EFFECTS;
            --i;
        }
        return value;
    }

    public static Expression lambda(Variable[] vars, Expression value) {
        return Expressions.lambda(value.getEffect(), vars, value);
    }

    public static Expression lambda(List<Variable> vars, Expression value) {
        return Expressions.lambda(value.getEffect(), vars, value);
    }

    public static Expression Nothing(Type type) {
        return new EConstant(Builtins.Nothing, type);
    }

    public static Expression Just(Expression expression) {
        return Expressions.apply(Types.NO_EFFECTS, (Expression)new EConstant(Builtins.Just, expression.getType()), expression);
    }

    public static Expression seq(Expression first, Expression second) {
        return Expressions.let(Expressions.newBlankVar(first.getType()), first, second);
    }

    public static Expression as(Variable var, Expression value) {
        return new EAsPattern(var, value);
    }

    public static Expression loc(long location, Expression expression) {
        expression.setLocationDeep(location);
        return expression;
    }

    public static Query loc(long location, Query query) {
        query.setLocationDeep(location);
        return query;
    }

    public static Expression applyTypes(Expression expression, Type[] types) {
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            expression = new EApplyType(expression, type);
            ++n2;
        }
        return expression;
    }

    public static Expression isZeroInteger(Expression value) {
        return Expressions.apply(Types.NO_EFFECTS, (Expression)new ELiteral(JavaComparisonToZeroOperation.IEQUAL), value);
    }

    public static Expression addInteger(Expression a, Expression b) {
        return Expressions.apply(Types.NO_EFFECTS, (Expression)new ELiteral(JavaMathOperation.IADD), a, b);
    }

    public static Expression externalConstant(Object value, Type type) {
        return new EExternalConstant(value, type);
    }
}

