/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.elaboration.transformations.TransformationBuilder;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class ETransformation
extends SimplifiableExpression {
    public static final Object TRANSFORMATION_RULES_TYPECHECKED = new Object();
    public final String name;
    public Query seed;

    public ETransformation(String name, Query seed) {
        this.name = name;
        this.seed = seed;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.UNIT);
    }

    @Override
    public Expression inferType(TypingContext context) {
        context.declareEffect(this.location, Types.PROC);
        this.seed.checkType(context);
        return this.compile(context);
    }

    private Expression compile(TypingContext context) {
        ArrayList<TransformationRule> rules = new ArrayList<TransformationRule>();
        context.getEnvironment().collectRules(rules);
        Collections.sort(rules, new Comparator<TransformationRule>(){

            @Override
            public int compare(TransformationRule o1, TransformationRule o2) {
                return Integer.compare(Locations.beginOf(o1.location), Locations.beginOf(o2.location));
            }
        });
        TransformationBuilder tb = new TransformationBuilder(context.getErrorLog(), context);
        tb.handleSeed(this.seed);
        for (TransformationRule rule : rules) {
            if (rule.isAbstract) continue;
            tb.handleRule(rule);
        }
        Expression expression = tb.compileRules();
        return expression;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.seed = this.seed.resolve(context);
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.seed.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

