/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.binaryPredicates.IBinaryPredicate;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.constraint.instructions.Instruction2;

public class BinaryPredicateInstruction
extends Instruction2 {
    IBinaryPredicate predicate;

    public BinaryPredicateInstruction(int variable0, int variable1, IBinaryPredicate predicate) {
        super(variable0, variable1);
        this.predicate = predicate;
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        if (this.predicate.has(g, (Resource)bindings[this.variable0], (Resource)bindings[this.variable1])) {
            return null;
        }
        return IInstruction.FAILURE;
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object continuation) {
        return IInstruction.FAILURE;
    }

    @Override
    public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
        Resource r0 = (Resource)bindings[this.variable0];
        Resource r1 = (Resource)bindings[this.variable1];
        if (!this.predicate.has(g, r0, r1)) {
            return new IContextualModification(){

                @Override
                public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                    Resource r0 = (Resource)bindings[BinaryPredicateInstruction.this.variable0];
                    Resource r1 = (Resource)bindings[BinaryPredicateInstruction.this.variable1];
                    BinaryPredicateInstruction.this.predicate.add(g, r0, r1);
                }
            };
        }
        return null;
    }

    @Override
    public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
        Resource r0 = (Resource)bindings[this.variable0];
        Resource r1 = (Resource)bindings[this.variable1];
        this.predicate.add(g, r0, r1);
    }

    @Override
    public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
        Resource r0 = (Resource)bindings[this.variable0];
        Resource r1 = (Resource)bindings[this.variable1];
        if (this.predicate.has(g, r0, r1)) {
            return new IContextualModification(){

                @Override
                public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                    Resource r0 = (Resource)bindings[BinaryPredicateInstruction.this.variable0];
                    Resource r1 = (Resource)bindings[BinaryPredicateInstruction.this.variable1];
                    BinaryPredicateInstruction.this.predicate.remove(g, r0, r1);
                }
            };
        }
        return null;
    }

    @Override
    public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
        Resource r0 = (Resource)bindings[this.variable0];
        Resource r1 = (Resource)bindings[this.variable1];
        this.predicate.remove(g, r0, r1);
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append('(');
        b.append(this.variable0);
        b.append(',');
        b.append(this.variable1);
        b.append(')');
    }
}

