/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.NonWritableVariableException;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariableBuilder;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.ObjectUtils;

public abstract class AbstractConstantPropertyVariable
extends AbstractPropertyVariable {
    protected final Variable parent;
    final String name;
    final Binding binding;
    final Map<String, Variable> properties;

    public AbstractConstantPropertyVariable(Variable parent, String name, Binding binding, Collection<ConstantPropertyVariableBuilder> propertyBuilders, Set<String> classifications) {
        assert (parent != null);
        assert (name != null);
        this.parent = parent;
        this.name = name;
        this.binding = binding;
        this.properties = new HashMap<String, Variable>(propertyBuilders.size());
        for (ConstantPropertyVariableBuilder builder : propertyBuilders) {
            this.properties.put(builder.getName(), builder.build(this));
        }
        if (!classifications.isEmpty()) {
            this.properties.put("classifications", new ConstantPropertyVariable(this, "classifications", classifications, null));
        }
    }

    public AbstractConstantPropertyVariable(Variable parent, String name, Binding binding) {
        this(parent, name, binding, Collections.emptyList(), Collections.emptySet());
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        throw new NonWritableVariableException("Value is constant.");
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return this.name;
    }

    @Override
    public Resource getType(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getPossibleType(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getType(ReadGraph graph, Resource baseType) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getPossibleType(ReadGraph graph, Resource baseType) throws DatabaseException {
        return null;
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        return this.binding != null ? this.binding.type() : null;
    }

    @Override
    public Resource getPropertyResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        return this.properties.get(name);
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        if (!this.properties.isEmpty()) {
            if (properties == null) {
                properties = new HashMap<String, Variable>(this.properties.size());
            }
            properties.putAll(this.properties);
        }
        return properties;
    }

    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        Variable property = this.getPossibleDomainProperty(graph, "classifications");
        if (property != null) {
            return (Set)property.getValue(graph);
        }
        return Collections.emptySet();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.parent.hashCode();
        result = 31 * result + (this.binding == null ? 0 : this.binding.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractConstantPropertyVariable other = (AbstractConstantPropertyVariable)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.parent.equals(other.parent)) {
            return false;
        }
        return ObjectUtils.objectEquals((Object)this.binding, (Object)other.binding);
    }
}

