/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.scl;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationContext;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationRequest;
import org.simantics.db.layer0.util.RuntimeEnvironmentRequest;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class CompileResourceValueRequest
extends AbstractExpressionCompilationRequest<CompilationContext, Object> {
    protected final Resource literal;

    public CompileResourceValueRequest(Resource literal) {
        this.literal = literal;
    }

    public static Object compileAndEvaluate(ReadGraph graph, Resource literal) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            Function1 exp = (Function1)graph.syncRequest((Read)new CompileResourceValueRequest(literal), (Listener)TransientCacheListener.instance());
            sclContext.put((Object)"graph", (Object)graph);
            Object object = exp.apply((Object)literal);
            return object;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    public static Function1<Object, Object> compile(ReadGraph graph, Resource literal) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new CompileResourceValueRequest(literal), (Listener)TransientCacheListener.instance());
    }

    @Override
    protected String getExpressionText(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return (String)graph.getRelatedValue(this.literal, L0.SCLValue_expression, (Binding)Bindings.STRING);
    }

    protected Resource getIndexRoot(ReadGraph graph) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new IndexRoot(this.literal));
    }

    @Override
    protected Type getExpectedType(ReadGraph graph, CompilationContext context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String valueType = (String)graph.getPossibleRelatedValue(this.literal, L0.HasValueType, (Binding)Bindings.STRING);
        if (valueType != null) {
            try {
                return Environments.getType((Environment)context.runtimeEnvironment.getEnvironment(), (String)valueType);
            }
            catch (SCLExpressionCompilationException e) {
                e.printStackTrace();
            }
        }
        return super.getExpectedType(graph, context);
    }

    @Override
    protected CompilationContext getCompilationContext(ReadGraph graph) throws DatabaseException {
        Resource indexRoot = this.getIndexRoot(graph);
        RuntimeEnvironment runtimeEnvironment = (RuntimeEnvironment)graph.syncRequest((Read)new RuntimeEnvironmentRequest(indexRoot));
        return new CompilationContext(runtimeEnvironment);
    }

    @Override
    protected Type getContextVariableType() {
        return RESOURCE;
    }

    @Override
    protected Expression getVariableAccessExpression(ReadGraph graph, CompilationContext context, Variable contextVariable, String name) throws DatabaseException {
        if (name.equals("self")) {
            return new EVariable(contextVariable);
        }
        return null;
    }

    public static class CompilationContext
    extends AbstractExpressionCompilationContext {
        public CompilationContext(RuntimeEnvironment runtimeEnvironment) {
            super(runtimeEnvironment);
        }
    }
}

