/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.scl;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationContext;
import org.simantics.db.layer0.scl.SCLDatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.environment.AbstractLocalEnvironment;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.LocalEnvironment;
import org.simantics.scl.compiler.top.ExpressionEvaluator;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.MultiFunction;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExpressionCompilationRequest<CompilationContext extends AbstractExpressionCompilationContext, EvaluationContext>
implements Read<Function1<EvaluationContext, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExpressionCompilationRequest.class);
    protected static final Type RESOURCE = Types.con((String)"Simantics/DB", (String)"Resource");
    protected static final Type VARIABLE = Types.con((String)"Simantics/Variables", (String)"Variable");
    protected static Name PROPERTY_VALUE = Name.create((String)"Simantics/Variables", (String)"propertyValue");
    protected static Name VARIABLE_PARENT = Name.create((String)"Simantics/Variables", (String)"variableParent");
    protected static Name FROM_DOUBLE = Name.create((String)"Prelude", (String)"fromDouble");
    protected static Name TO_DOUBLE = Name.create((String)"Prelude", (String)"toDouble");
    protected static Name FROM_DYNAMIC = Name.create((String)"Prelude", (String)"fromDynamic");
    private static final Type DEFAULT_EXPECTED_EFFECT = Types.union((Type[])new Type[]{Types.PROC, Types.READ_GRAPH});

    protected abstract String getExpressionText(ReadGraph var1) throws DatabaseException;

    protected abstract CompilationContext getCompilationContext(ReadGraph var1) throws DatabaseException;

    protected abstract Type getContextVariableType();

    protected abstract Expression getVariableAccessExpression(ReadGraph var1, CompilationContext var2, Variable var3, String var4) throws DatabaseException;

    protected Type getExpectedType(ReadGraph graph, CompilationContext context) throws DatabaseException {
        return Types.metaVar((Kind)Kinds.STAR);
    }

    protected Type getExpectedEffect(ReadGraph graph, CompilationContext context) throws DatabaseException {
        return DEFAULT_EXPECTED_EFFECT;
    }

    private ExpressionEvaluator prepareEvaluator(final ReadGraph graph, CompilationContext context, Type expectedType) throws DatabaseException {
        Variable contextVariable = new Variable("context", this.getContextVariableType());
        AbstractLocalEnvironment localEnvironment = new AbstractLocalEnvironment((AbstractExpressionCompilationContext)context, contextVariable){
            THashMap<String, Pair<Variable, Expression>> precalculatedVariables = new THashMap();
            private final /* synthetic */ AbstractExpressionCompilationContext val$context;
            private final /* synthetic */ Variable val$contextVariable;
            {
                this.val$context = abstractExpressionCompilationContext;
                this.val$contextVariable = variable;
            }

            public Expression resolve(Environment environment, String localName) {
                Pair precalculatedVariable = (Pair)this.precalculatedVariables.get((Object)localName);
                if (precalculatedVariable == null) {
                    Expression value;
                    block4: {
                        try {
                            value = AbstractExpressionCompilationRequest.this.getVariableAccessExpression(graph, this.val$context, this.val$contextVariable, localName);
                            if (value != null) break block4;
                            return null;
                        }
                        catch (DatabaseException e) {
                            throw new RuntimeDatabaseException((Throwable)e);
                        }
                    }
                    Variable variable = new Variable(localName);
                    precalculatedVariable = Pair.make((Object)variable, (Object)value);
                    this.precalculatedVariables.put((Object)localName, (Object)precalculatedVariable);
                }
                return new EVariable((Variable)precalculatedVariable.first);
            }

            public Expression preDecorateExpression(Expression expression) {
                for (Pair precalculatedVariable : this.precalculatedVariables.values()) {
                    expression = new ESimpleLet((Variable)precalculatedVariable.first, (Expression)precalculatedVariable.second, expression);
                }
                return expression;
            }

            protected Variable[] getContextVariables() {
                return new Variable[]{this.val$contextVariable};
            }
        };
        String expressionText = this.getExpressionText(graph);
        return new ExpressionEvaluator(((AbstractExpressionCompilationContext)context).runtimeEnvironment, expressionText).localEnvironment((LocalEnvironment)localEnvironment).expectedType(expectedType).parseAsBlock(this.parseAsBlock());
    }

    protected boolean parseAsBlock() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private Function1<EvaluationContext, Object> eval(ExpressionEvaluator evaluator, ReadGraph graph) throws DatabaseException {
        oldGraph = SCLContext.getCurrent().put((Object)"graph", (Object)graph);
        try {
            var12_4 = (Function1)evaluator.eval();
            return var12_4;
        }
        catch (RuntimeDatabaseException e) {
            AbstractExpressionCompilationRequest.LOGGER.error("Failed to evaluate SCL expression", (Throwable)e);
            if (e.getCause() instanceof DatabaseException) {
                throw (DatabaseException)e.getCause();
            }
            throw e;
        }
        catch (SCLExpressionCompilationException e) {
            b = new StringBuilder();
            b.append("Couldn't compile '");
            b.append(evaluator.getExpressionText());
            b.append("':\n");
            b2 = new StringBuilder();
            var10_10 = e.getErrors();
            var9_11 = var10_10.length;
            var8_12 = 0;
            ** while (var8_12 < var9_11)
        }
lbl-1000:
        // 1 sources

        {
            error = var10_10[var8_12];
            b2.append(error.description);
            b2.append('\n');
            ++var8_12;
            continue;
        }
lbl30:
        // 1 sources

        System.err.println(String.valueOf(b.toString()) + b2.toString());
        throw new SCLDatabaseException(String.valueOf(b.toString()) + b2.toString(), b2.toString(), e.getErrors());
        catch (Throwable e) {
            AbstractExpressionCompilationRequest.LOGGER.error("This error should never happen", e);
            throw new RuntimeException(e);
        }
        finally {
            SCLContext.getCurrent().put((Object)"graph", oldGraph);
        }
    }

    public List<TCon> getExpressionEffects(ReadGraph graph) throws DatabaseException {
        CompilationContext context = this.getCompilationContext(graph);
        TMetaVar type = Types.metaVar((Kind)Kinds.STAR);
        this.eval(this.prepareEvaluator(graph, context, (Type)type), graph);
        try {
            MultiFunction mfun = Types.matchFunction((Type)type, (int)1);
            ArrayList<TCon> concreteEffects = new ArrayList<TCon>();
            mfun.effect.collectConcreteEffects(concreteEffects);
            return concreteEffects;
        }
        catch (MatchException e) {
            LOGGER.error("Failed to get expression effects", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Function1<EvaluationContext, Object> perform(ReadGraph graph) throws DatabaseException {
        CompilationContext context = this.getCompilationContext(graph);
        return this.eval(this.prepareEvaluator(graph, context, this.getExpectedType(graph, context)), graph);
    }

    protected static Expression getProperty(Environment environment, Expression variable, String propertyName, Type type) {
        return new EApply((Expression)new EConstant(environment.getValue(FROM_DYNAMIC), new Type[]{type}), (Expression)new EApply((Expression)new EConstant(environment.getValue(PROPERTY_VALUE), new Type[]{Types.DYNAMIC}), new Expression[]{variable, new ELiteral((Constant)new StringConstant(propertyName))}));
    }

    protected static Expression getPropertyFlexible(Environment environment, Expression variable, String propertyName, Type type) {
        return AbstractExpressionCompilationRequest.makeTypeFlexible(environment, AbstractExpressionCompilationRequest.getProperty(environment, variable, propertyName, type), type);
    }

    protected static Expression makeTypeFlexible(Environment environment, Expression base, Type originalType) {
        if (originalType.equals((Object)Types.DOUBLE)) {
            return new EApply((Expression)new EConstant(environment.getValue(FROM_DOUBLE)), base);
        }
        if (originalType.equals((Object)Types.FLOAT)) {
            return new EApply((Expression)new EConstant(environment.getValue(FROM_DOUBLE)), (Expression)new EApply((Expression)new EConstant(environment.getValue(TO_DOUBLE), new Type[]{Types.FLOAT}), base));
        }
        return base;
    }

    protected static String resolveExpectedValueType(ReadGraph graph, Resource predicate) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return (String)graph.getPossibleRelatedValue(predicate, L0.RequiresValueType, (Binding)Bindings.STRING);
    }
}

