/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.views.swt.ModelledView;

public class IssueView2
extends ModelledView {
    protected String configurationURI() {
        return "http://www.simantics.org/IssueUI-1.1/IssueView";
    }

    protected void inputChanged(IWorkbenchPart part, Object input) {
        this.updateViewDescription(input);
        super.inputChanged(part, input);
    }

    private void updateViewDescription(Object input) {
        if (input instanceof Resource) {
            Resource r = (Resource)input;
            ISessionContext ctx = this.getSessionContext();
            if (ctx != null) {
                try {
                    String desc = (String)ctx.getSession().syncRequest((Read)new ResourceRead<String>(r){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            Resource r = this.resource;
                            Resource config = this.getConfiguration(graph, r);
                            if (config != null) {
                                r = config;
                            }
                            return this.formName(graph, r);
                        }

                        private String formName(ReadGraph graph, Resource r) throws DatabaseException {
                            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                            Resource project = Simantics.getProjectResource();
                            String projectUri = project != null ? graph.getPossibleURI(project) : "";
                            String uri = graph.getPossibleURI(r);
                            if (uri != null && uri.startsWith(projectUri)) {
                                uri = uri.substring(projectUri.length());
                            }
                            return uri != null ? String.valueOf(name) + " (" + uri + ")" : name;
                        }

                        private Resource getConfiguration(ReadGraph graph, Resource r) throws DatabaseException {
                            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                            Resource diagram = graph.getPossibleObject(r, DIA.RuntimeDiagram_HasConfiguration);
                            if (diagram == null) {
                                return r;
                            }
                            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                            Resource config = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
                            if (config == null) {
                                return diagram;
                            }
                            return config;
                        }
                    });
                    this.setContentDescription(desc);
                }
                catch (DatabaseException e) {
                    this.setContentDescription(e.getMessage());
                }
            }
            this.setVisible(true);
        } else {
            this.setContentDescription("Issues not available.");
            this.setVisible(false);
        }
    }

    protected IPropertyPage getPropertyPage() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (GraphExplorer.class == adapter) {
            return (T)this.tryGetExplorer((Control)this.container);
        }
        if (BrowseContext.class == adapter) {
            return (T)this.tryGetBrowseContext((Control)this.container);
        }
        return (T)super.getAdapter(adapter);
    }

    private BrowseContext tryGetBrowseContext(Control control) {
        return (BrowseContext)SWTUtils.tryGetObject((Control)control, c -> c instanceof IAdaptable ? (BrowseContext)((IAdaptable)c).getAdapter(BrowseContext.class) : null);
    }

    private GraphExplorer tryGetExplorer(Control control) {
        return (GraphExplorer)SWTUtils.tryGetObject((Control)control, c -> c.isDisposed() ? null : (GraphExplorer)c.getData("GraphExplorer"));
    }
}

