/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.query;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.utils.page.PageDesc;

public class DiagramDescRead
extends ResourceRead<DiagramDesc> {
    public DiagramDescRead(Resource diagramResource) {
        super(diagramResource);
    }

    public DiagramDesc perform(ReadGraph graph) throws DatabaseException {
        PageDesc pdesc = DiagramGraphUtil.getPageDesc(graph, this.resource, null);
        if (pdesc == null) {
            return null;
        }
        double gridSize = DiagramGraphUtil.getGridSize(graph, this.resource, 1.0);
        boolean pageBordersVisible = DiagramGraphUtil.isPageBordersVisible(graph, this.resource);
        boolean marginsVisible = DiagramGraphUtil.isMarginsVisible(graph, this.resource);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        boolean displayGrid = DiagramGraphUtil.getDiagramTagPreference(graph, this.resource, DIA.DisplayGrid);
        boolean displayRuler = DiagramGraphUtil.getDiagramTagPreference(graph, this.resource, DIA.DisplayRuler);
        return new DiagramDesc(pdesc, gridSize, pageBordersVisible, marginsVisible, displayGrid, displayRuler);
    }
}

