/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.diagram.elements.ITextListener;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Rotate;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.TextEditor;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.handler.impl.BorderColorImpl;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.ParentImpl;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextEditorImpl;
import org.simantics.g2d.element.handler.impl.TextFontImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.MonitorHandler;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.ProviderUtils;
import org.simantics.g2d.image.impl.AbstractImage;
import org.simantics.g2d.utils.Alignment;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.strings.format.MetricsFormat;
import org.simantics.utils.strings.format.MetricsFormatList;

public class MonitorClass {
    static final Font FONT = Font.decode("Helvetica 12");
    public static final IHintContext.Key KEY_MONITOR_COMPONENT = new IHintContext.KeyOf(Object.class, "MONITOR_COMPONENT");
    public static final IHintContext.Key KEY_MONITOR_IS_EXTERNAL = new IHintContext.KeyOf(Boolean.class, "MONITOR_IS_EXTERNAL");
    public static final IHintContext.Key KEY_MONITOR_SUFFIX = new IHintContext.KeyOf(String.class, "MONITOR_SUFFIX");
    public static final IHintContext.Key KEY_MONITOR_SUBSTITUTIONS = new IHintContext.KeyOf(Map.class, "MONITOR_SUBSTITUTIONS");
    public static final IHintContext.Key KEY_MONITOR_GC = new IHintContext.KeyOf(Graphics2D.class, "MONITOR_GC");
    public static final IHintContext.Key KEY_MONITOR_HEIGHT = new IHintContext.KeyOf(Double.class, "MONITOR_HEIGHT");
    public static final IHintContext.Key KEY_NUMBER_FORMAT = new IHintContext.KeyOf(MetricsFormat.class, "NUMBER_FORMAT");
    public static final IHintContext.Key KEY_TOOLTIP_TEXT = new IHintContext.KeyOf(String.class, "TOOLTIP_TEXT");
    public static final IHintContext.Key KEY_EXPRESSION = new IHintContext.KeyOf(String.class, "EXPRESSION");
    public static final IHintContext.Key KEY_INPUT_VALIDATOR = new IHintContext.KeyOf(Object.class, "INPUT_VALIDATOR");
    public static final IHintContext.Key KEY_RVI = new IHintContext.KeyOf(RVI.class, "RVI");
    public static final IHintContext.Key KEY_DIRECTION = new IHintContext.KeyOf(Double.class, "MONITOR_DIRECTION");
    public static final IHintContext.Key KEY_BORDER_WIDTH = new IHintContext.KeyOf(Double.class, "MONITOR_BORDER");
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(TextNode.class, "MONITOR_SG_NODE");
    public static final IHintContext.Key KEY_SG_NODE2 = new SceneGraphNodeKey(ShapeNode.class, "MONITOR_SG_NODE2");
    static final BasicStroke STROKE = new BasicStroke(1.0f);
    public static final Alignment DEFAULT_HORIZONTAL_ALIGN = Alignment.CENTER;
    public static final Alignment DEFAULT_VERTICAL_ALIGN = Alignment.CENTER;
    public static final MetricsFormat DEFAULT_NUMBER_FORMAT = MetricsFormatList.METRICS_DECIMAL;
    public static final Color DEFAULT_FILL_COLOR = new Color(224, 224, 224);
    public static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    public static final double DEFAULT_HORIZONTAL_MARGIN = 5.0;
    public static final double DEFAULT_VERTICAL_MARGIN = 2.5;
    static final Rectangle2D DEFAULT_BOX = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    public static final Shape BOX_SHAPE = new Rectangle(-1, -1, 2, 2);
    static final IProvider<Image> MONITOR_IMAGE = ProviderUtils.reference((IProvider)ProviderUtils.cache((IFactory)ProviderUtils.rasterize((IProvider)new MonitorImageFactory(0.5, 0.5))));
    static final StaticSymbol MONITOR_SYMBOL = new StaticSymbolImpl((Image)MONITOR_IMAGE.get());
    static final FillColor FILL_COLOR = new FillColorImpl(DEFAULT_FILL_COLOR);
    static final ElementClass MONITOR_CLASS_BASE = ElementClass.compile((ElementHandler[])new ElementHandler[]{MonitorHandlerImpl.INSTANCE, Transformer.INSTANCE, BorderColorImpl.BLACK, FILL_COLOR, MonitorSGNode.INSTANCE, TextImpl.INSTANCE, TextEditorImpl.INSTANCE, TextFontImpl.DEFAULT, TextColorImpl.BLACK, SimpleElementLayers.INSTANCE, ParentImpl.INSTANCE});

    static Alignment getHorizontalAlignment(IElement e) {
        return (Alignment)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)ElementHints.KEY_HORIZONTAL_ALIGN, (Object)DEFAULT_HORIZONTAL_ALIGN);
    }

    static Alignment getVerticalAlignment(IElement e) {
        return (Alignment)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)ElementHints.KEY_VERTICAL_ALIGN, (Object)DEFAULT_VERTICAL_ALIGN);
    }

    static MetricsFormat getNumberFormat(IElement e) {
        return (MetricsFormat)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)KEY_NUMBER_FORMAT, (Object)DEFAULT_NUMBER_FORMAT);
    }

    static void setNumberFormat(IElement e, MetricsFormat f) {
        ElementUtils.setOrRemoveHint((IHintContext)e, (IHintContext.Key)KEY_NUMBER_FORMAT, (Object)f);
    }

    static double getHorizontalMargin(IElement e) {
        return 5.0;
    }

    static double getVerticalMargin(IElement e) {
        return 2.5;
    }

    static Font getFont(IElement e) {
        return (Font)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)ElementHints.KEY_FONT, (Object)FONT);
    }

    static String finalText(IElement e) {
        String text = ((Text)e.getElementClass().getSingleItem(Text.class)).getText(e);
        if (text == null) {
            return null;
        }
        return MonitorClass.substitute(text, e);
    }

    public static String editText(IElement e) {
        return MonitorClass.substitute("#v1", e);
    }

    private static String formValue(IElement e) {
        Map substitutions = (Map)e.getHint(KEY_MONITOR_SUBSTITUTIONS);
        if (substitutions != null) {
            String value = (String)substitutions.get("#v1");
            if (substitutions.containsKey("#u1") && ((String)substitutions.get("#u1")).length() > 0) {
                value = String.valueOf(value) + " " + (String)substitutions.get("#u1");
            }
            return value;
        }
        return ElementUtils.getText((IElement)e);
    }

    static String substitute(String text, IElement e) {
        Map substitutions = (Map)e.getHint(KEY_MONITOR_SUBSTITUTIONS);
        return MonitorClass.substitute(text, substitutions);
    }

    static String substitute(String text, Map<String, String> substitutions) {
        if (substitutions != null) {
            for (Map.Entry<String, String> entry : substitutions.entrySet()) {
                text = entry.getValue() != null ? text.replace(entry.getKey(), entry.getValue()) : text.replace(entry.getKey(), "<null>");
            }
        }
        return text;
    }

    public static void update(IElement e) {
        MonitorSGNode node = (MonitorSGNode)e.getElementClass().getSingleItem(MonitorSGNode.class);
        node.update(e);
    }

    public static void cleanup(IElement e) {
        MonitorSGNode node = (MonitorSGNode)e.getElementClass().getSingleItem(MonitorSGNode.class);
        node.cleanup(e);
    }

    public static boolean hasModifier(IElement e) {
        TextEditor.Modifier modifier;
        TextEditor editor = (TextEditor)e.getElementClass().getAtMostOneItemOfClass(TextEditor.class);
        TextEditor.Modifier modifier2 = modifier = editor != null ? editor.getModifier(e) : null;
        return modifier != null;
    }

    static Shape createMonitor(IElement e) {
        Alignment hAlign = MonitorClass.getHorizontalAlignment(e);
        Alignment vAlign = MonitorClass.getVerticalAlignment(e);
        double hMargin = MonitorClass.getHorizontalMargin(e);
        double vMargin = MonitorClass.getVerticalMargin(e);
        String text = MonitorClass.finalText(e);
        if (text == null) {
            return MonitorClass.align(hMargin, vMargin, hAlign, vAlign, DEFAULT_BOX);
        }
        Graphics2D g = (Graphics2D)e.getHint(KEY_MONITOR_GC);
        if (g == null) {
            return MonitorClass.align(hMargin, vMargin, hAlign, vAlign, DEFAULT_BOX);
        }
        Font f = MonitorClass.getFont(e);
        FontMetrics fm = g.getFontMetrics(f);
        Rectangle2D rect = fm.getStringBounds(text, g);
        return MonitorClass.align(hMargin, vMargin, hAlign, vAlign, rect);
    }

    static Shape align(double hMargin, double vMargin, Alignment hAlign, Alignment vAlign, Rectangle2D rect) {
        double tx = MonitorClass.align(hMargin, hAlign, rect.getMinX(), rect.getMaxX());
        double ty = MonitorClass.align(vMargin, vAlign, rect.getMinY(), rect.getMaxY());
        double nw = rect.getWidth() + 2.0 * hMargin;
        double nh = rect.getHeight() + 2.0 * vMargin;
        return MonitorClass.makePath(tx + rect.getMinX(), ty + rect.getMinY(), nw, nh);
    }

    static double align(double margin, Alignment align, double min, double max) {
        double s = max - min;
        switch (align) {
            case LEADING: {
                return -min;
            }
            case TRAILING: {
                return -s - 2.0 * margin - min;
            }
            case CENTER: {
                return -0.5 * s - margin - min;
            }
        }
        return 0.0;
    }

    static Path2D makePath(double x, double y, double w, double h) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x, y);
        ((Path2D)path).lineTo(x + w, y);
        ((Path2D)path).lineTo(x + w, y + h);
        ((Path2D)path).lineTo(x, y + h);
        path.closePath();
        return path;
    }

    static double getOrientationDelta(IElement e, AffineTransform tr) {
        Double angle = (Double)e.getHint(KEY_DIRECTION);
        if (angle == null || Double.isNaN(angle)) {
            return Double.NaN;
        }
        double angrad = Math.toRadians(angle);
        Vector2D forcedAxis = new Vector2D(Math.cos(angrad), Math.sin(angrad));
        Vector2D x = new Vector2D(tr.getScaleX(), tr.getShearX()).normalize();
        double cosa = forcedAxis.dotProduct((Vector)x);
        double delta = Math.acos(cosa);
        return delta;
    }

    public static ElementClass create(double staticScaleX, double staticScaleY, ElementHandler ... extraHandlers) {
        IFactory staticMonitorSymbolProvider = ProviderUtils.reference((IProvider)ProviderUtils.cache((IFactory)ProviderUtils.rasterize((IProvider)new MonitorImageFactory(staticScaleX, staticScaleY))));
        StaticSymbolImpl staticMonitorSymbol = new StaticSymbolImpl((Image)staticMonitorSymbolProvider.get());
        return MONITOR_CLASS_BASE.newClassWith(new ElementHandler[]{staticMonitorSymbol}).newClassWith(extraHandlers);
    }

    public static ElementClass create(IElement parentElement, Map<String, String> substitutions, Object component, String suffix, double staticScaleX, double staticScaleY, ElementHandler ... extraHandlers) {
        return MonitorClass.create(staticScaleX, staticScaleY, extraHandlers).newClassWith(new ElementHandler[]{new Initializer(parentElement, substitutions, component, suffix, parentElement == null)});
    }

    public static Shape arrow(double length, double width, double space) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(-space, 0.0);
        path.lineTo(-length - space, -width);
        path.lineTo(-length - space, width);
        path.closePath();
        return path;
    }

    static class Initializer
    implements LifeCycle {
        private static final long serialVersionUID = 4404942036933073584L;
        IElement parentElement;
        Map<String, String> substitutions;
        Object component;
        String suffix;
        boolean hack;

        Initializer(IElement parentElement, Map<String, String> substitutions, Object component, String suffix, boolean hack) {
            this.parentElement = parentElement;
            this.substitutions = substitutions;
            this.component = component;
            this.suffix = suffix;
            this.hack = hack;
        }

        public void onElementActivated(IDiagram d, IElement e) {
            if (!this.hack) {
                this.hack = true;
                Point2D parentPos = ElementUtils.getPos((IElement)this.parentElement);
                Point2D thisPos = ElementUtils.getPos((IElement)e);
                Move move = (Move)e.getElementClass().getSingleItem(Move.class);
                move.moveTo(e, thisPos.getX() - parentPos.getX(), thisPos.getY() - parentPos.getY());
            }
        }

        public void onElementCreated(IElement e) {
            if (this.parentElement != null) {
                e.setHint(ElementHints.KEY_PARENT_ELEMENT, (Object)this.parentElement);
            }
            if (this.substitutions != null) {
                e.setHint(KEY_MONITOR_SUBSTITUTIONS, this.substitutions);
            }
            if (this.component != null) {
                e.setHint(KEY_MONITOR_COMPONENT, this.component);
            }
            if (this.suffix != null) {
                e.setHint(KEY_MONITOR_SUFFIX, (Object)this.suffix);
            }
            e.setHint(KEY_DIRECTION, (Object)0.0);
            e.setHint(KEY_NUMBER_FORMAT, (Object)DEFAULT_NUMBER_FORMAT);
        }

        public void onElementDestroyed(IElement e) {
        }

        public void onElementDeactivated(IDiagram d, IElement e) {
        }
    }

    public static class MonitorHandlerImpl
    implements MonitorHandler {
        private static final long serialVersionUID = -4258875745321808416L;
        public static final MonitorHandler INSTANCE = new MonitorHandlerImpl();
    }

    static class MonitorImageFactory
    implements IFactory<Image> {
        private double staticScaleX = 1.0;
        private double staticScaleY = 1.0;

        public MonitorImageFactory(double staticScaleX, double staticScaleY) {
            this.staticScaleX = staticScaleX;
            this.staticScaleY = staticScaleY;
        }

        public Image get() throws ProvisionException {
            return new Img();
        }

        public class Img
        extends AbstractImage {
            Shape path;

            public Img() {
                this.path = MonitorClass.align(5.0, 2.5, DEFAULT_HORIZONTAL_ALIGN, DEFAULT_VERTICAL_ALIGN, new Rectangle2D.Double(0.0, 0.0, 50.0 * MonitorImageFactory.this.staticScaleX, 22.0 * MonitorImageFactory.this.staticScaleY));
            }

            public int hashCode() {
                long temp = Double.doubleToLongBits(MonitorImageFactory.this.staticScaleX);
                int result = (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(MonitorImageFactory.this.staticScaleY);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (((Object)((Object)this)).getClass() != obj.getClass()) {
                    return false;
                }
                MonitorImageFactory other = (MonitorImageFactory)obj;
                return Double.doubleToLongBits(MonitorImageFactory.this.staticScaleX) == Double.doubleToLongBits(other.staticScaleX) && Double.doubleToLongBits(MonitorImageFactory.this.staticScaleY) != Double.doubleToLongBits(other.staticScaleY);
            }

            public Rectangle2D getBounds() {
                return this.path.getBounds2D();
            }

            public EnumSet<Image.Feature> getFeatures() {
                return EnumSet.of(Image.Feature.Vector);
            }

            public Shape getOutline() {
                return this.path;
            }

            public Node init(G2DParentNode parent) {
                TextNode node = (TextNode)((Object)parent.getOrCreateNode("" + this.hashCode(), TextNode.class));
                node.init("Drop Me", FONT, Color.BLACK, 0.0, 0.0, 0.2);
                node.setBorderWidth(1.0f);
                node.setTransform(AffineTransform.getScaleInstance(MonitorImageFactory.this.staticScaleX, MonitorImageFactory.this.staticScaleY));
                node.setEditable(false);
                return node;
            }
        }
    }

    public static class MonitorSGNode
    implements SceneGraph,
    InternalSize,
    Outline {
        private static final long serialVersionUID = -106278359626957687L;
        static final MonitorSGNode INSTANCE = new MonitorSGNode();

        public void init(final IElement e, G2DParentNode parent) {
            ShapeNode shape;
            Boolean isExternal;
            TextNode node = (TextNode)((Object)e.getHint(KEY_SG_NODE));
            String nodeId = null;
            if (node == null || node.getBounds() == null || node.getParent() != parent) {
                Double border_width;
                RVI rvi;
                nodeId = ElementUtils.generateNodeId((IElement)e);
                node = (TextNode)((Object)parent.addNode(nodeId, TextNode.class));
                e.setHint(KEY_SG_NODE, (Object)node);
                node.setTextListener(new ITextListener(){
                    boolean isEndingEdit = false;

                    @Override
                    public void textChanged() {
                    }

                    @Override
                    public void textEditingStarted() {
                    }

                    @Override
                    public void textEditingCancelled() {
                    }

                    @Override
                    public void textEditingEnded() {
                        TextNode node = (TextNode)((Object)e.getHint(KEY_SG_NODE));
                        if (node == null) {
                            return;
                        }
                        if (this.isEndingEdit) {
                            return;
                        }
                        this.isEndingEdit = true;
                        try {
                            TextEditor.Modifier modifier;
                            TextEditor editor = (TextEditor)e.getElementClass().getAtMostOneItemOfClass(TextEditor.class);
                            if (editor != null && (modifier = editor.getModifier(e)) != null) {
                                String newValue = node.getText();
                                String error = modifier.isValid(e, newValue);
                                if (error == null) {
                                    modifier.modify(e, newValue);
                                } else {
                                    node.setText(MonitorClass.formValue(e));
                                }
                            }
                        }
                        finally {
                            this.isEndingEdit = false;
                        }
                    }
                });
                Object validator = e.getHint(KEY_INPUT_VALIDATOR);
                if (validator != null) {
                    node.setValidator((Function1<String, String>)((Function1)validator));
                }
                if ((rvi = (RVI)e.getHint(KEY_RVI)) != null) {
                    node.setRVI(rvi);
                }
                if ((border_width = (Double)e.getHint(KEY_BORDER_WIDTH)) == null) {
                    border_width = 0.1;
                }
                node.setBorderWidth(border_width);
                Font font = ElementUtils.getTextFont((IElement)e);
                Color color = ElementUtils.getTextColor((IElement)e);
                String text = ElementUtils.getText((IElement)e);
                node.init(text, font, color, 0.0, 0.0, 1.0);
            }
            if (Boolean.TRUE.equals(isExternal = (Boolean)e.getHint(KEY_MONITOR_IS_EXTERNAL))) {
                shape = (ShapeNode)e.getHint(KEY_SG_NODE2);
                if (shape == null || shape.getParent() != parent) {
                    if (nodeId == null) {
                        nodeId = ElementUtils.generateNodeId((IElement)e);
                    }
                    nodeId = String.valueOf(nodeId) + "-ext";
                    shape = (ShapeNode)parent.addNode(nodeId, ShapeNode.class);
                    shape.setZIndex(-1);
                    shape.setColor((Paint)Color.BLACK);
                    shape.setFill(true);
                    shape.setStroke(null);
                    shape.setShape(MonitorClass.arrow(4.0, 2.0, 0.0));
                    e.setHint(KEY_SG_NODE2, (Object)shape);
                }
            } else {
                shape = (ShapeNode)e.getHint(KEY_SG_NODE2);
                if (shape != null) {
                    shape.remove();
                }
            }
            this.update(e);
        }

        public void update(IElement e) {
            String value = null;
            Text t = (Text)e.getElementClass().getAtMostOneItemOfClass(Text.class);
            assert (t != null);
            value = MonitorClass.formValue(e);
            TextNode node = (TextNode)((Object)e.getHint(KEY_SG_NODE));
            if (node != null && value != null) {
                ShapeNode shape;
                Alignment valign;
                Alignment halign;
                node.setText(value);
                Object component = e.getHint(KEY_MONITOR_COMPONENT);
                if (component != null && MonitorClass.hasModifier(e)) {
                    node.setEditable(true);
                } else {
                    node.setEditable(false);
                }
                Font font = ElementUtils.getTextFont((IElement)e);
                if (node.getFont() != font) {
                    node.setFont(font);
                }
                Color color = ElementUtils.getTextColor((IElement)e);
                node.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
                AffineTransform at = ElementUtils.getTransform((IElement)e);
                if (at != null) {
                    node.setTransform(at);
                }
                if ((halign = (Alignment)e.getHint(ElementHints.KEY_HORIZONTAL_ALIGN)) != null) {
                    node.setHorizontalAlignment((byte)halign.ordinal());
                }
                if ((valign = (Alignment)e.getHint(ElementHints.KEY_VERTICAL_ALIGN)) != null) {
                    node.setVerticalAlignment((byte)valign.ordinal());
                }
                if ((shape = (ShapeNode)e.getHint(KEY_SG_NODE2)) != null) {
                    AffineTransform at2 = new AffineTransform(at);
                    Rectangle2D bounds = node.getBoundsInLocal();
                    at2.translate(bounds.getMinX(), bounds.getCenterY());
                    shape.setTransform(at2);
                }
            }
        }

        public void cleanup(IElement e) {
            TextNode node = (TextNode)((Object)e.removeHint(KEY_SG_NODE));
            if (node != null) {
                node.remove();
            }
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            Rectangle2D bounds;
            TextNode node = (TextNode)((Object)e.getHint(KEY_SG_NODE));
            if (node != null && (bounds = node.getBoundsInLocal()) != null) {
                if (size == null) {
                    size = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                }
                size.setRect(bounds);
            }
            return size;
        }

        public Shape getElementShape(IElement e) {
            Rectangle2D shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            TextNode node = (TextNode)((Object)e.getHint(KEY_SG_NODE));
            if (node != null && node.getBoundsInLocal() != null) {
                shape = node.getBoundsInLocal();
            }
            return shape;
        }
    }

    public static class Transformer
    implements Transform,
    Move,
    Rotate,
    Scale,
    LifeCycle {
        private static final long serialVersionUID = -3704887325602085677L;
        public static final Transformer INSTANCE = new Transformer(null);
        Double aspectRatio;

        public Transformer() {
            this(null);
        }

        public Transformer(Double aspectRatio) {
            this.aspectRatio = aspectRatio;
        }

        public Double getFixedAspectRatio(IElement e) {
            return this.aspectRatio;
        }

        public Point2D getScale(IElement e) {
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            return Transformer._getScale(at);
        }

        public void setScale(IElement e, Point2D newScale) {
            Point2D oldScale = this.getScale(e);
            double sx = newScale.getX() / oldScale.getX();
            double sy = newScale.getY() / oldScale.getY();
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            at = new AffineTransform(at);
            at.scale(sx, sy);
            e.setHint(ElementHints.KEY_TRANSFORM, (Object)at);
        }

        public Point2D getMaximumScale(IElement e) {
            return null;
        }

        public Point2D getMinimumScale(IElement e) {
            return null;
        }

        private static Point2D _getScale(AffineTransform at) {
            double m00 = at.getScaleX();
            double m11 = at.getScaleY();
            double m10 = at.getShearY();
            double m01 = at.getShearX();
            double sx = Math.sqrt(m00 * m00 + m10 * m10);
            double sy = Math.sqrt(m01 * m01 + m11 * m11);
            return new Point2D.Double(sx, sy);
        }

        public void rotate(IElement e, double theta, Point2D origin) {
            if (Double.isNaN(theta)) {
                return;
            }
            theta = Math.toDegrees(theta);
            Double angle = (Double)e.getHint(KEY_DIRECTION);
            double newAngle = angle != null ? angle + theta : theta;
            newAngle = Math.IEEEremainder(newAngle, 360.0);
            e.setHint(KEY_DIRECTION, (Object)newAngle);
        }

        public double getAngle(IElement e) {
            Double angle = (Double)e.getHint(KEY_DIRECTION);
            return angle != null ? Math.toRadians(angle) : 0.0;
        }

        public Point2D getPosition(IElement e) {
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            Point2D.Double p = new Point2D.Double(at.getTranslateX(), at.getTranslateY());
            return p;
        }

        public void moveTo(IElement e, double x, double y) {
            AffineTransform origAt = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            AffineTransform result = new AffineTransform(origAt);
            result.preConcatenate(AffineTransform.getTranslateInstance(x - origAt.getTranslateX(), y - origAt.getTranslateY()));
            e.setHint(ElementHints.KEY_TRANSFORM, (Object)result);
        }

        public AffineTransform getTransform(IElement e) {
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            IElement parentElement = (IElement)e.getHint(ElementHints.KEY_PARENT_ELEMENT);
            if (parentElement == null) {
                return at;
            }
            Transform parentTransform = (Transform)parentElement.getElementClass().getSingleItem(Transform.class);
            assert (parentTransform != null);
            AffineTransform result = (AffineTransform)at.clone();
            AffineTransform parentAT = parentTransform.getTransform(parentElement);
            result.preConcatenate(AffineTransform.getTranslateInstance(parentAT.getTranslateX(), parentAT.getTranslateY()));
            return result;
        }

        public void setTransform(IElement e, AffineTransform at) {
            e.setHint(ElementHints.KEY_TRANSFORM, at.clone());
        }

        public void onElementActivated(IDiagram d, IElement e) {
        }

        public void onElementCreated(IElement e) {
            e.setHint(ElementHints.KEY_TRANSFORM, (Object)new AffineTransform());
        }

        public void onElementDeactivated(IDiagram d, IElement e) {
        }

        public void onElementDestroyed(IElement e) {
        }
    }
}

