/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.xmile;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Dependency;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.EnumerationIndex;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Valve;
import org.simantics.sysdyn.representation.expressions.IExpression;
import org.simantics.sysdyn.representation.expressions.NormalExpression;
import org.simantics.sysdyn.representation.expressions.ParameterExpression;
import org.simantics.sysdyn.representation.expressions.StockExpression;
import org.simantics.sysdyn.representation.expressions.WithLookupExpression;
import org.simantics.sysdyn.xmile.XmileUtil;
import org.simantics.sysdyn.xmile.schema.Auxiliary;
import org.simantics.sysdyn.xmile.schema.Dimensions;
import org.simantics.sysdyn.xmile.schema.Flow;
import org.simantics.sysdyn.xmile.schema.Gf;
import org.simantics.sysdyn.xmile.schema.Header;
import org.simantics.sysdyn.xmile.schema.Model;
import org.simantics.sysdyn.xmile.schema.ObjectFactory;
import org.simantics.sysdyn.xmile.schema.Options;
import org.simantics.sysdyn.xmile.schema.PointsType;
import org.simantics.sysdyn.xmile.schema.Product;
import org.simantics.sysdyn.xmile.schema.SimSpecs;
import org.simantics.sysdyn.xmile.schema.Stock;
import org.simantics.sysdyn.xmile.schema.Variables;
import org.simantics.sysdyn.xmile.schema.ViewContentType;
import org.simantics.sysdyn.xmile.schema.Views;
import org.simantics.sysdyn.xmile.schema.Xmile;

public class ModelTransform
implements Read<Xmile> {
    private Resource source;
    private ObjectFactory factory;
    private boolean includeView;
    private SysdynModel sourceModel;
    private DiagramResource dr;
    private Layer0 l0;
    private ModelingResources mr;
    private SimulationResource sim;
    private SysdynResource sr;
    private static final double version = 1.0;
    private static final String HEADER_VENDOR = "Simantics";
    private static final String HEADER_PRODUCT_NAME = "System Dynamics";
    private static final String HEADER_PRODUCT_VERSION = "0.1";
    private static final String SPECS_SOLVER = "euler";
    private boolean usesArrays = false;
    private int usesArraysMaxDimensions = 0;
    private boolean usesSubmodels = false;
    private boolean usesMacros = false;
    private int connectorId = 0;

    public ModelTransform(Resource source) {
        this(source, true);
    }

    public ModelTransform(Resource source, boolean includeView) {
        this.source = source;
        this.factory = new ObjectFactory();
        this.includeView = includeView;
    }

    public Xmile perform(ReadGraph graph) throws DatabaseException {
        this.dr = DiagramResource.getInstance((ReadGraph)graph);
        this.l0 = Layer0.getInstance((ReadGraph)graph);
        this.mr = ModelingResources.getInstance((ReadGraph)graph);
        this.sim = SimulationResource.getInstance((ReadGraph)graph);
        this.sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource configuration = graph.getSingleObject(this.source, this.sim.HasConfiguration);
        this.sourceModel = SysdynModelManager.getInstance((Session)graph.getSession()).getModel(graph, configuration);
        return this.getDocument(graph);
    }

    private Xmile getDocument(ReadGraph graph) throws DatabaseException {
        Xmile xmile = this.factory.createXmile();
        xmile.setVersion(BigDecimal.valueOf(1.0));
        xmile.setHeader(this.getHeader(graph));
        xmile.getSimSpecsOrModelUnitsOrBehavior().add(this.getSimulationSpecifications());
        Xmile.Dimensions dims = this.getDimensions();
        if (dims != null) {
            xmile.getSimSpecsOrModelUnitsOrBehavior().add(dims);
        }
        xmile.getSimSpecsOrModelUnitsOrBehavior().addAll(this.getModels(graph));
        xmile.getHeader().setOptions(this.getOptions());
        return xmile;
    }

    private Header getHeader(ReadGraph graph) throws DatabaseException {
        Header header = this.factory.createHeader();
        header.setVendor(HEADER_VENDOR);
        Product product = this.factory.createProduct();
        product.setValue(HEADER_PRODUCT_NAME);
        product.setVersion(HEADER_PRODUCT_VERSION);
        header.setProduct(product);
        Resource model = this.sourceModel.getMapping().inverseGet((Object)this.sourceModel.getConfiguration().getModel());
        String name = (String)graph.getRelatedValue(model, this.l0.HasName, (Binding)Bindings.STRING);
        header.setName(name);
        return header;
    }

    private Options getOptions() {
        Options options = this.factory.createOptions();
        if (this.usesArrays) {
            options.setUsesArrays(this.factory.createOptionsUsesArrays());
            options.getUsesArrays().setMaxDimensions(BigInteger.valueOf(this.usesArraysMaxDimensions));
        }
        if (this.usesSubmodels) {
            options.setUsesSubmodels(this.factory.createEmptyType());
        }
        if (this.usesMacros) {
            options.setUsesMacros(this.factory.createOptionsUsesMacros());
            options.getUsesMacros().setReferencesMacros(false);
            options.getUsesMacros().setOptionFilters(false);
        }
        if (this.includeView) {
            options.setHasModelView(this.factory.createEmptyType());
        }
        return options;
    }

    private SimSpecs getSimulationSpecifications() {
        SimSpecs specs = this.factory.createSimSpecs();
        specs.setMethod(SPECS_SOLVER);
        org.simantics.sysdyn.representation.Model model = this.sourceModel.getConfiguration().getModel();
        specs.setStart(model.getStartTime());
        specs.setStop(model.getStopTime());
        specs.setDt(this.factory.createSimSpecsDt());
        specs.getDt().setValue(model.getSimulationStepLength());
        return specs;
    }

    private Xmile.Dimensions getDimensions() {
        Xmile.Dimensions dimensions = this.factory.createXmileDimensions();
        for (IElement element : this.sourceModel.getConfiguration().getElements()) {
            if (!(element instanceof Enumeration)) continue;
            Enumeration enumeration = (Enumeration)element;
            Xmile.Dimensions.Dim dim = this.factory.createXmileDimensionsDim();
            dim.setName(enumeration.getName());
            for (EnumerationIndex index : enumeration.getEnumerationIndexes()) {
                Xmile.Dimensions.Dim.Elem elem = this.factory.createXmileDimensionsDimElem();
                elem.setName(index.getName());
                dim.getElem().add(elem);
            }
            dimensions.getDim().add(dim);
            this.usesArrays = true;
            this.usesArraysMaxDimensions = Math.max(this.usesArraysMaxDimensions, enumeration.getEnumerationIndexes().size());
        }
        return dimensions.getDim().isEmpty() ? null : dimensions;
    }

    private List<Model> getModels(ReadGraph graph) throws DatabaseException {
        ArrayList<Model> models = new ArrayList<Model>();
        for (Configuration configuration : this.sourceModel.getModules()) {
        }
        Model model = this.factory.createModel();
        model.setVariables(this.getVariables(this.sourceModel.getConfiguration()));
        if (this.includeView) {
            model.setViews(this.getViews(graph, this.sourceModel.getConfiguration()));
        }
        models.add(model);
        return models;
    }

    private Variables getVariables(Configuration configuration) throws DatabaseException {
        Variables variables = this.factory.createVariables();
        for (IElement element : configuration.getElements()) {
            Object variable;
            if (element instanceof org.simantics.sysdyn.representation.Auxiliary) {
                variable = this.getAuxiliary((org.simantics.sysdyn.representation.Auxiliary)element);
            } else if (element instanceof Valve) {
                variable = this.getFlow((Valve)element);
            } else {
                if (!(element instanceof org.simantics.sysdyn.representation.Stock)) continue;
                variable = this.getStock((org.simantics.sysdyn.representation.Stock)element);
            }
            variables.getStockOrFlowOrAuxiliary().add(variable);
        }
        return variables;
    }

    private Views getViews(ReadGraph graph, Configuration configuration) throws DatabaseException {
        Views views = this.factory.createViews();
        Views.View view = this.factory.createViewsView();
        views.getStyleOrView().add(view);
        for (IElement element : configuration.getElements()) {
            Object obj;
            Resource res = this.sourceModel.getMapping().inverseGet((Object)element);
            if (element instanceof org.simantics.sysdyn.representation.Auxiliary) {
                obj = this.getViewAuxiliary(graph, res);
            } else if (element instanceof Valve) {
                obj = this.getViewFlow(graph, res);
            } else if (element instanceof org.simantics.sysdyn.representation.Stock) {
                obj = this.getViewStock(graph, res);
            } else {
                if (!(element instanceof Dependency)) continue;
                obj = this.getViewConnector(graph, res);
            }
            view.getStyleOrStockOrFlow().add(obj);
        }
        return views;
    }

    private Auxiliary getAuxiliary(org.simantics.sysdyn.representation.Auxiliary auxVar) throws DatabaseException {
        Auxiliary aux = this.factory.createAuxiliary();
        aux.setName(auxVar.getName());
        String desc = auxVar.getDescription();
        if (desc != null && !desc.isEmpty()) {
            aux.getEqnOrMathmlOrUnits().add(this.factory.createAuxiliaryDoc(desc));
        }
        if (!auxVar.getArrayIndexes().isEmpty()) {
            Dimensions dims = this.factory.createDimensions();
            for (Enumeration enumeration : auxVar.getArrayIndexes()) {
                Dimensions.Dim dim = this.factory.createDimensionsDim();
                dim.setName(enumeration.getName());
                dims.getDim().add(dim);
            }
            aux.getEqnOrMathmlOrUnits().add(dims);
        }
        if (auxVar.getExpressions().size() == 1) {
            aux.getEqnOrMathmlOrUnits().addAll(this.parseExpression(Auxiliary.class, (IExpression)auxVar.getExpressions().get(0)));
        } else {
            for (IExpression expression : auxVar.getExpressions()) {
                Auxiliary.Element element = this.factory.createAuxiliaryElement();
                StringBuilder subscript = new StringBuilder();
                String[] stringArray = expression.getArrayIndices();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String index = stringArray[n2];
                    if (subscript.length() > 0) {
                        subscript.append(',');
                    }
                    subscript.append(index);
                    ++n2;
                }
                element.setSubscript(subscript.toString());
                element.getEqnOrMathmlOrGf().addAll(this.parseExpression(Auxiliary.Element.class, expression));
                aux.getEqnOrMathmlOrUnits().add(this.factory.createAuxiliaryElement(element));
            }
        }
        return aux;
    }

    private Flow getFlow(Valve valveVar) throws DatabaseException {
        Flow flow = this.factory.createFlow();
        flow.setName(valveVar.getName());
        String desc = valveVar.getDescription();
        if (desc != null && !desc.isEmpty()) {
            flow.getEqnOrMathmlOrUnits().add(this.factory.createAuxiliaryDoc(desc));
        }
        IExpression expression = (IExpression)valveVar.getExpressions().get(0);
        flow.getEqnOrMathmlOrUnits().addAll(this.parseExpression(Flow.class, expression));
        return flow;
    }

    private Stock getStock(org.simantics.sysdyn.representation.Stock stockVar) throws DatabaseException {
        Stock stock = this.factory.createStock();
        stock.setName(stockVar.getName());
        String desc = stockVar.getDescription();
        if (desc != null && !desc.isEmpty()) {
            stock.getEqnOrMathmlOrUnits().add(this.factory.createAuxiliaryDoc(desc));
        }
        IExpression expression = (IExpression)stockVar.getExpressions().get(0);
        stock.getEqnOrMathmlOrUnits().addAll(this.parseExpression(Stock.class, expression));
        for (Valve valve : stockVar.getIncomingValves()) {
            JAXBElement<String> inflow = this.factory.createStockElementInflow(valve.getName());
            stock.getEqnOrMathmlOrUnits().add(inflow);
        }
        for (Valve valve : stockVar.getOutgoingValves()) {
            JAXBElement<String> outflow = this.factory.createStockElementOutflow(valve.getName());
            stock.getEqnOrMathmlOrUnits().add(outflow);
        }
        return stock;
    }

    private ViewContentType.Aux getViewAuxiliary(ReadGraph graph, Resource auxRes) throws DatabaseException {
        ViewContentType.Aux aux = this.factory.createViewContentTypeAux();
        String name = (String)graph.getRelatedValue(auxRes, this.l0.HasName, (Binding)Bindings.STRING);
        aux.setName(name);
        aux.setX(this.getComponentX(graph, auxRes));
        aux.setY(this.getComponentY(graph, auxRes));
        return aux;
    }

    private ViewContentType.Flow getViewFlow(ReadGraph graph, Resource valveRes) throws DatabaseException {
        ViewContentType.Flow flow = this.factory.createViewContentTypeFlow();
        String name = (String)graph.getRelatedValue(valveRes, this.l0.HasName, (Binding)Bindings.STRING);
        flow.setName(name);
        ViewContentType.Flow.Pts points = this.factory.createViewContentTypeFlowPts();
        for (Resource res : graph.getObjects(valveRes, this.sr.Variable_isHeadOf)) {
            if (!graph.isInstanceOf(res, this.sr.Flow)) continue;
            Resource tail = graph.getSingleObject(res, this.sr.Variable_HasTail);
            ViewContentType.Flow.Pts.Pt start = this.factory.createViewContentTypeFlowPtsPt();
            start.setX(this.getComponentX(graph, tail));
            start.setY(this.getComponentY(graph, tail));
            points.getPt().add(start);
            break;
        }
        for (Resource res : graph.getObjects(valveRes, this.sr.Variable_isTailOf)) {
            if (!graph.isInstanceOf(res, this.sr.Flow)) continue;
            Resource head = graph.getSingleObject(res, this.sr.Variable_HasHead);
            ViewContentType.Flow.Pts.Pt end = this.factory.createViewContentTypeFlowPtsPt();
            end.setX(this.getComponentX(graph, head));
            end.setY(this.getComponentY(graph, head));
            points.getPt().add(end);
            break;
        }
        flow.setPts(points);
        flow.setX(this.getComponentX(graph, valveRes));
        flow.setY(this.getComponentY(graph, valveRes));
        return flow;
    }

    private ViewContentType.Stock getViewStock(ReadGraph graph, Resource stockRes) throws DatabaseException {
        ViewContentType.Stock stock = this.factory.createViewContentTypeStock();
        String name = (String)graph.getRelatedValue(stockRes, this.l0.HasName, (Binding)Bindings.STRING);
        stock.setName(name);
        stock.setX(this.getComponentX(graph, stockRes));
        stock.setY(this.getComponentY(graph, stockRes));
        return stock;
    }

    private ViewContentType.Connector getViewConnector(ReadGraph graph, Resource depRes) throws DatabaseException {
        ViewContentType.Connector connector = this.factory.createViewContentTypeConnector();
        connector.setUid(this.connectorId++);
        connector.setX(1.0);
        connector.setY(1.0);
        Resource head = graph.getSingleObject(depRes, this.sr.Variable_HasHead);
        Resource tail = graph.getSingleObject(depRes, this.sr.Variable_HasTail);
        String headName = (String)graph.getRelatedValue(head, this.l0.HasName, (Binding)Bindings.STRING);
        String tailName = (String)graph.getRelatedValue(tail, this.l0.HasName, (Binding)Bindings.STRING);
        ViewContentType.Connector.From from = this.factory.createViewContentTypeConnectorFrom();
        from.getContent().add((Serializable)((Object)tailName));
        connector.setFrom(from);
        connector.setTo(headName);
        return connector;
    }

    private double getComponentX(ReadGraph graph, Resource comp) throws DatabaseException {
        Resource symbol = graph.getSingleObject(comp, this.mr.ComponentToElement);
        double[] transform = (double[])graph.getRelatedValue(symbol, this.dr.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
        return transform[4];
    }

    private double getComponentY(ReadGraph graph, Resource comp) throws DatabaseException {
        Resource symbol = graph.getSingleObject(comp, this.mr.ComponentToElement);
        double[] transform = (double[])graph.getRelatedValue(symbol, this.dr.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
        return transform[5];
    }

    private List<Object> parseExpression(Class<?> varType, IExpression expression) throws DatabaseException {
        Object eqn;
        String exprStr;
        NormalExpression expr;
        ArrayList<Object> exprObjs = new ArrayList<Object>();
        if (expression instanceof NormalExpression) {
            expr = (NormalExpression)expression;
            exprStr = expr.getExpression();
        } else if (expression instanceof ParameterExpression) {
            expr = (ParameterExpression)expression;
            exprStr = expr.getValue().toString();
        } else if (expression instanceof WithLookupExpression) {
            expr = (WithLookupExpression)expression;
            Gf gf = this.factory.createGf();
            double[] points = expr.getPoints();
            StringBuilder xPts = new StringBuilder();
            StringBuilder yPts = new StringBuilder();
            int i = 0;
            while (i < points.length / 2) {
                if (i > 0) {
                    xPts.append(',');
                    yPts.append(',');
                }
                xPts.append(points[2 * i]);
                yPts.append(points[2 * i + 1]);
                ++i;
            }
            PointsType xPtsType = this.factory.createPointsType();
            PointsType yPtsType = this.factory.createPointsType();
            xPtsType.setValue(xPts.toString());
            yPtsType.setValue(yPts.toString());
            gf.setXpts(xPtsType);
            gf.setYpts(yPtsType);
            exprObjs.add(gf);
            exprStr = expr.getLookupEquation();
        } else if (expression instanceof StockExpression) {
            expr = (StockExpression)expression;
            exprStr = expr.getExpression();
        } else {
            throw new DatabaseException("unrecognized expression type");
        }
        try {
            eqn = this.getEqn(varType, XmileUtil.modelicaExprToXmile(exprStr));
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
        exprObjs.add(eqn);
        return exprObjs;
    }

    private Object getEqn(Class<?> varType, String equation) {
        if (varType.equals(Auxiliary.class)) {
            return this.factory.createAuxiliaryEqn(equation);
        }
        if (varType.equals(Auxiliary.Element.class)) {
            return this.factory.createAuxiliaryElementEqn(equation);
        }
        if (varType.equals(Flow.class)) {
            return this.factory.createFlowEqn(equation);
        }
        if (varType.equals(Flow.Element.class)) {
            return this.factory.createFlowElementEqn(equation);
        }
        if (varType.equals(Stock.class)) {
            return this.factory.createStockEqn(equation);
        }
        if (varType.equals(Stock.Element.class)) {
            return this.factory.createStockElementEqn(equation);
        }
        return null;
    }
}

