/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.image.impl;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.AbstractImage;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;

public class ShapeImage
extends AbstractImage
implements Image {
    private static final EnumSet<Image.Feature> defaultFeats = VECTOR;
    Shape shape;
    Paint paint;
    Stroke stroke;
    EnumSet<Image.Feature> feats;
    boolean scaleStroke = false;

    public ShapeImage(Shape shape, Paint fill, Stroke stroke) {
        this(shape, fill, stroke, defaultFeats);
    }

    public ShapeImage(Shape shape, Paint fill, Stroke stroke, boolean scaleStroke) {
        this(shape, fill, stroke, scaleStroke, defaultFeats);
    }

    public ShapeImage(Shape shape, Paint fill, Stroke stroke, EnumSet<Image.Feature> features) {
        this(shape, fill, stroke, false, features);
    }

    public ShapeImage(Shape shape, Paint fill, Stroke stroke, boolean scaleStroke, EnumSet<Image.Feature> features) {
        this.shape = shape;
        this.paint = fill;
        this.stroke = stroke;
        this.scaleStroke = scaleStroke;
        this.feats = features;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.shape.getBounds2D();
    }

    @Override
    public EnumSet<Image.Feature> getFeatures() {
        return this.feats;
    }

    @Override
    public Shape getOutline() {
        return this.shape;
    }

    @Override
    public Node init(G2DParentNode parent) {
        ShapeNode shapeNode = (ShapeNode)parent.getOrCreateNode("ShapeImage", ShapeNode.class);
        shapeNode.setShape(this.shape);
        shapeNode.setStroke(this.stroke);
        shapeNode.setFill(this.paint != null);
        shapeNode.setColor(this.paint != null ? this.paint : Color.BLACK);
        shapeNode.setScaleStroke(this.scaleStroke);
        return shapeNode;
    }
}

