/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.Point2D;
import java.lang.reflect.Method;
import java.util.Map;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.g2d.element.handler.impl.AbstractGrabbable;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;
import org.simantics.utils.threads.ThreadUtils;

public abstract class AbstractClickable
extends AbstractGrabbable
implements Clickable {
    private static final long serialVersionUID = -8329973386869163106L;
    public static IHintContext.Key HOVER_KEY = new IHintContext.KeyOf(Boolean.class, "HOVER");
    public static IHintContext.Key PRESS_STATUS_KEY = new IHintContext.KeyOf(Clickable.PressStatus.class, "PRESS_STATUS");
    private static final IHintContext.Key KEY_CLICK_LISTENERS = new IHintContext.KeyOf(SyncListenerList.class);
    private static final Method onClick = SyncListenerList.getMethod(Clickable.ClickListener.class, (String)"onClick");

    public AbstractClickable(Double strayDistance) {
        super(1000.0);
    }

    public AbstractClickable() {
    }

    @Override
    public Clickable.PressStatus getPressStatus(IElement e, ICanvasContext ctx) {
        Map<Integer, AbstractGrabbable.GrabInfo> gis = this.getGrabs(e, ctx);
        if (gis == null || gis.size() == 0) {
            Boolean hover = (Boolean)e.getHint(HOVER_KEY);
            if (hover != null && hover.booleanValue()) {
                return Clickable.PressStatus.HOVER;
            }
            return Clickable.PressStatus.NORMAL;
        }
        boolean held = false;
        boolean pressing = false;
        for (AbstractGrabbable.GrabInfo gi : gis.values()) {
            held = true;
            if (pressing |= this.onPickCheck(e, ctx, gi.pointerId, gi.dragPosElement)) break;
        }
        if (pressing) {
            return Clickable.PressStatus.PRESSED;
        }
        if (held) {
            return Clickable.PressStatus.HELD;
        }
        Boolean hover = (Boolean)e.getHint(HOVER_KEY);
        if (hover != null && hover.booleanValue()) {
            return Clickable.PressStatus.HOVER;
        }
        return Clickable.PressStatus.NORMAL;
    }

    @Override
    public boolean handleMouseEvent(IElement e, ICanvasContext ctx, MouseEvent me) {
        Clickable.PressStatus newStatus;
        boolean b = super.handleMouseEvent(e, ctx, me);
        Boolean hovering = !(me instanceof MouseEvent.MouseExitEvent) && !(me instanceof MouseEvent.MouseDragBegin) && !(me instanceof MouseEvent.MouseButtonReleasedEvent) ? Boolean.valueOf(this.onPickCheck(e, ctx, me.mouseId, ElementUtils.controlToElementCoordinate(e, ctx, me.controlPosition, null))) : Boolean.valueOf(false);
        if (!hovering.equals(e.getHint(HOVER_KEY))) {
            e.setHint(HOVER_KEY, hovering);
        }
        if (!(newStatus = this.getPressStatus(e, ctx)).equals(e.getHint(PRESS_STATUS_KEY))) {
            e.setHint(PRESS_STATUS_KEY, (Object)newStatus);
        }
        return b;
    }

    @Override
    protected void onDrag(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
    }

    @Override
    protected void onGrab(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
    }

    @Override
    protected void onGrabCancel(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
    }

    @Override
    protected void onRelease(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
        if (this.getGrabCount(gi.e, ctx) > 0) {
            return;
        }
        boolean pick = this.onPickCheck(gi.e, ctx, gi.pointerId, gi.dragPosElement);
        if (pick) {
            this.onClicked(gi, ctx);
            this.fireClicked(gi.e, ctx);
        }
    }

    @Override
    protected boolean onGrabCheck(IElement e, ICanvasContext ctx, int pointerId, Point2D pickPos) {
        Point2D elementPos = ElementUtils.controlToElementCoordinate(e, ctx, pickPos, null);
        return this.onPickCheck(e, ctx, pointerId, elementPos);
    }

    protected abstract void onClicked(AbstractGrabbable.GrabInfo var1, ICanvasContext var2);

    protected abstract boolean onPickCheck(IElement var1, ICanvasContext var2, int var3, Point2D var4);

    @Override
    public void addListener(final IElement e, final ICanvasContext ctx, final IThreadWorkQueue thread, final Clickable.ClickListener listener) {
        ThreadUtils.syncExec((IThreadWorkQueue)ctx.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
                SyncListenerList list = (SyncListenerList)dp.getElementHint(e, KEY_CLICK_LISTENERS);
                if (list == null) {
                    list = new SyncListenerList(Clickable.ClickListener.class);
                    dp.setElementHint(e, KEY_CLICK_LISTENERS, list);
                }
                list.add(thread, (Object)listener);
            }
        });
    }

    @Override
    public void removeListener(final IElement e, final ICanvasContext ctx, final IThreadWorkQueue thread, final Clickable.ClickListener listener) {
        ThreadUtils.syncExec((IThreadWorkQueue)ctx.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
                SyncListenerList list = (SyncListenerList)dp.getElementHint(e, KEY_CLICK_LISTENERS);
                if (list == null) {
                    return;
                }
                list.remove(thread, (Object)listener);
                if (list.isEmpty()) {
                    dp.removeElementHint(e, KEY_CLICK_LISTENERS);
                }
            }
        });
    }

    public void fireClicked(IElement e, ICanvasContext ctx) {
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        SyncListenerList list = (SyncListenerList)dp.getElementHint(e, KEY_CLICK_LISTENERS);
        if (list == null) {
            return;
        }
        Executable[] exes = list.getExecutables(onClick, new Object[]{e, ctx});
        ThreadUtils.multiSyncExec((Executable[])exes);
    }
}

