/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TernaryAsyncRead;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.issues.Severity;
import org.simantics.issues.common.ChildMaxIssueSeverity;
import org.simantics.issues.common.MaxIssueSeveritySingle;
import org.simantics.issues.ontology.IssueResource;

public class MaxIssueSeverityRecursive
extends TernaryAsyncRead<Resource, Resource, Set<Resource>, Severity> {
    public MaxIssueSeverityRecursive(Resource resource, Resource childRelation, Set<Resource> typesToRecurse) {
        super((Object)resource, (Object)childRelation, typesToRecurse);
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure) {
        IssueResource ISSUE = (IssueResource)graph.getService(IssueResource.class);
        final AtomicInteger issues = new AtomicInteger();
        final AtomicBoolean excepted = new AtomicBoolean(false);
        graph.forEachObject((Resource)this.parameter, ISSUE.Issue_HasContext_Inverse, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

            public void execute(AsyncReadGraph graph, Resource result) {
                issues.incrementAndGet();
            }

            public void finished(AsyncReadGraph graph) {
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                if (excepted.compareAndSet(false, true)) {
                    procedure.exception(graph, throwable);
                }
            }
        });
        graph.forEachObject((Resource)this.parameter, ISSUE.Issue_ContextList_Element_Inverse, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

            public void execute(AsyncReadGraph graph, Resource result) {
                issues.incrementAndGet();
            }

            public void finished(AsyncReadGraph graph) {
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                if (excepted.compareAndSet(false, true)) {
                    procedure.exception(graph, throwable);
                }
            }
        });
        if (excepted.get()) {
            return;
        }
        if (issues.get() == 0) {
            graph.asyncRequest((AsyncRead)new ChildMaxIssueSeverity((Resource)this.parameter, (Resource)this.parameter2, (Set)this.parameter3), procedure);
        } else {
            graph.asyncRequest((AsyncRead)new MaxIssueSeveritySingle((Resource)this.parameter), (AsyncProcedure)new AsyncProcedure<Severity>(){

                public void execute(AsyncReadGraph graph, Severity maxSeverity) {
                    if (maxSeverity == null) {
                        graph.asyncRequest((AsyncRead)new ChildMaxIssueSeverity((Resource)MaxIssueSeverityRecursive.this.parameter, (Resource)MaxIssueSeverityRecursive.this.parameter2, (Set)MaxIssueSeverityRecursive.this.parameter3), procedure);
                    } else {
                        procedure.execute(graph, (Object)maxSeverity);
                    }
                }

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    if (excepted.compareAndSet(false, true)) {
                        procedure.exception(graph, throwable);
                    }
                }
            });
        }
    }
}

