/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.formula;

import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.SpreadsheetMatrix;
import org.simantics.spreadsheet.graph.formula.FormulaError2;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;
import org.simantics.spreadsheet.graph.parser.ast.AstValue;

public class GeomeanFormulaFunction
implements CellFormulaFunction<Object> {
    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() == 0) {
            throw new IllegalStateException();
        }
        double result = 1.0;
        double count = 0.0;
        for (AstValue value : args.values) {
            Object r = value.accept(visitor);
            if (r instanceof SpreadsheetMatrix) {
                Object v = ((SpreadsheetMatrix)r).productWithFormulaError();
                if (v instanceof String) {
                    return v;
                }
                double dval = ((Number)v).doubleValue();
                if (dval == 0.0) continue;
                result *= dval;
                count += ((SpreadsheetMatrix)r).countOfActualDoubleValues();
                continue;
            }
            FormulaError2 error = FormulaError2.forObject(r);
            if (error != null) {
                return error.getString();
            }
            Number vNum = SpreadsheetGraphUtils.asValidNumber(r);
            Double v = null;
            if (vNum != null) {
                v = vNum.doubleValue();
            }
            if (v == null) continue;
            if (v <= 0.0) {
                return FormulaError2.NUM.getString();
            }
            result *= v.doubleValue();
            count += 1.0;
        }
        if (result == 0.0 || count == 0.0) {
            return FormulaError2.NUM.getString();
        }
        return Math.pow(result, 1.0 / count);
    }
}

