/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.simulator.toolkit.StandardNodeManager;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.spreadsheet.graph.SheetNode;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.SpreadsheetCell;
import org.simantics.spreadsheet.graph.SpreadsheetCellContent;
import org.simantics.spreadsheet.graph.SpreadsheetCellContentExpression;
import org.simantics.spreadsheet.graph.SpreadsheetCellEditable;
import org.simantics.spreadsheet.graph.SpreadsheetCellStyle;
import org.simantics.spreadsheet.graph.SpreadsheetRealm;
import org.simantics.spreadsheet.graph.SpreadsheetTypeNode;

public class SpreadsheetNodeManager
extends StandardNodeManager<SheetNode, SpreadsheetBook> {
    static final Set<String> COMPONENT_CLASS = Collections.singleton("http://www.simantics.org/Structural-1.2/Component");

    public SpreadsheetNodeManager(SpreadsheetRealm realm) {
        super((StandardRealm)realm, (Object)((SheetNode)realm.getEngine()));
    }

    public Set<String> getClassifications(SheetNode node) throws NodeManagerException {
        this.checkThreadAccess();
        if (this.isRoot(node)) {
            return COMPONENT_CLASS;
        }
        return Collections.emptySet();
    }

    public String getPropertyURI(SheetNode parent, SheetNode property) {
        if (property instanceof SpreadsheetCellContent) {
            return "http://www.simantics.org/Spreadsheet-1.2/Cell/content";
        }
        if (property instanceof SpreadsheetTypeNode) {
            return "http://www.simantics.org/Layer0-1.1/typeURI";
        }
        if (property instanceof SpreadsheetCellContentExpression) {
            return "http://www.simantics.org/Layer0-1.1/SCLValue/expression";
        }
        if (property instanceof SpreadsheetCellStyle) {
            return "http://www.simantics.org/Spreadsheet-1.2/Cell/style";
        }
        if (property instanceof SpreadsheetCellEditable) {
            return "http://www.simantics.org/Spreadsheet-1.2/Cell/editable";
        }
        return null;
    }

    public void setValue(SheetNode node, Object value, Binding binding) throws NodeManagerException {
        Set<SheetNode> dirtyNodeContents = this.findDirtyNodeContents(node);
        super.setValueAndFireSelectedListeners((Object)node, value, binding, dirtyNodeContents);
    }

    public Set<SheetNode> findDirtyNodeContents(SheetNode node) {
        HashSet<SpreadsheetCell> dirty = new HashSet<SpreadsheetCell>();
        SpreadsheetCell sscell = null;
        if (node instanceof SpreadsheetCell) {
            sscell = (SpreadsheetCell)node;
        } else if (node instanceof SpreadsheetCellContent) {
            sscell = ((SpreadsheetCellContent)node).cell;
        }
        if (sscell != null) {
            Set<SpreadsheetCell> result = ((SpreadsheetBook)((SpreadsheetRealm)super.getRealm()).getEngine()).invalidate(sscell);
            dirty.addAll(result);
        }
        HashSet<SheetNode> dirtyNodeContents = new HashSet<SheetNode>();
        for (SheetNode sheetNode : dirty) {
            Map properties = sheetNode.getProperties();
            dirtyNodeContents.add((SpreadsheetCellContent)properties.get("content"));
        }
        return dirtyNodeContents;
    }
}

