/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.element;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementHints;
import org.simantics.jfreechart.chart.element.ChartElementFactory;
import org.simantics.modeling.ui.diagramEditor.PopulateElementDropParticipant;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.utils.ui.AdaptionUtils;

public class PopulateChartDropParticipant
extends PopulateElementDropParticipant
implements IDropTargetParticipant {
    public PopulateChartDropParticipant(GraphToDiagramSynchronizer synchronizer) {
        super(synchronizer);
    }

    public void dragEnter(DropTargetDragEvent dtde, IDnDContext dp) {
        Transferable tr = dtde.getTransferable();
        if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
            Session session = this.synchronizer.getSession();
            Object obj = null;
            try {
                IStructuredSelection sel;
                obj = tr.getTransferData(LocalObjectTransferable.FLAVOR);
                if (!(obj instanceof IStructuredSelection)) {
                    obj = LocalObjectTransfer.getTransfer().getObject();
                }
                if (obj instanceof IStructuredSelection && (sel = (IStructuredSelection)obj).size() == 1) {
                    Resource chart = (Resource)AdaptionUtils.adaptToSingle((Object)sel, Resource.class);
                    if (chart == null) {
                        return;
                    }
                    ElementClassDragItem item = (ElementClassDragItem)session.syncRequest((Read)new UnaryRead<Resource, ElementClassDragItem>(chart){

                        public ElementClassDragItem perform(ReadGraph graph) throws DatabaseException {
                            if (graph.isInstanceOf((Resource)this.parameter, JFreeChartResource.getInstance((ReadGraph)graph).Chart)) {
                                ElementClassDragItem item = new ElementClassDragItem(ChartElementFactory.create(graph, (Resource)this.parameter));
                                AffineTransform initialTr = AffineTransform.getScaleInstance(1.0, 1.0);
                                item.getHintContext().setHint(ElementHints.KEY_TRANSFORM, (Object)initialTr);
                                return item;
                            }
                            return null;
                        }
                    });
                    if (item != null) {
                        dp.add((Object)item);
                        dp.getHints().setHint(DnDHints.KEY_DND_GRID_COLUMNS, (Object)1);
                    }
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        dtde.acceptDrag(1);
    }
}

