/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.jface;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.simantics.utils.ObjectUtils;

public class BaseSelectionProvider
implements ISelectionProvider {
    protected ListenerList<ISelectionChangedListener> selectionListeners = new ListenerList();
    protected ISelection selection = StructuredSelection.EMPTY;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void clearListeners() {
        this.clearSelectionChangedListeners();
    }

    public void clearSelectionChangedListeners() {
        this.selectionListeners.clear();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        this.setSelectionWithoutFiring(selection);
    }

    protected Object[] getListeners() {
        return this.selectionListeners.getListeners();
    }

    public void fireSelection(ISelection selection) {
        if (selection == null) {
            return;
        }
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((ISelectionChangedListener)l).selectionChanged(e);
            ++n2;
        }
    }

    public void setSelectionWithoutFiring(ISelection selection) {
        this.selection = selection;
    }

    public void setAndFireSelection(ISelection selection) {
        this.setSelection(selection);
        this.fireSelection(selection);
    }

    public boolean setAndFireNonEqualSelection(ISelection selection) {
        ISelection old = this.getSelection();
        if (ObjectUtils.objectEquals((Object)old, (Object)selection)) {
            return false;
        }
        this.selection = selection;
        if (selection != null) {
            this.fireSelection(selection);
        }
        return true;
    }

    public boolean selectionEquals(ISelection s) {
        if (s == this.selection) {
            return true;
        }
        if (s == null) {
            return true;
        }
        return s.equals(this.selection);
    }
}

