/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.internal.VariableUtils;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.charts.ui.AddVariableToChartAction;
import org.simantics.charts.ui.ChartVariable;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PropertyVariables;
import org.simantics.modeling.PropertyVariablesImpl;
import org.simantics.modeling.utils.VariableReferences;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class ChartDropActionFactory
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        List wses;
        List<VariableReference> references;
        List<VariableReference> references2;
        Resource chart = (Resource)ISelectionUtils.getSinglePossibleKey((Object)target, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (chart == null) {
            return null;
        }
        Resource targetModel = (Resource)g.syncRequest((Read)new PossibleModel(chart));
        if (targetModel == null) {
            return null;
        }
        if (source instanceof RVI) {
            List<VariableReference> refs = Collections.singletonList(new VariableReference((RVI)source, VariableUtils.getDatatype(g, targetModel, (RVI)source), null));
            return new AddVariableToChartAction(chart, null, refs).init(g);
        }
        List vars = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, PropertyVariables.class);
        if (!vars.isEmpty() && !(references2 = ChartDropActionFactory.toPropertyReferences(g, targetModel, vars = PropertyVariablesImpl.resolve((ReadGraph)g, (List)vars))).isEmpty()) {
            return new AddVariableToChartAction(chart, null, references2).init(g);
        }
        List vars2 = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Variable.class);
        if (!vars2.isEmpty() && !(references = ChartDropActionFactory.toReferences(g, targetModel, vars2)).isEmpty()) {
            return new AddVariableToChartAction(chart, null, references).init(g);
        }
        if (source instanceof ISelection && !(wses = ISelectionUtils.filterSelection((ISelection)((ISelection)source), WorkbenchSelectionElement.class)).isEmpty()) {
            ArrayList<Variable> wsevars = new ArrayList<Variable>();
            ChartVariable av = new ChartVariable((RequestProcessor)g);
            for (WorkbenchSelectionElement wse : wses) {
                Variable v = (Variable)wse.getContent((WorkbenchSelectionContentType)av);
                if (v == null) continue;
                wsevars.add(v);
            }
            List<VariableReference> references3 = ChartDropActionFactory.toReferences(g, targetModel, wsevars);
            if (!wsevars.isEmpty()) {
                return new AddVariableToChartAction(chart, null, references3).init(g);
            }
        }
        List srcs = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        ArrayList<ChartItemDescriptor> newItems = new ArrayList<ChartItemDescriptor>();
        HashSet<Resource> movedPlots = new HashSet<Resource>();
        for (Resource res : srcs) {
            Resource model;
            if (g.isInstanceOf(res, MOD.Subscription_Item)) {
                model = (Resource)g.syncRequest((Read)new PossibleModel(res));
                if (!ObjectUtils.objectEquals((Object)targetModel, (Object)model)) continue;
                ChartItemDescriptor desc = new ChartItemDescriptor();
                desc.subscriptionItem = res;
                Datatype datatype = (Datatype)g.getPossibleRelatedValue(res, MOD.Subscription_Item_Datatype, Bindings.getBindingUnchecked(Datatype.class));
                desc.renderer = datatype instanceof BooleanType ? TrendItem.Renderer.Binary : TrendItem.Renderer.Analog;
                newItems.add(desc);
                continue;
            }
            if (!g.isInstanceOf(res, CHART.Chart_Item) || !ObjectUtils.objectEquals((Object)targetModel, (Object)(model = (Resource)g.syncRequest((Read)new PossibleModel(res))))) continue;
            movedPlots.add(res);
        }
        if (!newItems.isEmpty() || !movedPlots.isEmpty()) {
            return ChartDropActionFactory.addPlots(chart, newItems, movedPlots);
        }
        if (source instanceof String) {
            return this.handleStringDrop(g, chart, targetModel, (String)source);
        }
        return null;
    }

    private Runnable handleStringDrop(ReadGraph graph, Resource chart, Resource targetModel, String source) {
        try {
            List<VariableReference> refs = VariableUtils.getVariableReferencesFromString(graph, targetModel, source);
            return new AddVariableToChartAction(chart, null, refs).init(graph);
        }
        catch (DatabaseException databaseException) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.simantics.charts", String.valueOf(this.getClass().getSimpleName()) + ": Unrecognized String input: " + source));
            return null;
        }
    }

    private static List<VariableReference> toReferences(ReadGraph graph, Resource contextIndexRoot, List<Variable> variables) throws DatabaseException {
        if (variables.isEmpty()) {
            return Collections.emptyList();
        }
        return ChartDropActionFactory.filterReferences((List)graph.syncRequest(VariableReferences.variablesToReferences((Resource)contextIndexRoot, variables)));
    }

    private static List<VariableReference> toPropertyReferences(ReadGraph graph, Resource contextIndexRoot, List<PropertyVariables> variables) throws DatabaseException {
        if (variables.isEmpty()) {
            return Collections.emptyList();
        }
        return ChartDropActionFactory.filterReferences((List)graph.syncRequest(VariableReferences.toReferences((Resource)contextIndexRoot, variables)));
    }

    private static List<VariableReference> filterReferences(List<VariableReference> variables) throws DatabaseException {
        return variables.stream().filter(ref -> ref.datatype instanceof BooleanType || ref.datatype instanceof NumberType).collect(Collectors.toList());
    }

    public static Runnable addPlots(Resource chart, List<ChartItemDescriptor> references, Set<Resource> movedPlots) {
        return () -> Simantics.getSession().asyncRequest(AddChartItem.addAndMoveChartItems(chart, references, movedPlots), (Procedure)new ProcedureAdapter<Collection<Resource>>(){

            public void exception(Throwable e) {
                if (e != null) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        });
    }
}

