/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableChildren;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.document.server.request.DocumentRequest;
import org.simantics.document.server.request.NodesRequest2;
import org.simantics.structural.stubs.StructuralResource2;

public class NodesRequest
extends VariableRead<Set<Variable>> {
    public NodesRequest(Variable var) {
        super(var);
    }

    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
        long s = System.nanoTime();
        StructuralResource2.getInstance((ReadGraph)graph);
        if (this.variable == null) {
            return Collections.emptySet();
        }
        THashSet nodes = new THashSet();
        Collection children = (Collection)graph.syncRequest((Read)new VariableChildren(this.variable));
        for (Variable child : children) {
            Set childNodes = (Set)graph.syncRequest((Read)new NodesRequest2(child));
            nodes.addAll(childNodes);
        }
        if (DocumentRequest.PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("NodesRequest " + System.identityHashCode((Object)this) + " in " + 1.0E-6 * (double)dura + "ms. " + this.variable.getURI(graph));
        }
        return nodes;
    }
}

