/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import java.io.IOException;

import junit.framework.TestCase;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;

public class TestReflectionBinding extends TestCase {
    
    static public enum TestEnum {
        Value1, Value2, Value3
    }
    
    static public class TestClass {
        public TestEnum e0;
    }
    
    public void testEnumeration() throws SerializationException, BindingException, IOException {
        // Test DataType
        Datatype dt = Datatypes.getDatatypeUnchecked(TestClass.class);
        RecordType rt = (RecordType) dt;
        UnionType ut = (UnionType) rt.getComponentType(0);        
        assertEquals("Value1", ut.components[0].name);
        assertEquals("Value2", ut.components[1].name);
        assertEquals("Value3", ut.components[2].name);        

        // Test Binding
        Binding b = Bindings.getBindingUnchecked(TestClass.class);
        RecordBinding rb = (RecordBinding) b;
        UnionBinding ub = (UnionBinding) rb.componentBindings[0];
        assertEquals(ub.type(), ut);
        
        // TODO Test serialization
        TestClass tc = new TestClass();
        tc.e0 = TestEnum.Value3;        
        Serializer s = b.serializer();
        byte[] data = s.serialize(tc);
        assertEquals(1, data.length);
        tc = (TestClass) s.deserialize(data);
        assertEquals(TestEnum.Value3, tc.e0);
    }

}

