/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MInputPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;

public class ApplicationPartServiceImpl
implements EPartService {
    private MApplication application;

    @Inject
    ApplicationPartServiceImpl(MApplication application) {
        this.application = application;
    }

    private EPartService getActiveWindowService() {
        IEclipseContext activeWindowContext = this.application.getContext().getActiveChild();
        if (activeWindowContext == null) {
            throw new IllegalStateException("Application does not have an active window");
        }
        EPartService activeWindowPartService = (EPartService)activeWindowContext.get(EPartService.class);
        if (activeWindowPartService == null) {
            throw new IllegalStateException("Active window context is invalid");
        }
        if (activeWindowPartService == this) {
            throw new IllegalStateException("Application does not have an active window");
        }
        return activeWindowPartService;
    }

    @Override
    public void addPartListener(IPartListener listener) {
        throw new UnsupportedOperationException("Listeners should only be attached/removed from a window's part service");
    }

    @Override
    public void removePartListener(IPartListener listener) {
        throw new UnsupportedOperationException("Listeners should only be attached/removed from a window's part service");
    }

    @Override
    public boolean isPartOrPlaceholderInPerspective(String elementId, MPerspective perspective) {
        return this.getActiveWindowService().isPartOrPlaceholderInPerspective(elementId, perspective);
    }

    @Override
    public void switchPerspective(MPerspective perspective) {
        this.getActiveWindowService().switchPerspective(perspective);
    }

    @Override
    public Optional<MPerspective> switchPerspective(String perspectiveId) {
        return this.getActiveWindowService().switchPerspective(perspectiveId);
    }

    @Override
    public void activate(MPart part) {
        this.getActiveWindowService().activate(part);
    }

    @Override
    public void activate(MPart part, boolean requiresFocus) {
        this.getActiveWindowService().activate(part, requiresFocus);
    }

    @Override
    public void requestActivation() {
        this.getActiveWindowService().requestActivation();
    }

    @Override
    public void bringToTop(MPart part) {
        this.getActiveWindowService().bringToTop(part);
    }

    @Override
    public MPart findPart(String id) {
        return this.getActiveWindowService().findPart(id);
    }

    @Override
    public Collection<MPart> getParts() {
        return this.getActiveWindowService().getParts();
    }

    @Override
    public MPart getActivePart() {
        return this.getActiveWindowService().getActivePart();
    }

    @Override
    public boolean isPartVisible(MPart part) {
        return this.getActiveWindowService().isPartVisible(part);
    }

    @Override
    public MPart createPart(String id) {
        return this.getActiveWindowService().createPart(id);
    }

    @Override
    public MPlaceholder createSharedPart(String id) {
        return this.getActiveWindowService().createSharedPart(id);
    }

    @Override
    public MPlaceholder createSharedPart(String id, boolean force) {
        return this.getActiveWindowService().createSharedPart(id, force);
    }

    @Override
    public MPart showPart(String id, EPartService.PartState partState) {
        return this.getActiveWindowService().showPart(id, partState);
    }

    @Override
    public MPart showPart(MPart part, EPartService.PartState partState) {
        return this.getActiveWindowService().showPart(part, partState);
    }

    @Override
    public void hidePart(MPart part) {
        this.getActiveWindowService().hidePart(part);
    }

    @Override
    public void hidePart(MPart part, boolean force) {
        this.getActiveWindowService().hidePart(part, force);
    }

    @Override
    public Collection<MPart> getDirtyParts() {
        return this.getActiveWindowService().getDirtyParts();
    }

    @Override
    public boolean savePart(MPart part, boolean confirm) {
        return this.getActiveWindowService().savePart(part, confirm);
    }

    @Override
    public boolean saveAll(boolean confirm) {
        return this.getActiveWindowService().saveAll(confirm);
    }

    @Override
    public Collection<MInputPart> getInputParts(String inputUri) {
        return this.getActiveWindowService().getInputParts(inputUri);
    }
}

