/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils.imports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.container.DataFormatException;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.primitiverequest.PossibleResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.ModelDependenciesBean;
import org.simantics.db.layer0.util.ModelDependency;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteResult;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.issues.common.AllBatchIssueSources;
import org.simantics.issues.common.BatchIssueSource;
import org.simantics.issues.common.BatchIssueValidationContext;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.utils.BatchValidations;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.utils.ModelUtils;

public class ImportUtils {
    private static void beginTask(IProgressMonitor monitor, String taskName, int totalWork) {
        if (monitor != null) {
            monitor.beginTask(taskName, totalWork);
        }
    }

    private static void subTask(IProgressMonitor monitor, String taskName) {
        if (monitor != null) {
            monitor.subTask(taskName);
        }
    }

    private static void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            monitor.worked(work);
        }
    }

    public static Object readFile(String path, HashMap<String, FormatHandler<Object>> handlers) {
        Object result = null;
        try {
            File file = new File(path);
            if (!file.isFile()) {
                return new Status(4, "org.simantics.sysdyn", "Import failed: File " + path + " not found", null);
            }
            result = DataContainers.readFile((File)file, handlers);
        }
        catch (DataFormatException e) {
            e.printStackTrace();
            return new Status(4, "org.simantics.sysdyn", "Import failed", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Status(4, "org.simantics.sysdyn", "Import failed", (Throwable)e);
        }
        catch (Exception e) {
            return new Status(4, "org.simantics.sysdyn", "Import failed", (Throwable)e);
        }
        return result;
    }

    public static IStatus importModelFile(String path, IProgressMonitor monitor) throws Exception {
        return ImportUtils.importModelFile(path, monitor, null);
    }

    public static IStatus importModelFile(String path, final IProgressMonitor monitor, Function1<Resource, WriteRequest> callback) throws Exception {
        Resource project = (Resource)Simantics.getProject().get();
        if (project == null) {
            return new Status(4, "org.simantics.sysdyn", "Import model: project not found", null);
        }
        ImportUtils.beginTask(monitor, "Import model", 10);
        final File importFile = new File(path);
        MigrationState state = MigrationUtils.newState();
        state.setProperty("baseURI", (Object)"http://www.simantics.org/Sysdyn-1.1/Migration");
        state.setProperty("modelFile", (Object)importFile);
        state.setProperty("updateDependencies", (Object)Boolean.FALSE);
        Session session = Simantics.getSession();
        session.syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Imported Sysdyn model from " + importFile.getName()));
            }
        });
        ModelDependenciesBean dependenciesBean = ImportUtils.getModelDependenciesBean(state);
        if (dependenciesBean != null) {
            ModelDependency[] modelDependencyArray = dependenciesBean.dependencies;
            int n = dependenciesBean.dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                ModelDependency dependency = modelDependencyArray[n2];
                Resource existing = (Resource)session.sync((ReadInterface)new PossibleResource(dependency.uri));
                if (existing == null) {
                    MigrationUtils.importSharedOntology((Session)session, (TransferableGraph1)dependency.tg, (boolean)false);
                }
                ++n2;
            }
        }
        Resource result = null;
        try {
            result = MigrationUtils.importMigrated((IProgressMonitor)monitor, (Session)session, (File)importFile, (MigrationState)state, (IImportAdvisor)new DefaultPasteImportAdvisor(project), (Resource)project);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        if (result == null || !(result instanceof Resource)) {
            return new Status(4, "org.simantics.sysdyn", "Import model failed: File could not be read.", null);
        }
        try {
            WriteRequest userRequest;
            final Resource ModelRoot = result;
            IStatus status = (IStatus)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<IStatus>(){

                public IStatus perform(WriteGraph graph) throws DatabaseException {
                    if (!graph.isInstanceOf(ModelRoot, SysdynResource.getInstance((ReadGraph)graph).SysdynModel)) {
                        Resource instanceOf = graph.getPossibleObject(ModelRoot, Layer0.getInstance((ReadGraph)graph).InstanceOf);
                        String type = "...";
                        if (instanceOf != null) {
                            type = NameUtils.getSafeName((ReadGraph)graph, (Resource)instanceOf);
                        } else {
                            Resource inheritedFrom = graph.getPossibleObject(ModelRoot, Layer0.getInstance((ReadGraph)graph).Inherits);
                            if (inheritedFrom != null) {
                                type = NameUtils.getSafeName((ReadGraph)graph, (Resource)inheritedFrom);
                            }
                        }
                        String ft = type;
                        graph.deny(ModelRoot, Layer0.getInstance((ReadGraph)graph).PartOf);
                        return new Status(4, "org.simantics.sysdyn", "The imported file is not of type: System Dynamics Model (" + ft + ")", null);
                    }
                    ImportUtils.subTask(monitor, "Add required dependencies");
                    ImportUtils.addDependencies(graph, ModelRoot);
                    ImportUtils.worked(monitor, 1);
                    ImportUtils.subTask(monitor, "Remove unnecessary issue sources");
                    ImportUtils.removeIssueSourcesFromModules(graph, ModelRoot);
                    ImportUtils.worked(monitor, 1);
                    ImportUtils.subTask(monitor, "Add enumeration issue source");
                    ImportUtils.addEnumerationIssueSource(graph, ModelRoot);
                    ImportUtils.worked(monitor, 1);
                    ImportUtils.subTask(monitor, "Add unit issue source");
                    ImportUtils.addUnitIssueSource(graph, ModelRoot);
                    ImportUtils.worked(monitor, 1);
                    ImportUtils.subTask(monitor, "Add shadow profile");
                    ImportUtils.addShadowProfile(graph, ModelRoot);
                    ImportUtils.worked(monitor, 1);
                    ImportUtils.subTask(monitor, "Add SCL Main");
                    ImportUtils.addSCLMain(graph, ModelRoot);
                    ImportUtils.worked(monitor, 1);
                    ImportUtils.subTask(monitor, "Activate model");
                    ImportUtils.activateModel(graph, ModelRoot);
                    ImportUtils.worked(monitor, 1);
                    return null;
                }
            });
            if (status != null) {
                return status;
            }
            ImportUtils.subTask(monitor, "Validate model");
            Collection confs = (Collection)Simantics.getSession().syncRequest((Read)new Read<Collection<Resource>>(){

                public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                    return ImportUtils.findAllConfigurations(graph, ModelRoot);
                }
            });
            try {
                for (Resource conf : confs) {
                    Collection validations = (Collection)session.sync((ReadInterface)new AllBatchIssueSources(ModelRoot));
                    SubMonitor progress = null;
                    if (monitor != null) {
                        progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Validate Model", (int)100);
                    }
                    BatchIssueValidationContext context = new BatchIssueValidationContext();
                    context.domain = ModelTransferableGraphSourceRequest.getDomainOnly((RequestProcessor)session, (IProgressMonitor)monitor, (Resource)conf);
                    context.contexts = BatchValidations.fillConfig((IProgressMonitor)progress, Collections.singletonList(conf));
                    for (BatchIssueSource bis : validations) {
                        Map is = BatchValidations.validate((IProgressMonitor)(monitor != null ? progress.newChild(90, 0) : null), (BatchIssueSource)bis, (BatchIssueValidationContext)context);
                        BatchValidations.store((IProgressMonitor)(monitor != null ? progress.newChild(10, 0) : null), (Resource)bis.getResource(), (Map)is);
                    }
                }
            }
            catch (Throwable t) {
                return new Status(4, "org.simantics.sysdyn", "Batch validate failed: Model could not be imported.", t);
            }
            ImportUtils.worked(monitor, 1);
            if (callback != null && (userRequest = (WriteRequest)callback.apply((Object)result)) != null) {
                Simantics.sync((WriteInterface)userRequest);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return new Status(4, "org.simantics.sysdyn", "Import model failed: Model could not be imported.", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private static ModelDependenciesBean getModelDependenciesBean(MigrationState state) throws DatabaseException {
        Map extensions = (Map)state.getProperty("tgExtensions");
        Variant variant = (Variant)extensions.get(ModelDependenciesBean.EXTENSION_KEY);
        if (variant != null) {
            try {
                return (ModelDependenciesBean)variant.getValue(ModelDependenciesBean.BINDING);
            }
            catch (AdaptException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected static void addSCLMain(WriteGraph graph, Resource modelRoot) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection SCLModules = (Collection)graph.syncRequest((Read)new ObjectsWithType(modelRoot, L0.ConsistsOf, L0.SCLModule));
        boolean hasIt = false;
        for (Resource r : SCLModules) {
            if (!"SCLMain".equals(NameUtils.getSafeName((ReadGraph)graph, (Resource)r))) continue;
            hasIt = true;
            break;
        }
        if (!hasIt) {
            ModelUtils.createSCLMain(graph, modelRoot);
        }
    }

    private static void removeIssueSourcesFromModules(WriteGraph graph, Resource modelRoot) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        for (Resource m : ImportUtils.findAllModelsAndModules((ReadGraph)graph, modelRoot)) {
            if (m.equals(modelRoot)) continue;
            for (Resource issueSource : (Collection)graph.syncRequest((Read)new ObjectsWithType(m, L0.ConsistsOf, ISSUE.IssueSource))) {
                for (Resource issue : graph.getObjects(issueSource, ISSUE.IssueSource_Manages)) {
                    RemoverUtil.remove((WriteGraph)graph, (Resource)issue);
                }
                RemoverUtil.remove((WriteGraph)graph, (Resource)issueSource);
            }
        }
    }

    private static void activateModel(WriteGraph graph, Resource modelRoot) throws DatabaseException {
        Resource project;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        if (!graph.hasStatement(modelRoot, L0X.IsActivatedBy) && (project = graph.getPossibleObject(modelRoot, L0.PartOf)) != null) {
            graph.claim(modelRoot, L0X.IsActivatedBy, project);
        }
    }

    private static void addDependencies(WriteGraph graph, Resource modelRoot) throws DatabaseException {
        Resource documentation;
        Resource simupediaWb;
        Resource selectionView;
        Resource simupedia;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<String> links = new ArrayList<String>();
        for (Resource link : graph.getObjects(modelRoot, L0.IsLinkedTo)) {
            links.add(graph.getURI(link));
        }
        if (!links.contains("http://www.semantum.fi/Simupedia-1.0") && (simupedia = graph.getPossibleResource("http://www.semantum.fi/Simupedia-1.0")) != null) {
            graph.claim(modelRoot, L0.IsLinkedTo, simupedia);
        }
        if (!links.contains("http://www.simantics.org/SelectionView-1.2") && (selectionView = graph.getPossibleResource("http://www.simantics.org/SelectionView-1.2")) != null) {
            graph.claim(modelRoot, L0.IsLinkedTo, selectionView);
        }
        if (!links.contains("http://www.semantum.fi/SimupediaWorkbench-1.0") && (simupediaWb = graph.getPossibleResource("http://www.semantum.fi/SimupediaWorkbench-1.0")) != null) {
            graph.claim(modelRoot, L0.IsLinkedTo, simupediaWb);
        }
        if (!links.contains("http://www.simantics.org/Documentation-1.2") && (documentation = graph.getPossibleResource("http://www.simantics.org/Documentation-1.2")) != null) {
            graph.claim(modelRoot, L0.IsLinkedTo, documentation);
        }
    }

    private static void addEnumerationIssueSource(WriteGraph graph, Resource modelRoot) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Collection enumerationIssueSources = (Collection)graph.syncRequest((Read)new ObjectsWithType(modelRoot, L0.ConsistsOf, sr.Validations_Enumerations_EnumerationIssueSource));
        if (enumerationIssueSources.isEmpty()) {
            GraphUtils.create2((WriteGraph)graph, (Resource)sr.Validations_Enumerations_EnumerationIssueSource, (Object[])new Object[]{L0X.IsActivatedBy, modelRoot, L0.PartOf, modelRoot});
        }
    }

    private static void addUnitIssueSource(WriteGraph graph, Resource modelRoot) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Collection unitIssueSources = (Collection)graph.syncRequest((Read)new ObjectsWithType(modelRoot, L0.ConsistsOf, sr.Validations_Units_UnitIssueSource));
        if (unitIssueSources.isEmpty()) {
            GraphUtils.create2((WriteGraph)graph, (Resource)sr.Validations_Units_UnitIssueSource, (Object[])new Object[]{L0X.IsActivatedBy, modelRoot, L0.PartOf, modelRoot, IssueResource.getInstance((ReadGraph)graph).IssueSource_active, false});
        }
    }

    private static void addShadowProfile(WriteGraph graph, Resource modelRoot) throws DatabaseException {
        List entries;
        Resource entryList;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        Resource defaultProfile = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(modelRoot, Layer0.getInstance((ReadGraph)graph).ConsistsOf, SR.DefaultProfile));
        if (defaultProfile != null && (entryList = graph.getPossibleObject(defaultProfile, DIA.HasEntries)) != null && (entries = ListUtils.toList((ReadGraph)graph, (Resource)entryList)) != null && !entries.contains(SR.Profiles_ShadowVisualizations)) {
            ListUtils.insertBack((WriteGraph)graph, (Resource)entryList, Collections.singletonList(SR.Profiles_ShadowVisualizations));
        }
    }

    private static Collection<Resource> findAllConfigurations(ReadGraph graph, Resource modelRoot) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        StructuralResource2 SR2 = StructuralResource2.getInstance((ReadGraph)graph);
        Collection<Resource> modulesAndModels = ImportUtils.findAllModelsAndModules(graph, modelRoot);
        ArrayList<Resource> configurations = new ArrayList<Resource>();
        for (Resource r : modulesAndModels) {
            if (graph.isInheritedFrom(r, sr.Module)) {
                configurations.add(graph.getPossibleObject(r, SR2.IsDefinedBy));
                continue;
            }
            if (!graph.isInstanceOf(r, sr.SysdynModel)) continue;
            configurations.add(graph.getPossibleObject(modelRoot, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration));
        }
        return configurations;
    }

    private static Collection<Resource> findAllModelsAndModules(ReadGraph graph, Resource modelRoot) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> modelsAndModules = new ArrayList<Resource>();
        modelsAndModules.add(modelRoot);
        for (Resource r : graph.getObjects(modelRoot, L0.ConsistsOf)) {
            if (!graph.isInheritedFrom(r, sr.Module)) continue;
            modelsAndModules.add(r);
        }
        return modelsAndModules;
    }

    public static IStatus importModuleFile(Resource model, String path, IProgressMonitor monitor) {
        ImportUtils.beginTask(monitor, "Import Module", 3);
        MigrationState state = MigrationUtils.newState();
        state.setProperty("baseURI", (Object)"http://www.simantics.org/Sysdyn-1.1/Migration");
        state.setProperty("updateDependencies", (Object)Boolean.FALSE);
        Resource result = null;
        try {
            result = MigrationUtils.importMigrated((IProgressMonitor)monitor, (Session)Simantics.getSession(), (File)new File(path), (MigrationState)state, (IImportAdvisor)new DefaultPasteImportAdvisor(model), (Resource)model);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (result == null) {
            return new Status(4, "org.simantics.sysdyn", "Import module failed: Module could not be imported.", null);
        }
        final Resource ModuleRoot = result;
        try {
            ImportUtils.subTask(monitor, "Validate model");
            IStatus status = (IStatus)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<IStatus>(){

                public IStatus perform(WriteGraph graph) throws DatabaseException {
                    if (!graph.isInheritedFrom(ModuleRoot, SysdynResource.getInstance((ReadGraph)graph).Module)) {
                        Resource instanceOf = graph.getPossibleObject(ModuleRoot, Layer0.getInstance((ReadGraph)graph).InstanceOf);
                        String type = "...";
                        if (instanceOf != null) {
                            type = NameUtils.getSafeName((ReadGraph)graph, (Resource)instanceOf);
                        } else {
                            Resource inheritedFrom = graph.getPossibleObject(ModuleRoot, Layer0.getInstance((ReadGraph)graph).Inherits);
                            if (inheritedFrom != null) {
                                type = NameUtils.getSafeName((ReadGraph)graph, (Resource)inheritedFrom);
                            }
                        }
                        String ft = type;
                        graph.deny(ModuleRoot, Layer0.getInstance((ReadGraph)graph).PartOf);
                        return new Status(4, "org.simantics.sysdyn", "The imported file is not of type: System Dynamics Module (" + ft + ")", null);
                    }
                    return null;
                }
            });
            if (status != null) {
                return status;
            }
            ImportUtils.worked(monitor, 1);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public static IStatus importFunctionLibrary(final Resource functionLibrary, String path, IProgressMonitor monitor) {
        ImportUtils.beginTask(monitor, "Import Module", 3);
        ImportUtils.ensureSharedOntologies();
        MigrationState state = MigrationUtils.newState();
        state.setProperty("baseURI", (Object)"http://www.simantics.org/Sysdyn-1.1/Migration");
        state.setProperty("updateDependencies", (Object)Boolean.FALSE);
        Resource result = null;
        try {
            result = MigrationUtils.importMigrated((IProgressMonitor)monitor, (Session)Simantics.getSession(), (File)new File(path), (MigrationState)state, (IImportAdvisor)new DefaultPasteImportAdvisor(functionLibrary), (Resource)functionLibrary);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (result == null) {
            return new Status(4, "org.simantics.sysdyn", "Import Function library failed: Function library not be imported.", null);
        }
        final Resource FunctionLibraryRoot = result;
        try {
            ImportUtils.subTask(monitor, "Validate model");
            IStatus status = (IStatus)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<IStatus>(){

                public IStatus perform(WriteGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    if (graph.isInstanceOf(FunctionLibraryRoot, SysdynResource.getInstance((ReadGraph)graph).SharedFunctionOntology)) {
                        Resource library = graph.getResource("http://SharedOntologies");
                        if (!graph.hasStatement(library, l0.ConsistsOf, FunctionLibraryRoot)) {
                            graph.claim(library, l0.ConsistsOf, FunctionLibraryRoot);
                        }
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        Resource model = functionLibrary;
                        while (!graph.isInstanceOf(model, sr.SysdynModel) && graph.isInstanceOf(model, l0.Ontology)) {
                            model = graph.getSingleObject(model, l0.PartOf);
                        }
                        if (graph.isInstanceOf(model, sr.SysdynModel)) {
                            graph.claim(model, l0.IsLinkedTo, l0.IsLinkedTo_Inverse, FunctionLibraryRoot);
                        }
                    } else if (!graph.isInstanceOf(FunctionLibraryRoot, SysdynResource.getInstance((ReadGraph)graph).SysdynModelicaFunctionLibrary)) {
                        Resource instanceOf = graph.getPossibleObject(FunctionLibraryRoot, l0.InstanceOf);
                        String type = "...";
                        if (instanceOf != null) {
                            type = NameUtils.getSafeName((ReadGraph)graph, (Resource)instanceOf);
                        } else {
                            Resource inheritedFrom = graph.getPossibleObject(FunctionLibraryRoot, l0.Inherits);
                            if (inheritedFrom != null) {
                                type = NameUtils.getSafeName((ReadGraph)graph, (Resource)inheritedFrom);
                            }
                        }
                        String ft = type;
                        graph.deny(FunctionLibraryRoot, l0.PartOf);
                        return new Status(4, "org.simantics.sysdyn", "The imported file is not of type: Function Library (" + ft + ")", null);
                    }
                    return null;
                }
            });
            if (status != null) {
                return status;
            }
            ImportUtils.worked(monitor, 1);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private static void ensureSharedOntologies() {
        try {
            Boolean hasSharedOntologies = (Boolean)Simantics.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    try {
                        graph.getResource("http://SharedOntologies");
                    }
                    catch (ResourceNotFoundException e) {
                        return false;
                    }
                    return true;
                }
            });
            if (!hasSharedOntologies.booleanValue()) {
                Simantics.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        GraphUtils.create2((WriteGraph)graph, (Resource)l0.Library, (Object[])new Object[]{l0.HasName, "SharedOntologies", l0.PartOf, graph.getResource("http:/")});
                    }
                });
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }
}

