/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.mdl.MdlModel;

public abstract class Declaration {
    private static final String CATEGORY = "\\*{56}\\s*\\.(.+)\\s*\\*{56}.*";
    protected static final String DECL_DELIM = "\\s*~\\s*";
    protected static final String DECL_END = "\\s*\\|";
    protected static final String DECL_UNIT = "([^~]*?)";
    protected static final String DECL_DESC = "([^\\|]*?)";
    protected static final String DECL_SUFFIX = "\\s*~\\s*([^~]*?)\\s*~\\s*([^\\|]*?)\\s*\\|";
    protected static final int declarationUnit = 1;
    protected static final int declarationDescription = 2;
    private String name;
    private MdlModel mdl;
    private String unit;
    private String description;

    protected Declaration(String name, MdlModel mdl) {
        this.name = name;
        this.mdl = mdl;
    }

    protected void parseSuffix(String suffix) throws Exception {
        Matcher matcher = Pattern.compile(DECL_SUFFIX).matcher(suffix);
        if (!matcher.matches()) {
            throw new Exception("could not parse declaration suffix " + suffix);
        }
        this.unit = matcher.group(1);
        this.description = matcher.group(2);
    }

    public String getName() {
        return this.name;
    }

    public MdlModel getMdl() {
        return this.mdl;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDescription() {
        return this.description;
    }

    public static String parseCategory(String line) {
        Matcher matcher = Pattern.compile(CATEGORY).matcher(line);
        return matcher.matches() ? matcher.group(1).trim() : null;
    }
}

