/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.GameResult;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.OldSysdynExperiment;
import org.simantics.sysdyn.manager.SimulateDurationJob;
import org.simantics.sysdyn.solver.ISolver;
import org.simantics.utils.datastructures.Quad;

public abstract class SysdynGameExperimentBase
extends OldSysdynExperiment {
    public double stepLength = DEFAULT_STEP_LENGTH;
    public double startTime = DEFAULT_START_TIME;
    protected double stepDuration = DEFAULT_STEP_DURATION;
    protected int savePer = 1;
    public HashMap<String, Integer> subscriptionIndexes;
    protected double[] currentValues;
    protected TDoubleArrayList[] results;
    public String[] subscription;
    public static double DEFAULT_STEP_DURATION = 1.0;
    public static double DEFAULT_STEP_LENGTH = 0.1;
    public static double DEFAULT_START_TIME = 0.0;
    public static int DEFAULT_OUTPUT_INTERVAL = 1;
    private double lastResultTime = Double.NaN;

    public SysdynGameExperimentBase(Resource experiment, Resource model) {
        super(experiment, model);
    }

    public double getStepDuration() {
        return this.stepDuration;
    }

    public void setStepDuration(double duration) {
        this.stepDuration = duration;
    }

    public double getStepLength() {
        return this.stepLength;
    }

    public void setStepLength(double stepLength) {
        this.stepLength = stepLength;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public void setOutputInterval(int interval) {
        this.savePer = interval;
    }

    public Subscription subscribe(Collection<String> names) {
        Subscription result = new Subscription();
        int[] indexes = new int[names.size()];
        int index = 0;
        for (String name : names) {
            indexes[index++] = this.subscriptionIndexes.get(name);
        }
        result.exp = this;
        result.indexes = indexes;
        return result;
    }

    public Double getCurrentValue(String name) {
        Integer index;
        if (this.subscriptionIndexes != null && name != null && (index = this.subscriptionIndexes.get(name)) != null) {
            return this.currentValues[index];
        }
        return null;
    }

    public void setSubscribedResults(IProgressMonitor monitor, double time) throws Exception {
        monitor.subTask("Get results (time = " + time + ")");
        this.currentValues = this.getSolver().getSubscribedResults(this.currentValues);
        monitor.worked(1);
        monitor.subTask("Save results (time = " + time + ")");
        int k = 0;
        while (k < this.subscription.length) {
            this.setResults(time, k, this.currentValues[k]);
            ++k;
        }
        this.lastResultTime = time;
    }

    public void setResults(double time, int index, Double value) {
        TDoubleArrayList list = this.results[index];
        if (list == null) {
            this.results[index] = list = new TDoubleArrayList();
        }
        if (time == this.lastResultTime) {
            list.set(list.size() - 1, value.doubleValue());
        } else {
            list.add(value.doubleValue());
        }
    }

    public void clearResults() {
        this.lastResultTime = Double.NaN;
        int i = 0;
        while (i < this.results.length) {
            this.results[i] = null;
            ++i;
        }
    }

    public void simulateDuration(double duration, boolean useJob) {
        SimulateDurationJob job = new SimulateDurationJob(this, "Simulate steps", duration, useJob);
        if (useJob) {
            job.schedule();
        } else {
            job.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public void simulateDuration(double duration) {
        this.simulateDuration(duration, true);
    }

    public void refresh() {
    }

    public abstract ISolver getSolver();

    @Override
    public void init(ReadGraph g) {
        super.init(g);
        try {
            g.syncRequest((Read)new Read<Quad<Double, Double, Double, Double>>(){

                public Quad<Double, Double, Double, Double> perform(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Double stepDuration = (Double)graph.getPossibleRelatedValue(SysdynGameExperimentBase.this.experiment, sr.GameExperiment_stepDuration);
                    Double stepLength = (Double)graph.getPossibleRelatedValue(SysdynGameExperimentBase.this.experiment, sr.GameExperiment_stepLength);
                    Double outputInterval = (Double)graph.getPossibleRelatedValue(SysdynGameExperimentBase.this.model, sr.SysdynModel_outputInterval);
                    Double startTime = (Double)graph.getPossibleRelatedValue(SysdynGameExperimentBase.this.model, sr.SysdynModel_startTime);
                    return new Quad((Object)stepDuration, (Object)stepLength, (Object)outputInterval, (Object)startTime);
                }
            }, (AsyncProcedure)new AsyncListener<Quad<Double, Double, Double, Double>>(){

                public void execute(AsyncReadGraph graph, Quad<Double, Double, Double, Double> result) {
                    SysdynGameExperimentBase.this.setStepDuration(result.first != null ? (Double)result.first : DEFAULT_STEP_DURATION);
                    SysdynGameExperimentBase.this.setStepLength(result.second != null ? (Double)result.second : DEFAULT_STEP_LENGTH);
                    SysdynGameExperimentBase.this.setStartTime(result.fourth != null ? (Double)result.fourth : DEFAULT_START_TIME);
                    if (result.third == null) {
                        SysdynGameExperimentBase.this.setOutputInterval(DEFAULT_OUTPUT_INTERVAL);
                    } else {
                        int interval = (int)SysdynGameExperimentBase.getInterval((Double)result.third, SysdynGameExperimentBase.this.getStepLength());
                        SysdynGameExperimentBase.this.setOutputInterval(interval);
                    }
                }

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    throwable.printStackTrace();
                    SysdynGameExperimentBase.this.setStepDuration(DEFAULT_STEP_DURATION);
                    SysdynGameExperimentBase.this.setStepLength(DEFAULT_STEP_LENGTH);
                    SysdynGameExperimentBase.this.setStartTime(DEFAULT_START_TIME);
                    SysdynGameExperimentBase.this.setOutputInterval(DEFAULT_OUTPUT_INTERVAL);
                }

                public boolean isDisposed() {
                    return SysdynGameExperimentBase.this.getState().equals((Object)ExperimentState.DISPOSED);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onPublishResults() {
        try {
            this.setSubscribedResults((IProgressMonitor)new NullProgressMonitor(), this.getSolver().getTime());
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
        }
        ((MemoryResult)this.getCurrentResult()).setResult(new GameResult(this, this.results, this.subscription));
        super.onPublishResults();
    }

    public static class Subscription {
        public SysdynGameExperimentBase exp;
        public int[] indexes;

        public void getValues(double[] data) {
            int i = 0;
            while (i < this.indexes.length) {
                data[i] = this.exp.currentValues[this.indexes[i]];
                ++i;
            }
        }

        public void setValue(int i, double value) {
            if (this.exp == null) {
                return;
            }
            if (this.exp.currentValues == null) {
                return;
            }
            this.exp.currentValues[this.indexes[i]] = value;
        }
    }
}

