/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.contribution;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.ui.workbench.action.ResourceEditorAdapterAction;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.utils.strings.AlphanumComparator;

public class OpenWithMenuContribution
extends DynamicMenuContribution {
    private static final boolean DEBUG_ADAPTERS = false;
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.dispose();
    }

    protected Object extractResource(ReadGraph graph, Object object) throws DatabaseException {
        Resource resource = WorkbenchSelectionUtils.getPossibleResourceFromSelection((RequestProcessor)graph, object);
        return resource != null ? resource : object;
    }

    @Override
    protected boolean preAcceptSelection(Object[] selection) {
        return selection.length == 1;
    }

    @Override
    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        final Object r = this.extractResource(graph, selection[0]);
        final EditorAdapter[] editorAdapters = EditorRegistry.getInstance().getAdaptersFor(graph, r);
        if (editorAdapters.length == 0) {
            return NONE;
        }
        return new IContributionItem[]{new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem openWith = new MenuItem(menu, 64, index);
                openWith.setText("Open With");
                openWith.setEnabled(editorAdapters.length > 0);
                Menu subMenu = new Menu(menu);
                openWith.setMenu(subMenu);
                if (editorAdapters.length > 0) {
                    Adapter[] adapters = new Adapter[editorAdapters.length];
                    int i = 0;
                    while (i < editorAdapters.length) {
                        adapters[i] = new Adapter(editorAdapters[i], r, true);
                        ++i;
                    }
                    Arrays.sort(adapters, new Comparator<Adapter>(){

                        @Override
                        public int compare(Adapter o1, Adapter o2) {
                            int delta = o2.getPriority() - o1.getPriority();
                            if (delta != 0) {
                                return delta;
                            }
                            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.getText(), (Object)o2.getText());
                        }
                    });
                    Adapter[] adapterArray = adapters;
                    int n = adapters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Adapter a = adapterArray[n2];
                        OpenWithMenuContribution.this.addMenuItem(subMenu, a, r);
                        ++n2;
                    }
                }
            }
        }};
    }

    private void addMenuItem(Menu subMenu, Adapter adapter, Object r) {
        MenuItem item = new MenuItem(subMenu, 8);
        String text = adapter.getText();
        item.setText(text);
        ImageDescriptor descriptor = adapter.getImageDescriptor();
        if (descriptor != null) {
            item.setImage(this.resourceManager.createImage(descriptor));
        }
        item.addSelectionListener((SelectionListener)adapter);
    }

    static class Adapter
    extends ResourceEditorAdapterAction
    implements SelectionListener {
        boolean remember;

        public Adapter(EditorAdapter adapter, Object r, boolean remember) {
            super(adapter, r);
            this.remember = remember;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.run();
        }

        @Override
        protected void safeRun() throws Exception {
            super.safeRun();
            if (this.remember) {
                EditorRegistry.getInstance().getMappings().put(this.getResource(), this.getAdapter());
            }
        }
    }
}

