/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.contribution;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.utils.ui.BundleUtils;

public class NameLabelButtonTrim
extends Composite {
    LocalResourceManager resourceManager;

    public NameLabelButtonTrim(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        NameLabelMode initialMode = NameLabelUtil.getNameLabelMode((RequestProcessor)Simantics.getSession());
        final Button b = new Button((Composite)this, 8);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)b);
        b.setToolTipText(this.tooltip(initialMode));
        b.setImage(this.resourceManager.createImage(this.getDescriptor(initialMode)));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(initialMode){
            NameLabelMode mode;
            {
                this.mode = nameLabelMode;
            }

            public void widgetSelected(SelectionEvent e) {
                this.mode = this.mode.cycle();
                b.setImage(NameLabelButtonTrim.this.resourceManager.createImage(NameLabelButtonTrim.this.getDescriptor(this.mode)));
                b.setToolTipText(NameLabelButtonTrim.this.tooltip(this.mode));
                NameLabelUtil.setNameLabelMode((RequestProcessor)Simantics.getSession(), (NameLabelMode)this.mode);
            }
        });
    }

    private String tooltip(NameLabelMode currentMode) {
        return "Switch Name/Label Visualization Mode from " + currentMode.getLabel() + " to " + currentMode.cycle().getLabel();
    }

    private ImageDescriptor getDescriptor(NameLabelMode mode) {
        switch (mode) {
            case NAME: {
                return BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.ui", (String)"/icons/N.png");
            }
            case LABEL: {
                return BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.ui", (String)"/icons/L.png");
            }
            case NAME_AND_LABEL: {
                return BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.ui", (String)"/icons/N+L.png");
            }
            case LABEL_AND_NAME: {
                return BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.ui", (String)"/icons/L+N.png");
            }
        }
        throw new IllegalArgumentException("unrecognized name/label mode: " + mode);
    }
}

