/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.tableParser.ParseException;
import org.simantics.sysdyn.tableParser.TableParser;
import org.simantics.sysdyn.tableParser.Token;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionField;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;
import org.simantics.sysdyn.ui.properties.widgets.expressions.IExpression;
import org.simantics.sysdyn.ui.utils.SyntaxError;
import org.simantics.sysdyn.utils.SheetUtils;

public class WithLookupExpression
implements IExpression {
    private ExpressionField expression;
    private ExpressionField lookup;
    private ExpressionField lastSelectedText;
    private Timer updateChartTimer;
    private ChartPanel smallPanel;
    private Frame smallFrame;
    private final ExpressionWidgetInput input;
    private Resource expr;

    public WithLookupExpression(ExpressionWidgetInput input) {
        this.lastSelectedText = this.expression;
        this.input = input;
        this.expr = input.expression;
    }

    @Override
    public void createExpressionFields(Composite parent, final Map<String, Object> data, Table allowedVariables) {
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(parent);
        this.updateChartTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WithLookupExpression.this.updateChart();
            }
        });
        this.updateChartTimer.setRepeats(false);
        String equation = data.get("equation") != null ? (String)data.get("equation") : "";
        String lookupTable = data.get("lookup") != null ? (String)data.get("lookup") : "";
        Label l = new Label(parent, 0);
        l.setText("With\nLookup");
        this.expression = new ExpressionField(parent, 2048, allowedVariables, true, this.input);
        this.expression.setExpression(equation);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.expression);
        this.expression.getSourceViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WithLookupExpression.this.lastSelectedText = WithLookupExpression.this.expression;
            }
        });
        Composite chartContainer = new Composite(parent, 0);
        this.createChart(chartContainer, data);
        l = new Label(parent, 0);
        l.setText("Lookup\ntable");
        this.lookup = new ExpressionField(parent, 2048, null, false, this.input);
        this.lookup.setExpression(lookupTable);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.lookup);
        this.lookup.getSourceViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WithLookupExpression.this.lastSelectedText = WithLookupExpression.this.lookup;
                WithLookupExpression.this.save(WithLookupExpression.this.expr, data);
            }
        });
        this.lookup.getSourceViewer().getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WithLookupExpression.this.updateChartTimer.isRunning()) {
                    WithLookupExpression.this.updateChartTimer.start();
                } else {
                    WithLookupExpression.this.updateChartTimer.restart();
                }
            }
        });
        Simantics.getSession().asyncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                String result = "";
                if (WithLookupExpression.this.expr != null && graph.isInstanceOf(WithLookupExpression.this.expr, sr.WithLookupExpression)) {
                    result = (String)graph.getPossibleRelatedValue(WithLookupExpression.this.expr, sr.WithLookupExpression_lookup);
                }
                return result;
            }
        }, (Listener)new Listener<String>(){

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public void execute(final String result) {
                if (WithLookupExpression.this.lookup != null) {
                    WithLookupExpression.this.lookup.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WithLookupExpression.this.lookup.setExpression(result);
                            WithLookupExpression.this.updateChart();
                        }
                    });
                }
            }

            public boolean isDisposed() {
                return WithLookupExpression.this.lookup == null || WithLookupExpression.this.lookup.isDisposed();
            }
        });
        this.updateChart();
    }

    @Override
    public void focus() {
        if (this.lastSelectedText != null) {
            this.lastSelectedText.focus();
        }
    }

    @Override
    public List<ExpressionField> getExpressionFields() {
        return Arrays.asList(this.expression, this.lookup);
    }

    @Override
    public void readData(final Resource expression, Map<String, Object> data) {
        class Auxiliary {
            String equation;
            String lookup;

            Auxiliary() {
            }
        }
        Auxiliary results = null;
        if (data.get("equation") == null) {
            try {
                results = (Auxiliary)Simantics.getSession().syncRequest((Read)new Read<Auxiliary>(){

                    public Auxiliary perform(ReadGraph graph) throws DatabaseException {
                        Auxiliary results = new Auxiliary();
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        if (expression != null && graph.isInstanceOf(expression, sr.WithLookupExpression)) {
                            results.equation = (String)graph.getPossibleRelatedValue(expression, sr.WithLookupExpression_expression);
                            results.lookup = (String)graph.getPossibleRelatedValue(expression, sr.WithLookupExpression_lookup);
                        } else {
                            results.equation = "";
                            results.lookup = "";
                        }
                        return results;
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
            data.put("equation", results.equation == null ? "" : results.equation);
            data.put("lookup", results.lookup == null ? "" : results.lookup);
        }
    }

    @Override
    public void replaceSelection(String var) {
        if (this.lastSelectedText != null) {
            IDocument doc = this.lastSelectedText.getDocument();
            try {
                Point selection = this.lastSelectedText.getSelection();
                doc.replace(selection.x, selection.y, var);
                this.lastSelectedText.setSelection(selection.x + var.length());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void save(final Resource expression, Map<String, Object> data) {
        final String currentExpression = this.expression.getExpression();
        final String currentLookupTable = this.lookup.getExpression();
        String oldExpression = (String)data.get("equation");
        String oldLookupTable = (String)data.get("lookup");
        if (oldExpression == null || oldLookupTable == null || currentExpression != null && currentLookupTable != null && (!currentExpression.equals(oldExpression) || !currentLookupTable.equals(oldLookupTable))) {
            data.putAll(data);
            data.put("equation", currentExpression);
            data.put("lookup", currentLookupTable);
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph g) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                    if (!g.isInstanceOf(WithLookupExpression.this.expr, sr.WithLookupExpression)) {
                        final Resource newExpression = GraphUtils.create2((WriteGraph)g, (Resource)sr.WithLookupExpression, (Object[])new Object[]{sr.WithLookupExpression_minX, 0.0, sr.WithLookupExpression_maxX, 10.0, sr.WithLookupExpression_minY, 0.0, sr.WithLookupExpression_maxY, 10.0});
                        String arrayRange = (String)g.getPossibleRelatedValue(expression, sr.Expression_arrayRange, (Binding)Bindings.STRING);
                        if (arrayRange != null) {
                            g.claimLiteral(newExpression, sr.Expression_arrayRange, (Object)arrayRange);
                        }
                        final Resource variable = g.getSingleObject(expression, l0.PartOf);
                        Resource expressions = g.getPossibleObject(variable, sr.Variable_expressionList);
                        Resource node = ListUtils.getNode((ReadGraph)g, (Resource)expressions, (Resource)expression);
                        g.deny(node, l0.List_Element);
                        g.claim(node, l0.List_Element, newExpression);
                        g.deny(expression, l0.PartOf);
                        g.claim(newExpression, l0.PartOf, variable);
                        VirtualGraph runtime = (VirtualGraph)g.getService(VirtualGraph.class);
                        g.syncRequest((Write)new WriteRequest(runtime){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                                if (graph.hasStatement(variable, sr.IndependentVariable_activeExpression)) {
                                    graph.deny(variable, sr.IndependentVariable_activeExpression);
                                }
                                graph.claim(variable, sr.IndependentVariable_activeExpression, newExpression);
                            }
                        });
                        WithLookupExpression.this.expr = newExpression;
                    }
                    g.claimLiteral(WithLookupExpression.this.expr, sr.WithLookupExpression_expression, (Object)currentExpression);
                    g.claimLiteral(WithLookupExpression.this.expr, sr.WithLookupExpression_lookup, (Object)currentLookupTable);
                    g.markUndoPoint();
                    CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
                    g.addMetadata((Metadata)cm.add("Set lookup expression"));
                }
            });
        }
    }

    @Override
    public void updateData(Map<String, Object> data) {
        if (this.expression != null && this.expression.getExpression() != null) {
            data.put("equation", this.expression.getExpression());
        }
        if (this.lookup != null && this.lookup.getExpression() != null) {
            data.put("lookup", this.lookup.getExpression());
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.expression.getSourceViewer().getTextWidget().addKeyListener(listener);
        this.lookup.getSourceViewer().getTextWidget().addKeyListener(listener);
    }

    @Override
    public void addVerifyKeyListener(VerifyKeyListener listener) {
        this.expression.getSourceViewer().getTextWidget().addVerifyKeyListener(listener);
        this.lookup.getSourceViewer().getTextWidget().addVerifyKeyListener(listener);
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
        this.expression.getSourceViewer().getTextWidget().addModifyListener(listener);
        this.lookup.getSourceViewer().getTextWidget().addModifyListener(listener);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.expression.getSourceViewer().getTextWidget().addFocusListener(listener);
        this.lookup.getSourceViewer().getTextWidget().addFocusListener(listener);
    }

    private void createChart(Composite composite, Map<String, Object> data) {
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().span(1, 2).hint(150, -1).applyTo((Control)composite);
        Composite chartComposite = new Composite(composite, 0x1040000);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)chartComposite);
        this.smallFrame = SWT_AWT.new_Frame((Composite)chartComposite);
        XYSeriesCollection dataset = new XYSeriesCollection(new XYSeries((Comparable)((Object)"Lookup Table")));
        JFreeChart chart = WithLookupExpression.createChart((XYDataset)dataset);
        this.smallPanel = new ChartPanel(chart);
        this.smallFrame.add((Component)this.smallPanel);
    }

    private static JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.removeLegend();
        chart.getXYPlot().getDomainAxis().setTickLabelsVisible(true);
        chart.getXYPlot().getDomainAxis().setAxisLineVisible(false);
        chart.getXYPlot().getDomainAxis().setTickMarksVisible(true);
        chart.getXYPlot().getRangeAxis().setTickLabelsVisible(true);
        chart.getXYPlot().getRangeAxis().setAxisLineVisible(false);
        chart.getXYPlot().getRangeAxis().setTickMarksVisible(true);
        chart.getXYPlot().getRenderer().setSeriesStroke(0, (Stroke)new BasicStroke(3.0f));
        return chart;
    }

    private void updateChart() {
        ArrayList<Point2D.Double> dataPoints;
        block10: {
            dataPoints = new ArrayList<Point2D.Double>();
            TableParser parser = new TableParser((Reader)new StringReader(""));
            parser.ReInit((Reader)new StringReader(this.lookup.getExpression()));
            try {
                parser.table();
                ArrayList xTokens = parser.getXTokens();
                ArrayList arrayList = parser.getYTokens();
                int i = 0;
                while (i < xTokens.size()) {
                    dataPoints.add(new Point2D.Double(Double.parseDouble(((Token)xTokens.get((int)i)).image), Double.parseDouble(((Token)arrayList.get((int)i)).image)));
                    ++i;
                }
            }
            catch (ParseException e1) {
                if (!this.lookup.getExpression().matches("[a-zA-Z0-9]*\\([a-zA-Z0-9:]*\\)")) break block10;
                try {
                    final String string = this.lookup.getExpression().substring(0, this.lookup.getExpression().indexOf("("));
                    final String range = this.lookup.getExpression().substring(this.lookup.getExpression().indexOf("(") + 1, this.lookup.getExpression().indexOf(")"));
                    String possibleTable = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            Variable variable = ((WithLookupExpression)WithLookupExpression.this).input.variable;
                            Resource model = Variables.getModel((ReadGraph)graph, (Variable)variable);
                            return SheetUtils.getStringRepresentation((ReadGraph)graph, (Resource)model, (String)string, (String)range);
                        }
                    });
                    try {
                        if (possibleTable == null) {
                            ParseException e = new ParseException(e1.getMessage());
                            e.currentToken = e1.currentToken;
                            throw e;
                        }
                        parser.ReInit((Reader)new StringReader(possibleTable));
                        parser.table();
                        ArrayList xTokens = parser.getXTokens();
                        ArrayList yTokens = parser.getYTokens();
                        int i = 0;
                        while (i < xTokens.size()) {
                            dataPoints.add(new Point2D.Double(Double.parseDouble(((Token)xTokens.get((int)i)).image), Double.parseDouble(((Token)yTokens.get((int)i)).image)));
                            ++i;
                        }
                    }
                    catch (ParseException e2) {
                        this.lookup.setSyntaxError(new SyntaxError(e2.currentToken, "Syntax Error"));
                        System.out.println("MESSAGE: " + e2.getMessage());
                        return;
                    }
                }
                catch (DatabaseException databaseException) {
                    databaseException.printStackTrace();
                }
            }
        }
        XYSeries series = new XYSeries((Comparable)((Object)"Lookup Table"));
        for (Point2D point2D : dataPoints) {
            series.add(point2D.getX(), point2D.getY());
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(series);
        this.smallPanel.getChart().getXYPlot().setDataset((XYDataset)xYSeriesCollection);
    }

    @Override
    public IUndoManager getUndoManager() {
        return null;
    }
}

