/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import org.simantics.diagram.elements.TextEditActivation;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.sysdyn.ui.elements.LoopNode;
import org.simantics.sysdyn.ui.elements.SysdynElementHints;
import org.simantics.sysdyn.ui.utils.SysdynWorkbenchUtils;

public class SysdynTextNode
extends TextNode
implements LoopNode.ILoopComponentNode {
    private static final long serialVersionUID = 5235077104121753251L;
    private HashMap<LoopNode, Boolean> loopSelectionMap = new HashMap();

    private boolean isLoopSelected() {
        return this.loopSelectionMap.containsValue(true);
    }

    public int getEventMask() {
        return EventTypes.FocusLostMask | super.getEventMask();
    }

    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        if (SysdynElementHints.LOCK_TOOL.equals(SysdynWorkbenchUtils.getSysdynToolMode())) {
            super.mouseDragged(e);
            return true;
        }
        return super.mouseDragged(e);
    }

    protected void renderSelectedHover(Graphics2D g, boolean isSelected, boolean isHovering) {
        if (!isSelected && isHovering) {
            BasicStroke oldStroke = (BasicStroke)g.getStroke();
            Color oldColor = g.getColor();
            g.setColor(Color.LIGHT_GRAY);
            g.setStroke(new BasicStroke((float)(2.0 * this.scale)));
            g.draw(this.getBoundsInLocal());
            g.setColor(oldColor);
            g.setStroke(oldStroke);
        } else if (this.isLoopSelected()) {
            BasicStroke oldStroke = (BasicStroke)g.getStroke();
            Color oldColor = g.getColor();
            g.setColor(LoopNode.HIGHLIGHT_COLOR);
            g.setStroke(new BasicStroke((float)(2.0 * this.scale)));
            g.draw(this.getBoundsInLocal());
            g.setColor(oldColor);
            g.setStroke(oldStroke);
        }
    }

    public TextEditActivation activateEdit(int mouseId, IElement e, ICanvasContext ctx, boolean save) {
        if (save) {
            this.editActivation = super.activateEdit(mouseId, e, ctx);
            return this.editActivation;
        }
        return super.activateEdit(mouseId, e, ctx);
    }

    @Override
    public void setLoopSelected(LoopNode loop, boolean selected) {
        Boolean loopSelected = this.loopSelectionMap.get((Object)loop);
        if (loopSelected == null || loopSelected != selected) {
            this.loopSelectionMap.put(loop, selected);
            this.repaint();
        }
    }
}

