/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history;

import java.util.Arrays;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.history.Collector;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.util.StreamIterator;

public class HistorySamplerItem2
implements Comparable<HistorySamplerItem2> {
    Collector collector;
    HistoryManager history;
    LevelItem[] items;
    StreamAccessor accessor;
    public StreamIterator iter;
    public int chartDataId;

    public HistorySamplerItem2(Collector collector, HistoryManager history, LevelItem[] items, int identityHashCode) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Must have at least one existing history item to sample, zero provided");
        }
        this.collector = collector;
        this.history = history;
        this.items = items;
        this.chartDataId = identityHashCode;
    }

    public void flush() throws HistoryException {
        if (this.collector != null) {
            this.collector.flush();
        }
    }

    public void open() throws HistoryException {
        this.accessor = this.history.openStream(this.items[0].id, "r");
        this.iter = new StreamIterator((ArrayAccessor)this.accessor);
    }

    public void open(double pixelsPerSecond) throws HistoryException {
        LevelItem f = this.getFormat(pixelsPerSecond);
        this.accessor = this.history.openStream(f.id, "r");
        this.iter = new StreamIterator((ArrayAccessor)this.accessor);
    }

    public void close() {
        if (this.accessor != null) {
            try {
                this.accessor.close();
            }
            catch (AccessorException accessorException) {}
        }
        this.accessor = null;
        this.iter = null;
    }

    @Override
    public int compareTo(HistorySamplerItem2 o) {
        int m = Math.min(this.items.length, o.items.length);
        int j = 0;
        while (j < m) {
            int i = this.items[j].compareTo(o.items[j]);
            if (i != 0) {
                return i;
            }
            ++j;
        }
        return 0;
    }

    public int hashCode() {
        int code = 8964;
        code = 13 * code + Arrays.hashCode(this.items);
        code = 13 * code + this.history.hashCode();
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistorySamplerItem2)) {
            return false;
        }
        HistorySamplerItem2 other = (HistorySamplerItem2)obj;
        if (!other.history.equals(this.history)) {
            return false;
        }
        return Arrays.equals(other.items, this.items);
    }

    private LevelItem getFormat(double secondsPerPixel) throws HistoryException {
        LevelItem result = null;
        LevelItem[] levelItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            LevelItem format = levelItemArray[n2];
            double interval = format.samplingInterval;
            if (!Double.isNaN(interval) && !(interval <= secondsPerPixel)) break;
            result = format;
            ++n2;
        }
        return result;
    }

    public static class LevelItem
    implements Comparable<LevelItem> {
        public final String id;
        public final double samplingInterval;

        public LevelItem(String id, double samplingInterval) {
            this.id = id;
            this.samplingInterval = samplingInterval;
        }

        @Override
        public int compareTo(LevelItem o) {
            int i = this.id.compareTo(o.id);
            return i != 0 ? i : Double.compare(this.samplingInterval, o.samplingInterval);
        }
    }
}

