/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.impl.hash.THash;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.strategy.HashingStrategy;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public abstract class StableObjectHash<T>
extends THash
implements HashingStrategy<T> {
    static final long serialVersionUID = -3461112548087185871L;
    protected transient Object[] _set;
    protected HashingStrategy<T> _hashingStrategy = this;
    protected static final Object REMOVED = new Object();
    protected static final Object FREE = new Object();

    public StableObjectHash() {
        super(10, 0.75f);
    }

    public StableObjectHash<T> clone() {
        StableObjectHash h;
        try {
            h = (StableObjectHash)((Object)super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
        h._set = (Object[])this._set.clone();
        return h;
    }

    public int capacity() {
        return this._set.length;
    }

    protected void removeAt(int index) {
        this._set[index] = REMOVED;
        super.removeAt(index);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new Object[capacity];
        Arrays.fill(this._set, FREE);
        return capacity;
    }

    public boolean forEach(TObjectProcedure<T> procedure) {
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == FREE || set[i] == REMOVED || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object obj) {
        throw new UnsupportedOperationException();
    }

    protected int index(T obj, Object[] _set) {
        Object[] set = _set;
        int length = set.length;
        int hash = obj.hashCode() & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == FREE) {
            return -1;
        }
        if (cur == REMOVED || !obj.equals(cur)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != FREE && (cur == REMOVED || !obj.equals(cur)));
        }
        return cur == FREE ? -1 : index;
    }

    protected int index(T obj, int hash_, Object[] _set) {
        Object[] set = _set;
        int hash = hash_ & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        Object cur = set[index];
        if (cur == FREE) {
            return -1;
        }
        if (cur == REMOVED || !obj.equals(cur)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != FREE && (cur == REMOVED || !obj.equals(cur)));
        }
        return cur == FREE ? -1 : index;
    }

    protected int insertionIndex(T obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = obj.hashCode() & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == FREE) {
            return index;
        }
        if (cur != REMOVED && obj.equals(cur)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != FREE && cur != REMOVED && !obj.equals(cur));
        }
        if (cur == REMOVED) {
            int firstRemoved = index;
            while (!(cur == FREE || cur != REMOVED && obj.equals(cur))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != FREE ? -index - 1 : firstRemoved;
        }
        return cur != FREE ? -index - 1 : index;
    }

    protected int insertionIndex(T obj, int hash_) {
        Object[] set = this._set;
        int hash = hash_ & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        Object cur = set[index];
        if (cur == FREE) {
            return index;
        }
        if (cur != REMOVED && obj.equals(cur)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != FREE && cur != REMOVED && !obj.equals(cur));
        }
        if (cur == REMOVED) {
            int firstRemoved = index;
            while (!(cur == FREE || cur != REMOVED && obj.equals(cur))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != FREE ? -index - 1 : firstRemoved;
        }
        return cur != FREE ? -index - 1 : index;
    }

    public final int computeHashCode(T o) {
        return o == null ? 0 : o.hashCode();
    }

    public final boolean equals(T o1, T o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + "; object #2 =" + o2);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
        out.writeObject(this._hashingStrategy);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        in.readByte();
        this._hashingStrategy = (HashingStrategy)in.readObject();
    }
}

