/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.connection;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.handler.Validator;
import org.simantics.g2d.diagram.handler.impl.DiagramIssue;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.routing.algorithm1.Rectangle;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.g2d.utils.PathUtils;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.utils.datastructures.TreeProblem;

public class ConnectionValidator
implements Validator {
    public static final ConnectionValidator INSTANCE = new ConnectionValidator();
    private static final double TOLERANCE = 0.001;
    private static final Validator.Suggestion DISCONNECT_EDGES = new Validator.Suggestion(){

        @Override
        public boolean fix(IDiagram d, ICanvasContext ctx) {
            return false;
        }

        @Override
        public String getMessage() {
            return "Disconnect edges";
        }
    };
    public static final double OBSTACLE_MARGINAL = 10.0;
    private static final Validator.Suggestion FORCE_PATH_TO_REQUIREMENTS = new Validator.Suggestion(){

        @Override
        public boolean fix(IDiagram d, ICanvasContext ctx) {
            ArrayList<PathRequirement> reqs = new ArrayList<PathRequirement>();
            for (IElement e : d.getElements()) {
                BendsHandler bends = e.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
                if (bends == null) continue;
                Path2D path = bends.getPath(e);
                if (!$assertionsDisabled && path == null) {
                    throw new AssertionError();
                }
                reqs.clear();
                ConnectionValidator.createPathRequirement(e, reqs);
                if (reqs.isEmpty() || ConnectionValidator.pathFollowsRequirements(path, reqs)) continue;
                BendsHandler.AngleType at = bends.getAngleType(e);
                if (at == BendsHandler.AngleType.Linear) {
                    path = ConnectionValidator.createPathLinear(reqs);
                } else if (at == BendsHandler.AngleType.RightAngled) {
                    path = ConnectionValidator.createPathRightAngled(reqs);
                } else if (at == BendsHandler.AngleType.Quadratic) {
                    path = ConnectionValidator.createPathQuadratic(reqs);
                } else if (at == BendsHandler.AngleType.Line) {
                    path = ConnectionValidator.createPathLine(reqs);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                if (path == null) {
                    path = ConnectionValidator.createPathLine(reqs);
                }
                AffineTransform elementToDiagramAt = ElementUtils.getInvTransform(e);
                path.transform(elementToDiagramAt);
                bends.setPath(e, path);
            }
            return false;
        }

        @Override
        public String getMessage() {
            return "Update path";
        }
    };
    private static final Validator.Issue PATH_IS_BROKEN = new DiagramIssue("Path does not follow its requirements (connects and bends)", FORCE_PATH_TO_REQUIREMENTS, DISCONNECT_EDGES);

    static Collection<Rectangle> createObstacles(IDiagram d) {
        ArrayList<Rectangle> obstacles = new ArrayList<Rectangle>();
        for (IElement e : d.getElements()) {
            if (e.getElementClass().containsClass(EdgeVisuals.class)) continue;
            Rectangle2D rect = ElementUtils.getElementBounds(e);
            obstacles.add(new Rectangle(rect.getMinX() - 10.0, rect.getMinY() - 10.0, rect.getMaxX() + 10.0, rect.getMaxY() + 10.0));
        }
        return obstacles;
    }

    @Override
    public void validate(IDiagram d, ICanvasContext ctx, Collection<Validator.Issue> lst) {
        if (!this.validateDiagramOk(d, ctx, lst)) {
            lst.add(PATH_IS_BROKEN);
        }
    }

    boolean validateDiagramOk(IDiagram d, ICanvasContext ctx, Collection<Validator.Issue> lst) {
        ArrayList<PathRequirement> reqs = new ArrayList<PathRequirement>();
        for (IElement e : d.getElements()) {
            BendsHandler bends = e.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            if (bends == null) continue;
            Path2D path = bends.getPath(e);
            reqs.clear();
            ConnectionValidator.createPathRequirement(e, reqs);
            if (reqs.isEmpty() || ConnectionValidator.pathFollowsRequirements(path, reqs)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean pathFollowsRequirements(Path2D path, List<PathRequirement> reqs) {
        if (reqs.size() == 0) {
            return true;
        }
        reqIndex = 0;
        req = reqs.get(reqIndex++);
        pi = path.getPathIterator(null);
        lsi = PathUtils.toLineIterator(pi);
        if (!lsi.hasNext()) {
            return false;
        }
        seg = lsi.next();
        pos = PathUtils.getLinePos(seg, 0.0);
        rect = new Rectangle2D.Double(pos.getX() - 0.001, pos.getY() - 0.001, 0.002, 0.002);
        if (!rect.contains(pos)) {
            return false;
        }
        tang = PathUtils.getLineTangent(seg, 0.0);
        dir = GeometryUtils.getCompassDirection(tang);
        closestDir = req.set.getClosestDirection(dir, 0.1);
        if (closestDir != null) ** GOTO lbl24
        return false;
lbl-1000:
        // 1 sources

        {
            seg = lsi.next();
            pos = PathUtils.getLinePos(seg, 1.0);
            rect = new Rectangle2D.Double(pos.getX() - 0.001, pos.getY() - 0.001, 0.002, 0.002);
            if (!rect.contains(pos) || (closestDir = req.set.getClosestDirection(dir = GeometryUtils.getCompassDirection(tang = PathUtils.getLineTangent(seg, 1.0)), 0.1)) == null) continue;
            req = reqs.get(reqIndex++);
lbl24:
            // 3 sources

            ** while (lsi.hasNext())
        }
lbl25:
        // 1 sources

        return reqIndex == reqs.size();
    }

    public static Path2D createPathLinear(List<PathRequirement> reqs) {
        LinearEdgeSolutionNode s = new LinearEdgeSolutionNode();
        s.reqs = reqs;
        LinearEdgeSolutionNode solution = (LinearEdgeSolutionNode)TreeProblem.findSolution((TreeProblem.ProblemNode)s, (int)2);
        if (solution == null) {
            return null;
        }
        return solution.toPath();
    }

    public static Path2D createPathLine(List<PathRequirement> reqs) {
        Path2D.Double result = new Path2D.Double();
        int index = 0;
        for (PathRequirement r : reqs) {
            if (index++ == 0) {
                ((Path2D)result).moveTo(r.pos.getX(), r.pos.getY());
                continue;
            }
            ((Path2D)result).lineTo(r.pos.getX(), r.pos.getY());
        }
        return result;
    }

    public static Path2D createPathRightAngled(List<PathRequirement> reqs) {
        Path2D.Double res = new Path2D.Double();
        return res;
    }

    public static Path2D createPathQuadratic(List<PathRequirement> reqs) {
        Path2D.Double res = new Path2D.Double();
        return res;
    }

    public static void createPathRequirement(IElement e, List<PathRequirement> pathRequirement) {
        Topology t = ElementUtils.getDiagram(e).getDiagramClass().getSingleItem(Topology.class);
        pathRequirement.clear();
        if (t == null) {
            return;
        }
        Topology.Connection c1 = t.getConnection(e, EdgeVisuals.EdgeEnd.Begin);
        if (c1 != null) {
            PathRequirement req = new PathRequirement();
            AffineTransform at = TerminalUtil.getTerminalPosOnDiagram(c1.node, c1.terminal);
            req.pos = new Point2D.Double(at.getTranslateX(), at.getTranslateY());
            req.set = ElementUtils.getTerminalDirection(c1.node, c1.terminal);
            req.isBegin = true;
            pathRequirement.add(req);
        }
        AffineTransform elementTransform = ElementUtils.getTransform(e);
        BendsHandler bends = e.getElementClass().getSingleItem(BendsHandler.class);
        ArrayList<BendsHandler.Bend> controlPoints = new ArrayList<BendsHandler.Bend>();
        bends.getBends(e, controlPoints);
        for (BendsHandler.Bend cp : controlPoints) {
            Point2D.Double pos = new Point2D.Double();
            bends.getBendPosition(e, cp, pos);
            elementTransform.transform(pos, pos);
            PathRequirement req = new PathRequirement();
            req.set = DirectionSet.NESW;
            req.pos = pos;
            pathRequirement.add(req);
        }
        Topology.Connection c2 = t.getConnection(e, EdgeVisuals.EdgeEnd.End);
        if (c2 != null) {
            PathRequirement req = new PathRequirement();
            AffineTransform at = TerminalUtil.getTerminalPosOnDiagram(c2.node, c2.terminal);
            req.pos = new Point2D.Double(at.getTranslateX(), at.getTranslateY());
            req.set = ElementUtils.getTerminalDirection(c2.node, c2.terminal);
            req.set = req.set.createInverse();
            req.isEnd = true;
            pathRequirement.add(req);
        }
    }

    static class LinearEdgeSolutionNode
    implements TreeProblem.ProblemNode {
        List<PathRequirement> reqs;
        LinearEdgeSolutionNode prevBranch;
        int index;
        double cost;
        Point2D p0;
        Point2D cp;
        Point2D p1;
        Point2D v0;
        Point2D v1;
        Point2D v1o;

        LinearEdgeSolutionNode() {
        }

        public void branch(Collection<TreeProblem.ProblemNode> list) {
            PathRequirement r0 = this.reqs.get(this.index);
            PathRequirement r1 = this.reqs.get(this.index + 1);
            Point2D p0 = r0.pos;
            Point2D p1 = r1.pos;
            Point2D.Double cp1 = new Point2D.Double();
            Point2D.Double cp2 = new Point2D.Double();
            HashSet<Point2D> controlPoints = new HashSet<Point2D>();
            for (Point2D v0 : r0.set.getUnitVectors()) {
                for (Point2D v1 : r1.set.getUnitVectors()) {
                    Point2D i = PathUtils.findIntersection(p0, v0, p1, v1);
                    if (i != null) {
                        controlPoints.add(i);
                        continue;
                    }
                    int flags = PathUtils.findNearestPoints(p0, v0, p1, v1, cp1, cp2);
                    if ((flags & 1) == 1) {
                        controlPoints.add(cp1);
                    }
                    if ((flags & 2) != 2) continue;
                    controlPoints.add(cp2);
                }
            }
            if (controlPoints.isEmpty()) {
                Point2D.Double i = new Point2D.Double((p0.getX() + p1.getX()) / 2.0, (p0.getY() + p1.getY()) / 2.0);
                controlPoints.add(i);
            }
            Iterator<Point2D> iterator = controlPoints.iterator();
            while (iterator.hasNext()) {
                Point2D dada;
                Point2D c0 = dada = iterator.next();
                double price = p0.distance(c0) + c0.distance(p1);
                LinearEdgeSolutionNode s = new LinearEdgeSolutionNode();
                s.cost = this.cost + (price -= p0.distance(p1));
                s.prevBranch = this;
                s.reqs = this.reqs;
                s.index = this.index + 1;
                s.p0 = p0;
                s.p1 = p1;
                if (!c0.equals(p0) && !c0.equals(p1)) {
                    s.cp = c0;
                }
                Point2D np = s.cp == null ? p1 : c0;
                double dist = p0.distance(np);
                s.v0 = new Point2D.Double((p0.getX() - np.getX()) / dist, (p0.getY() - np.getY()) / dist);
                np = s.cp == null ? p0 : c0;
                dist = p1.distance(np);
                s.v1 = new Point2D.Double((p1.getX() - np.getX()) / dist, (p1.getY() - np.getY()) / dist);
                s.v1o = new Point2D.Double((np.getX() - p1.getX()) / dist, (np.getY() - p1.getY()) / dist);
                if (this.v1 != null && !s.v0.equals(this.v1)) {
                    s.cost += 1.0;
                }
                if (this.v1o != null && this.v1o.equals(s.v0)) {
                    s.cost += 2.0;
                }
                list.add(s);
            }
        }

        public double getCost() {
            return this.cost;
        }

        public boolean isComplete() {
            return this.index >= this.reqs.size() - 1;
        }

        public List<LinearEdgeSolutionNode> toList() {
            LinkedList<LinearEdgeSolutionNode> res = new LinkedList<LinearEdgeSolutionNode>();
            LinearEdgeSolutionNode branch = this;
            while (branch != null) {
                res.addFirst(branch);
                branch = branch.prevBranch;
            }
            return res;
        }

        public Path2D toPath() {
            Path2D.Double p = new Path2D.Double();
            for (LinearEdgeSolutionNode s : this.toList()) {
                if (s.p0 == null) continue;
                Point2D cur = p.getCurrentPoint();
                if (cur == null) {
                    ((Path2D)p).moveTo(s.p0.getX(), s.p0.getY());
                }
                cur = p.getCurrentPoint();
                if (!(s.cp == null || cur != null && cur.equals(s.cp))) {
                    ((Path2D)p).lineTo(s.cp.getX(), s.cp.getY());
                }
                if ((cur = p.getCurrentPoint()) != null && cur.equals(s.p1)) continue;
                ((Path2D)p).lineTo(s.p1.getX(), s.p1.getY());
            }
            return p;
        }
    }

    static class PathRequirement {
        Point2D pos;
        DirectionSet set;
        boolean isBegin;
        boolean isEnd;

        PathRequirement() {
        }
    }
}

