/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.List;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.utils.ui.ErrorLogger;

public class EnumerationVariableModifier3
implements Labeler.EnumerationModifier {
    protected final Session session;
    protected final Variable variable;
    protected final List<String> allowedValues;
    protected final String defaultValue;
    protected Throwable modifierFailed;

    public EnumerationVariableModifier3(RequestProcessor processor, Variable variable, List<String> allowedValues) {
        this.session = processor.getSession();
        this.variable = variable;
        this.allowedValues = allowedValues;
        this.defaultValue = this.computeDefaultValue(processor, variable);
    }

    protected String computeDefaultValue(RequestProcessor processor, final Variable variable) {
        try {
            return (String)processor.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return (String)variable.getValue(graph);
                }
            });
        }
        catch (DatabaseException databaseException) {
            return "";
        }
    }

    protected void doModify(String label) {
        this.session.asyncRequest((org.simantics.db.request.Write)new Write(this.variable, label), parameter -> {
            if (parameter != null) {
                ErrorLogger.defaultLogError((Throwable)parameter);
            }
        });
    }

    public String getValue() {
        return this.defaultValue;
    }

    public String isValid(String label) {
        if (this.modifierFailed != null) {
            return "Could not resolve validator for this value, modification denied. Reason: " + this.modifierFailed.getMessage();
        }
        return null;
    }

    public final void modify(String label) {
        if (this.modifierFailed != null) {
            throw new Error("modifier failed: " + this.modifierFailed.getMessage());
        }
        this.doModify(label);
    }

    public List<String> getValues() {
        return this.allowedValues;
    }

    public class Write
    extends WriteRequest {
        private final Variable variable;
        private final String label;

        public Write(Variable variable, String label) {
            super(null);
            this.variable = variable;
            this.label = label;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            this.variable.setValue(graph, (Object)this.label, (Binding)Bindings.STRING);
        }
    }
}

