/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.AllVariablesOfModel;
import org.simantics.jfreechart.chart.properties.ChartVariable;
import org.simantics.utils.ui.AdaptionUtils;

public class VariableProposalProvider
implements IContentProposalProvider,
Widget {
    private Collection<ChartVariable> proposals = new ArrayList<ChartVariable>();
    private IContentProposal[] contentProposals;
    private boolean filterProposals = false;
    private boolean compareRVI = false;
    private Resource resource;
    private Control control;

    public IContentProposal[] getProposals(String contents, int position) {
        if (this.filterProposals) {
            ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
            if (this.compareRVI) {
                for (ChartVariable proposal : this.proposals) {
                    if (proposal.getRvi().length() >= contents.length() && proposal.getRvi().substring(0, contents.length()).equalsIgnoreCase(contents)) {
                        if (proposal.getLabel() != null) {
                            list.add(new ContentProposal(proposal.getRvi(), proposal.getLabel(), null));
                            continue;
                        }
                        list.add(new ContentProposal(proposal.getRvi()));
                        continue;
                    }
                    if (proposal.getLabel() == null || proposal.getLabel().length() < contents.length() || !proposal.getLabel().substring(0, contents.length()).equalsIgnoreCase(contents)) continue;
                    list.add(new ContentProposal(proposal.getRvi(), proposal.getLabel(), null));
                }
            } else {
                for (ChartVariable proposal : this.proposals) {
                    if (proposal.getLabel() == null || proposal.getLabel().length() < contents.length() || !proposal.getLabel().substring(0, contents.length()).equalsIgnoreCase(contents)) continue;
                    list.add(new ContentProposal(proposal.getRvi(), proposal.getLabel(), null));
                }
            }
            return list.toArray(new IContentProposal[list.size()]);
        }
        if (this.contentProposals == null) {
            this.contentProposals = new IContentProposal[this.proposals.size()];
            Iterator<ChartVariable> iter = this.proposals.iterator();
            int i = 0;
            while (i < this.proposals.size()) {
                ChartVariable proposal = iter.next();
                this.contentProposals[i] = proposal.getLabel() != null ? new ContentProposal(proposal.getRvi(), proposal.getLabel(), null) : new ContentProposal(proposal.getRvi());
                ++i;
            }
        }
        return this.contentProposals;
    }

    public void setProposals(Collection<ChartVariable> items) {
        this.proposals = items;
        this.contentProposals = null;
    }

    public void setFiltering(boolean filterProposals) {
        this.filterProposals = filterProposals;
        this.contentProposals = null;
    }

    public VariableProposalProvider(Control control, WidgetSupport support) {
        support.register((Widget)this);
        this.control = control;
    }

    public void setInput(ISessionContext context, Object input) {
        final Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        if (resource == null) {
            return;
        }
        this.resource = resource;
        try {
            AllVariablesOfModel query = AllVariablesOfModel.withRandomResource(context, resource);
            Simantics.getSession().asyncRequest((Read)query, (Listener)new Listener<Collection<ChartVariable>>(){

                public void execute(Collection<ChartVariable> result) {
                    VariableProposalProvider.this.setProposals(result);
                }

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public boolean isDisposed() {
                    return VariableProposalProvider.this.control == null || VariableProposalProvider.this.control.isDisposed() || !resource.equals(VariableProposalProvider.this.resource);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }
}

