/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.style;

import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteGraphConnectionClass;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.handler.Paster;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.SelectionOutline;
import org.simantics.g2d.element.handler.impl.ConnectionSelectionOutline;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagram.style.TypicalInheritanceResult;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.IdentityAffineTransform;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.DecorationShapeNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.structural.stubs.StructuralResource2;

public class TypicalInheritanceStyle
extends StyleBase<TypicalInheritanceResult> {
    private static final TypicalInheritanceResult NOT_INHERITED = new TypicalInheritanceResult(Boolean.FALSE, null, null, Boolean.FALSE, null);
    private static final Paint PAINT = new Color(128, 128, 128, 64);
    private static final Paint PAINT_WITHOUT_SOURCE = new Color(255, 128, 128, 64);
    private static final Stroke STROKE = new BasicStroke(2.0f, 0, 1);

    public TypicalInheritanceResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        boolean templatized = graph.hasStatement(element, MOD.IsTemplatized);
        boolean hasElementSource = graph.hasStatement(element, MOD.HasElementSource);
        if (templatized) {
            if (graph.isInstanceOf(element, DIA.RouteGraphConnection)) {
                Collection connectors = graph.getObjects(element, DIA.HasConnector);
                Collection routeNodes = graph.getObjects(element, DIA.HasInteriorRouteNode);
                TLongHashSet nonTemplatizedConnectors = null;
                HashSet<Object> identifier = new HashSet<Object>(connectors.size() + routeNodes.size());
                block0: for (Resource connector : connectors) {
                    for (Resource connectedTo : graph.getObjects(connector, STR.Connects)) {
                        if (connectedTo.equals(element)) continue;
                        AffineTransform at = DiagramGraphUtil.getDynamicAffineTransform((ReadGraph)graph, (Resource)runtimeDiagram, (Resource)connectedTo, (Resource)DIA.HasDynamicTransform, (boolean)false);
                        identifier.add(at);
                        boolean connectedToTemplatized = graph.hasStatement(connectedTo, MOD.IsTemplatized);
                        if (connectedToTemplatized) continue block0;
                        if (nonTemplatizedConnectors == null) {
                            nonTemplatizedConnectors = new TLongHashSet();
                        }
                        nonTemplatizedConnectors.add(connector.getResourceId());
                        continue block0;
                    }
                }
                if (!routeNodes.isEmpty()) {
                    for (Resource routeLine : routeNodes) {
                        Paster.RouteLine rl = Paster.readRouteLine((ReadGraph)graph, (Resource)routeLine);
                        identifier.add(rl);
                    }
                }
                return new TypicalInheritanceResult(templatized, (TLongSet)nonTemplatizedConnectors, (AffineTransform)IdentityAffineTransform.INSTANCE, hasElementSource, (Set<Object>)identifier);
            }
            if (graph.isInstanceOf(element, DIA.Monitor)) {
                AffineTransform worldTransform = DiagramGraphUtil.getWorldTransform((ReadGraph)graph, (Resource)element);
                Resource monitoredComponent = graph.getPossibleObject(element, DIA.HasMonitorComponent);
                if (monitoredComponent != null) {
                    Resource monitoredDiagram;
                    Resource diagram;
                    Resource tailNode;
                    Resource monitoredElement = graph.getPossibleObject(monitoredComponent, MOD.ComponentToElement);
                    if (graph.isInstanceOf(monitoredElement, DIA.Connection) && (tailNode = ConnectionUtil.getConnectionTailNode((ReadGraph)graph, (Resource)monitoredElement)) != null) {
                        monitoredElement = tailNode;
                    }
                    if (monitoredElement != null && (diagram = (Resource)graph.syncRequest((Read)new PossibleTypedParent(element, DIA.Diagram))) != null && diagram.equals(monitoredDiagram = (Resource)graph.syncRequest((Read)new PossibleTypedParent(monitoredElement, DIA.Diagram)))) {
                        AffineTransform monitoredElementWorldTransform = DiagramGraphUtil.getWorldTransform((ReadGraph)graph, (Resource)monitoredElement);
                        worldTransform.preConcatenate(monitoredElementWorldTransform);
                    }
                }
                return new TypicalInheritanceResult(templatized, null, worldTransform, hasElementSource, null);
            }
            AffineTransform worldTransform = DiagramGraphUtil.getDynamicWorldTransform((ReadGraph)graph, (Resource)runtimeDiagram, (Resource)element);
            return new TypicalInheritanceResult(templatized, null, worldTransform, hasElementSource, null);
        }
        return NOT_INHERITED;
    }

    public void applyStyleForItem(EvaluationContext context, DataNodeMap map, Object item, TypicalInheritanceResult result) {
        INode _node = map.getNode(item);
        if (result != null && Boolean.TRUE.equals(result.isTemplatized())) {
            AffineTransform at;
            IElement element;
            DataElementMap dem;
            boolean fill = true;
            Stroke stroke = null;
            ShapeNode node = null;
            if (!(_node instanceof ParentNode)) {
                return;
            }
            node = (ShapeNode)ProfileVariables.claimChild((INode)_node, (String)"", (String)"typical", DecorationShapeNode.class, (Observer)context);
            if (_node instanceof ConnectionNode) {
                fill = false;
                stroke = STROKE;
            }
            Shape shape = null;
            IDiagram diagram = (IDiagram)context.getConstant(ProfileKeys.DIAGRAM);
            if (diagram != null && (dem = (DataElementMap)diagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class)) != null && (element = dem.getElement(diagram, item)) != null) {
                SelectionOutline so = (SelectionOutline)element.getElementClass().getAtMostOneItemOfClass(SelectionOutline.class);
                if (so != null) {
                    RouteGraph rg = (RouteGraph)element.getHint(RouteGraphConnectionClass.KEY_ROUTEGRAPH);
                    if (rg != null) {
                        RouteGraph rgc = rg;
                        TLongSet nonTemplatizedConnectors = result.getNonTemplatizedConnectors();
                        if (nonTemplatizedConnectors != null) {
                            rgc = rg.copy();
                            Collection rtc = rgc.getTerminals();
                            if (nonTemplatizedConnectors.size() <= rtc.size() - 2) {
                                RouteTerminal[] rts;
                                RouteTerminal[] routeTerminalArray = rts = rtc.toArray(new RouteTerminal[rtc.size()]);
                                int n = rts.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    RouteTerminal rt = routeTerminalArray[n2];
                                    Object data = rt.getData();
                                    if (data instanceof Long && nonTemplatizedConnectors.contains(((Long)data).longValue())) {
                                        rgc.remove(rt);
                                    }
                                    ++n2;
                                }
                            }
                        }
                        Path2D path = rgc.getPath2D();
                        Stroke connectionStroke = ConnectionSelectionOutline.INSTANCE.resolveStroke(element, ConnectionSelectionOutline.defaultStroke);
                        shape = connectionStroke.createStrokedShape(path);
                    } else {
                        shape = so.getSelectionShape(element);
                    }
                } else {
                    Rectangle2D rect = ElementUtils.getElementBounds((IElement)element);
                    shape = GeometryUtils.expandRectangle((Rectangle2D)rect, (double)0.5);
                }
            }
            if ((at = result.getWorldTransform()) != null) {
                node.setTransform(at);
            }
            node.setZIndex(-1000);
            node.setColor(result.hasElementSource() ? PAINT : PAINT_WITHOUT_SOURCE);
            node.setFill(fill);
            node.setScaleStroke(false);
            node.setScaleShape(false);
            node.setStroke(stroke);
            node.setShape(shape);
        } else {
            this.cleanupStyleForNode(context, _node);
        }
    }

    protected void cleanupStyleForNode(EvaluationContext context, INode node) {
        ProfileVariables.denyChild((INode)node, (String)"*", (String)"typical");
        ProfileVariables.denyChild((INode)node, (String)"", (String)"typical");
    }
}

