/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import gnu.trove.map.hash.THashMap;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.ResourceSetGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;

public class DependentInstances3
extends ResourceRead<ResourceSetGraph> {
    private static final boolean DEBUG = false;
    private static ThreadLocal<THashMap<DependentInstances3, ResourceSetGraph>> workArea = new ThreadLocal<THashMap<DependentInstances3, ResourceSetGraph>>(){

        @Override
        protected THashMap<DependentInstances3, ResourceSetGraph> initialValue() {
            return new THashMap();
        }
    };

    public DependentInstances3(Resource resource) {
        super(resource);
    }

    public ResourceSetGraph perform(ReadGraph graph) throws DatabaseException {
        if (this.resource.equals(graph.getRootLibrary())) {
            return new ResourceSetGraph(graph, this.resource);
        }
        THashMap<DependentInstances3, ResourceSetGraph> workingSet = workArea.get();
        ResourceSetGraph result = (ResourceSetGraph)workingSet.get((Object)this);
        if (result != null) {
            return result;
        }
        result = new ResourceSetGraph(graph, this.resource);
        workingSet.put((Object)this, (Object)result);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Set objects = cs.createSet();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Statement dep : graph.getStatements(this.resource, L0.IsDependencyOf)) {
            Resource object;
            if (graph.isSubrelationOf(dep.getPredicate(), L0.HasPrevious) || graph.isImmutable(object = dep.getObject())) continue;
            objects.add(object);
        }
        for (Resource object : objects) {
            DependentInstances3 query = new DependentInstances3(object);
            ResourceSetGraph instances = (ResourceSetGraph)workingSet.get((Object)query);
            if (instances == null) {
                instances = (ResourceSetGraph)graph.syncRequest((Read)query);
            }
            result.references.add(instances);
        }
        workingSet.remove((Object)this);
        return result;
    }
}

