/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import gnu.trove.map.hash.THashMap;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.ServiceLocator;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteGraphConnectionClass;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.delta.RouteGraphDelta;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ArrowLineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainLineEndStyle;
import org.simantics.diagram.participant.ConnectionBuilder;
import org.simantics.diagram.participant.ControlPoint;
import org.simantics.diagram.participant.RouteGraphTarget;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.RouteGraphConnection;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.BranchPointTerminal;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.elementclass.FlagHandler;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.BranchPointNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class RouteGraphConnectTool
extends AbstractMode {
    private static final String END_TERMINAL_DATA = "END";
    public static final int PAINT_PRIORITY = 15;
    @DependencyReflection.Dependency
    protected TransformUtil util;
    @DependencyReflection.Dependency
    protected ElementPainter diagramPainter;
    @DependencyReflection.Dependency
    protected PointerInteractor pi;
    protected RouteGraphTarget startingPoint;
    protected TerminalUtil.TerminalInfo startTerminal = new TerminalUtil.TerminalInfo();
    protected boolean createFlags;
    protected IElementClassProvider elementClassProvider;
    protected Deque<ControlPoint> controlPoints = new ArrayDeque<ControlPoint>();
    protected TerminalUtil.TerminalInfo endTerminal;
    protected ConnectionJudgement connectionJudgment;
    protected Collection<Topology.Terminal> terminals = new ArrayList<Topology.Terminal>();
    protected Point2D lastMouseCanvasPos = new Point2D.Double();
    protected boolean mouseHasMoved = false;
    protected TerminalPainter.TerminalHoverStrategy originalStrategy = null;
    protected TerminalPainter.TerminalHoverStrategy terminalHoverStrategy = new TerminalPainter.TerminalHoverStrategy(){

        public boolean highlightEnabled() {
            return !RouteGraphConnectTool.this.isEndingInFlag();
        }

        public boolean highlight(TerminalUtil.TerminalInfo ti) {
            return RouteGraphConnectTool.this.canConnect(ti.e, ti.t) != null;
        }
    };
    protected static final Composite ALPHA_COMPOSITE = AlphaComposite.getInstance(3, 0.75f);
    protected ConnectionNode ghostNode;
    protected RouteGraphNode rgNode;
    protected RouteGraph routeGraph;
    protected RouteTerminal endRouteTerminal;
    private ILineEndStyle endTerminalStyle;
    protected TerminalUtil.TerminalInfo endFlag;
    protected G2DParentNode endFlagNode;
    private RouteLine attachedToRouteLine;
    protected RouteGraph beforeRouteGraph;
    private IRouteGraphRenderer beforeRenderer;
    private boolean beforeEditable;
    protected RouteGraphDelta routeGraphDelta;
    private Set<Pair<IElement, Topology.Terminal>> alreadyConnected;
    private int mouseLeftReleaseCount = 0;

    public RouteGraphConnectTool(RouteGraphTarget startingPoint, int mouseId) {
        super(mouseId);
        Point2D intersection = startingPoint.getIntersectionPosition();
        this.startingPoint = startingPoint;
        this.lastMouseCanvasPos.setLocation(intersection);
        BranchPointTerminal t = BranchPointTerminal.existingTerminal((AffineTransform)AffineTransform.getTranslateInstance(intersection.getX(), intersection.getY()), (DirectionSet)DirectionSet.ANY, (Shape)BranchPointNode.SHAPE);
        Point2D p = startingPoint.getIntersectionPosition();
        AffineTransform at = AffineTransform.getTranslateInstance(p.getX(), p.getY());
        this.startTerminal.e = startingPoint.getElement();
        this.startTerminal.t = t;
        this.startTerminal.posElem = at;
        this.startTerminal.posDia = at;
        this.startTerminal.shape = t.getShape();
        this.controlPoints.add(this.newControlPoint(startingPoint.getIntersectionPosition()));
        this.controlPoints.add(this.newControlPoint(startingPoint.getCanvasPosition()));
        this.alreadyConnected = new HashSet<Pair<IElement, Topology.Terminal>>();
        IElement connection = startingPoint.getElement();
        ConnectionEntity ce = (ConnectionEntity)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY);
        Collection tcs = ce.getTerminalConnections(null);
        for (Topology.Connection tc : tcs) {
            this.alreadyConnected.add((Pair<IElement, Topology.Terminal>)Pair.make((Object)tc.node, (Object)tc.terminal));
        }
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.originalStrategy = (TerminalPainter.TerminalHoverStrategy)this.getHint(TerminalPainter.TERMINAL_HOVER_STRATEGY);
        this.setHint(TerminalPainter.TERMINAL_HOVER_STRATEGY, this.terminalHoverStrategy);
    }

    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
        if (newDiagram != null) {
            ISynchronizationContext ctx = (ISynchronizationContext)newDiagram.getHint(SynchronizationHints.CONTEXT);
            if (ctx != null) {
                this.elementClassProvider = (IElementClassProvider)ctx.get(SynchronizationHints.ELEMENT_CLASS_PROVIDER);
            }
            this.createFlags = Boolean.TRUE.equals(newDiagram.getHint(DiagramHints.KEY_USE_CONNECTION_FLAGS));
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        if (this.getHint(TerminalPainter.TERMINAL_HOVER_STRATEGY) == this.terminalHoverStrategy) {
            if (this.originalStrategy != null) {
                this.setHint(TerminalPainter.TERMINAL_HOVER_STRATEGY, this.originalStrategy);
            } else {
                this.removeHint(TerminalPainter.TERMINAL_HOVER_STRATEGY);
            }
        }
        super.removedFromContext(ctx);
    }

    int straightDirections(RouteLine line) {
        return line.isHorizontal() ? 10 : 5;
    }

    private static RouteTerminal addTerminal(Object data, RouteGraph rg, double x, double y, Rectangle2D bounds, int allowedDirections, ILineEndStyle style) {
        RouteTerminal rt = bounds != null ? rg.addTerminal(x, y, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY(), allowedDirections, style) : rg.addTerminal(x, y, x, y, x, y, allowedDirections, style);
        rt.setData(data);
        return rt;
    }

    private RouteTerminal setEndTerminal(double x, double y, Rectangle2D bounds, int allowedDirections) {
        RouteTerminal toRemove = this.endRouteTerminal;
        this.endRouteTerminal = RouteGraphConnectTool.addTerminal(END_TERMINAL_DATA, this.routeGraph, x, y, bounds, allowedDirections, this.endTerminalStyle);
        this.routeGraph.link(this.attachedToRouteLine, this.endRouteTerminal);
        if (toRemove != null) {
            this.routeGraph.remove(toRemove);
        }
        return this.endRouteTerminal;
    }

    protected void setEndTerminal(TerminalUtil.TerminalInfo ti) {
        Rectangle2D bounds = ElementUtils.getElementBoundsOnDiagram((IElement)ti.e, (Rectangle2D)new Rectangle2D.Double());
        GeometryUtils.expandRectangle((Rectangle2D)bounds, (double)2.0);
        int dir = RouteGraphConnectionClass.shortestDirectionOutOfBounds(ti.posDia.getTranslateX(), ti.posDia.getTranslateY(), bounds);
        this.setEndTerminal(ti.posDia.getTranslateX(), ti.posDia.getTranslateY(), bounds, dir);
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.ghostNode = (ConnectionNode)parent.addNode("branched connection", ConnectionNode.class);
        this.ghostNode.setZIndex(15);
        this.rgNode = (RouteGraphNode)this.ghostNode.addNode("branch", RouteGraphNode.class);
        double ex = this.startingPoint.getCanvasPosition().getX();
        double ey = this.startingPoint.getCanvasPosition().getY();
        this.beforeRouteGraph = this.startingPoint.getNode().getRouteGraph();
        this.beforeEditable = this.startingPoint.getNode().isEditable();
        RouteGraphNode beforeRgNode = this.startingPoint.getNode();
        this.beforeRenderer = beforeRgNode.getRenderer();
        this.rgNode.setRenderer(this.beforeRenderer);
        this.rgNode.setEditable(false);
        beforeRgNode.setEditable(this.beforeEditable);
        beforeRgNode.setRenderer(null);
        this.initRG(ex, ey);
    }

    public void initRG(double ex, double ey) {
        THashMap map = new THashMap();
        this.routeGraph = this.beforeRouteGraph.copy(map);
        this.endTerminalStyle = PlainLineEndStyle.INSTANCE;
        for (RouteTerminal t : this.routeGraph.getTerminals()) {
            if (!(t.getRenderStyle() instanceof ArrowLineEndStyle)) continue;
            this.endTerminalStyle = t.getRenderStyle();
            break;
        }
        this.attachedToRouteLine = (RouteLine)map.get((Object)this.startingPoint.getLine());
        this.routeGraph.makePersistent(this.attachedToRouteLine);
        for (RouteLine line : this.routeGraph.getAllLines()) {
            if (line.isTransient() || line.isHorizontal() != this.attachedToRouteLine.isHorizontal() || line.getPosition() != this.attachedToRouteLine.getPosition()) continue;
            this.attachedToRouteLine = line;
            break;
        }
        this.routeGraphDelta = new RouteGraphDelta(this.beforeRouteGraph, this.routeGraph);
        this.setEndTerminal(ex, ey, null, 15);
        this.rgNode.setRouteGraph(this.routeGraph);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        RouteGraphNode beforeRgNode = this.startingPoint.getNode();
        beforeRgNode.setRouteGraph(this.beforeRouteGraph);
        beforeRgNode.setRenderer(this.beforeRenderer);
        beforeRgNode.setEditable(this.beforeEditable);
        this.ghostNode.remove();
        this.ghostNode = null;
        this.setDirty();
    }

    @EventHandlerReflection.EventHandler(priority=200)
    public boolean handleCommandEvents(CommandEvent ce) {
        if (ce.command.equals((Object)Commands.CANCEL)) {
            this.setDirty();
            this.remove();
            return true;
        }
        if (!ce.command.equals((Object)Commands.ROTATE_ELEMENT_CCW)) {
            ce.command.equals((Object)Commands.ROTATE_ELEMENT_CW);
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=2097172)
    public boolean handleKeyEvents(KeyEvent ke) {
        if (ke instanceof KeyEvent.KeyPressedEvent && ke.keyCode == 8) {
            return this.cancelPreviousBend();
        }
        if (ke.keyCode == 18 && this.createFlags) {
            this.endWithoutTerminal(this.lastMouseCanvasPos, this.shouldEndWithFlag(ke instanceof KeyEvent.KeyPressedEvent));
            return true;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=2097172)
    public boolean handleEvent(MouseEvent me) {
        if (me.mouseId != this.mouseId) {
            return false;
        }
        if (me instanceof MouseEvent.MouseMovedEvent) {
            return this.processMouseMove((MouseEvent.MouseMovedEvent)me);
        }
        if (me instanceof MouseEvent.MouseButtonPressedEvent) {
            return this.processMouseButtonPress((MouseEvent.MouseButtonEvent)((MouseEvent.MouseButtonPressedEvent)me));
        }
        if (me instanceof MouseEvent.MouseButtonReleasedEvent) {
            return this.processMouseButtonRelease((MouseEvent.MouseButtonReleasedEvent)me);
        }
        return false;
    }

    protected boolean processMouseMove(MouseEvent.MouseMovedEvent me) {
        this.mouseHasMoved = true;
        Point2D mouseControlPos = me.controlPosition;
        Point2D mouseCanvasPos = this.util.controlToCanvas(mouseControlPos, (Point2D)new Point2D.Double());
        ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
        if (snapAdvisor != null) {
            snapAdvisor.snap(mouseCanvasPos);
        }
        this.lastMouseCanvasPos.setLocation(mouseCanvasPos);
        if (this.isEndingInFlag()) {
            this.endFlagNode.setTransform(AffineTransform.getTranslateInstance(mouseCanvasPos.getX(), mouseCanvasPos.getY()));
        }
        List tis = this.pi.pickTerminals(me.controlPosition);
        if (!(tis = TerminalUtil.findNearestOverlappingTerminals((List)tis)).isEmpty()) {
            for (TerminalUtil.TerminalInfo ti : tis) {
                Object canConnect = this.canConnect(ti.e, ti.t);
                if (canConnect == null) continue;
                this.connectionJudgment = (ConnectionJudgement)canConnect;
                if (!this.isEndingInFlag() || !TerminalUtil.isSameTerminal((TerminalUtil.TerminalInfo)ti, (TerminalUtil.TerminalInfo)this.endTerminal)) {
                    this.controlPoints.getLast().setPosition(ti.posDia).setAttachedToTerminal(ti);
                    this.endTerminal = ti;
                    this.connect(ti);
                }
                this.endWithoutTerminal(this.lastMouseCanvasPos, this.shouldEndWithFlag((MouseEvent)me));
                this.updateSG(new Point2D.Double(ti.posDia.getTranslateX(), ti.posDia.getTranslateY()));
                return false;
            }
        }
        this.connectionJudgment = null;
        if (this.isEndTerminalDefined()) {
            this.disconnect(mouseCanvasPos);
            this.controlPoints.getLast().setPosition(mouseCanvasPos).setAttachedToTerminal(null);
            this.endTerminal = null;
        } else {
            this.controlPoints.getLast().setPosition(mouseCanvasPos);
        }
        this.endWithoutTerminal(this.lastMouseCanvasPos, this.shouldEndWithFlag((MouseEvent)me));
        this.updateSG(this.lastMouseCanvasPos);
        return false;
    }

    protected void connect(TerminalUtil.TerminalInfo ti) {
        this.setEndTerminal(ti);
    }

    protected void disconnect(Point2D mouseCanvasPos) {
        this.setEndTerminal(mouseCanvasPos.getX(), mouseCanvasPos.getY(), null, 15);
    }

    protected boolean processMouseButtonPress(MouseEvent.MouseButtonEvent me) {
        if (!this.mouseHasMoved) {
            return true;
        }
        if (me.button == 1) {
            Point2D mouseControlPos = me.controlPosition;
            Point2D mouseCanvasPos = this.util.getInverseTransform().transform(mouseControlPos, new Point2D.Double());
            ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
            if (snapAdvisor != null) {
                snapAdvisor.snap(mouseCanvasPos);
            }
            if (this.tryEndConnection()) {
                return true;
            }
            if ((me.stateMask & 0x200) != 0 && this.startTerminal != null) {
                this.connectionJudgment = (ConnectionJudgement)this.canConnect(null, null);
                if (this.connectionJudgment == null) {
                    return true;
                }
                this.createConnection();
                this.remove();
                return true;
            }
            if (this.routePointsAllowed() && (me.stateMask & 0x2C0) == 0) {
                this.controlPoints.add(this.newControlPoint(mouseCanvasPos));
                this.updateSG(mouseCanvasPos);
            }
            return true;
        }
        if (me.button == 2) {
            return this.cancelPreviousBend();
        }
        return false;
    }

    protected boolean processMouseButtonRelease(MouseEvent.MouseButtonReleasedEvent me) {
        if (me.button == 1 && ++this.mouseLeftReleaseCount == 1) {
            return this.tryEndConnection();
        }
        return false;
    }

    private boolean tryEndConnection() {
        if (this.isEndTerminalDefined()) {
            this.createConnection();
            this.remove();
            return true;
        }
        return false;
    }

    protected boolean cancelPreviousBend() {
        if (!this.routePointsAllowed()) {
            return false;
        }
        if (this.isEndingInFlag()) {
            return true;
        }
        if (this.controlPoints.size() <= 2) {
            this.setDirty();
            this.remove();
            return true;
        }
        this.controlPoints.removeLast();
        this.controlPoints.getLast().setPosition(this.lastMouseCanvasPos);
        this.updateSG(this.lastMouseCanvasPos);
        return true;
    }

    protected void updateSG(Point2D mousePos) {
        this.routeGraph.setLocation(this.endRouteTerminal, mousePos.getX(), mousePos.getY());
        this.setDirty();
    }

    protected boolean shouldEndWithFlag(MouseEvent me) {
        return this.shouldEndWithFlag((me.stateMask & 0x200) != 0);
    }

    protected boolean shouldEndWithFlag(boolean altPressed) {
        return altPressed && !this.isEndTerminalDefined() && this.createFlags;
    }

    protected boolean isEndTerminalDefined() {
        return this.endTerminal != null;
    }

    protected boolean isFlagTerminal(TerminalUtil.TerminalInfo ti) {
        return ti.e.getElementClass().containsClass(FlagHandler.class);
    }

    protected boolean isEndingInFlag() {
        return this.endFlag != null;
    }

    protected void endWithoutTerminal(Point2D mousePos, boolean altDown) {
        if (!this.createFlags) {
            return;
        }
        boolean endTerminalDefined = this.isEndTerminalDefined();
        if (altDown) {
            if (!this.isEndingInFlag()) {
                this.endFlag = this.createFlag(EdgeVisuals.EdgeEnd.End);
                this.endFlagNode = this.showElement((G2DParentNode)this.ghostNode, "endFlag", this.endFlag.e, mousePos);
                this.controlPoints.getLast().setAttachedToTerminal(this.endFlag);
                this.setHint(TerminalPainter.TERMINAL_HOVER_STRATEGY, this.terminalHoverStrategy);
                this.updateSG(mousePos);
            }
        } else if (this.isEndingInFlag()) {
            this.endFlag = null;
            this.endFlagNode.remove();
            this.endFlagNode = null;
            ControlPoint cp = this.controlPoints.getLast();
            cp.setAttachedToTerminal(this.endTerminal);
            if (endTerminalDefined) {
                cp.setPosition(this.endTerminal.posDia);
            } else {
                cp.setPosition(mousePos);
            }
            this.setHint(TerminalPainter.TERMINAL_HOVER_STRATEGY, this.terminalHoverStrategy);
            this.updateSG(mousePos);
        }
    }

    private G2DParentNode showElement(G2DParentNode parent, String nodeId, IElement element, Point2D pos) {
        return this.showElement(parent, nodeId, element, AffineTransform.getTranslateInstance(pos.getX(), pos.getY()));
    }

    private G2DParentNode showElement(G2DParentNode parent, String nodeId, IElement element, AffineTransform tr) {
        G2DParentNode elementParent = (G2DParentNode)parent.getOrCreateNode(nodeId, G2DParentNode.class);
        elementParent.setTransform(tr);
        elementParent.removeNodes();
        for (SceneGraph sg : element.getElementClass().getItemsByClass(SceneGraph.class)) {
            sg.init(element, elementParent);
        }
        return elementParent;
    }

    protected ControlPoint newControlPoint(Point2D canvasPos) {
        return new ControlPoint(canvasPos);
    }

    protected Triple<RouteGraph, RouteGraph, RouteGraphDelta> prepareRouteGraphDelta() {
        this.routeGraph.remove(this.endRouteTerminal);
        return Triple.make((Object)this.beforeRouteGraph, (Object)this.routeGraph, (Object)this.routeGraphDelta);
    }

    protected void createConnection() {
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"createConnection");
        final ConnectionJudgement judgment = this.connectionJudgment;
        if (judgment == null) {
            ErrorLogger.defaultLogError((String)"Cannot create connection, no judgment available on connection validity", null);
            return;
        }
        final ConnectionBuilder builder = new ConnectionBuilder(this.diagram);
        final Triple<RouteGraph, RouteGraph, RouteGraphDelta> rgs = this.prepareRouteGraphDelta();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                Resource connection = (Resource)ElementUtils.getObject((IElement)RouteGraphConnectTool.this.startTerminal.e);
                if (!((RouteGraphDelta)rgs.third).isEmpty()) {
                    new RouteGraphConnection(graph, connection).synchronize(graph, (RouteGraph)rgs.first, (RouteGraph)rgs.second, (RouteGraphDelta)rgs.third);
                }
                Resource attachToLine = RouteGraphConnection.deserialize((ServiceLocator)graph, RouteGraphConnectTool.this.attachedToRouteLine.getData());
                builder.attachToRouteGraph(graph, judgment, connection, attachToLine, RouteGraphConnectTool.this.controlPoints, RouteGraphConnectTool.this.endTerminal, FlagClass.Type.Out);
            }
        }, e -> {
            if (e != null) {
                ExceptionUtils.logAndShowError((Throwable)e);
            }
        });
    }

    protected boolean routePointsAllowed() {
        return Boolean.TRUE.equals(this.diagram.getHint(DiagramHints.KEY_ALLOW_ROUTE_POINTS));
    }

    protected Object canConnect(IElement endElement, Topology.Terminal endTerminal) {
        IConnectionAdvisor advisor = (IConnectionAdvisor)this.diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
        return this.canConnect(advisor, endElement, endTerminal);
    }

    protected Object canConnect(IConnectionAdvisor advisor, IElement endElement, Topology.Terminal endTerminal) {
        if (advisor == null) {
            return ConnectionJudgement.CANBEMADELEGAL;
        }
        if (this.alreadyConnected.contains(Pair.make((Object)endElement, (Object)endTerminal))) {
            return null;
        }
        return advisor.canBeConnected(null, this.startTerminal.e, this.startTerminal.t, endElement, endTerminal);
    }

    protected static FlagClass.Type endToFlagType(EdgeVisuals.EdgeEnd end) {
        switch (end) {
            case Begin: {
                return FlagClass.Type.In;
            }
            case End: {
                return FlagClass.Type.Out;
            }
        }
        throw new IllegalArgumentException("unrecognized edge end: " + end);
    }

    protected TerminalUtil.TerminalInfo createFlag(EdgeVisuals.EdgeEnd connectionEnd) {
        ElementClass flagClass = this.elementClassProvider.get(ElementClasses.FLAG);
        IElement e = Element.spawnNew((ElementClass)flagClass);
        e.setHint(FlagClass.KEY_FLAG_TYPE, (Object)RouteGraphConnectTool.endToFlagType(connectionEnd));
        e.setHint(FlagClass.KEY_FLAG_MODE, (Object)FlagClass.Mode.Internal);
        TerminalUtil.TerminalInfo ti = new TerminalUtil.TerminalInfo();
        ti.e = e;
        ti.t = ElementUtils.getSingleTerminal((IElement)e);
        ti.posElem = TerminalUtil.getTerminalPosOnElement((IElement)e, (Topology.Terminal)ti.t);
        ti.posDia = TerminalUtil.getTerminalPosOnDiagram((IElement)e, (Topology.Terminal)ti.t);
        return ti;
    }

    static RouteGraphTarget pickRouteGraphConnection(ICanvasContext ctx, IDiagram diagram, Shape pickShape, double pickDistance) {
        ArrayList<IElement> elements = new ArrayList<IElement>();
        PickRequest req = new PickRequest(pickShape).context(ctx);
        DiagramUtils.pick((IDiagram)diagram, (PickRequest)req, elements);
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            IElement e = (IElement)it.next();
            RouteGraphNode rgn = (RouteGraphNode)e.getHint(RouteGraphConnectionClass.KEY_RG_NODE);
            if (rgn != null && rgn.getRouteGraph() != null) continue;
            it.remove();
        }
        if (elements.isEmpty()) {
            return null;
        }
        Rectangle2D pickRect = pickShape.getBounds2D();
        double x = pickRect.getCenterX();
        double y = pickRect.getCenterY();
        return RouteGraphConnectTool.pickNearestRouteGraphConnection(elements, x, y, pickDistance);
    }

    private static RouteGraphTarget pickNearestRouteGraphConnection(ArrayList<IElement> elements, double x, double y, double pd) {
        RouteLine line;
        RouteGraphNode rgn;
        double delta;
        double hi = pd + 1.0;
        double lo = hi * 0.01;
        double limit = 0.5;
        while (!((delta = hi - lo) <= limit)) {
            pd = (lo + hi) * 0.5;
            boolean hit = false;
            for (IElement connection : elements) {
                rgn = (RouteGraphNode)connection.getHint(RouteGraphConnectionClass.KEY_RG_NODE);
                line = rgn.getRouteGraph().pickLine(x, y, pd);
                if (line == null) continue;
                hit = true;
                break;
            }
            if (hit) {
                hi = pd;
                continue;
            }
            lo = pd;
        }
        RouteGraphTarget nearestTarget = null;
        double nearest = Double.MAX_VALUE;
        for (IElement connection : elements) {
            double dy;
            double dx;
            double dist;
            Point2D intersection;
            rgn = (RouteGraphNode)connection.getHint(RouteGraphConnectionClass.KEY_RG_NODE);
            line = rgn.getRouteGraph().pickLine(x, y, pd);
            if (line == null || (intersection = RouteGraphConnectTool.intersectionPoint(x, y, line)) == null || !((dist = Math.sqrt((dx = intersection.getX() - x) * dx + (dy = intersection.getY() - y) * dy)) < nearest)) continue;
            nearest = dist;
            nearestTarget = new RouteGraphTarget(connection, rgn, line, new Point2D.Double(x, y), intersection);
        }
        return nearestTarget;
    }

    static Point2D intersectionPoint(double x, double y, RouteLine line) {
        List points = line.getPoints();
        if (points.size() < 2) {
            return null;
        }
        RoutePoint s = line.getBegin();
        RoutePoint e = line.getEnd();
        return GeometryUtils.intersectionToLine((double)s.getX(), (double)s.getY(), (double)e.getX(), (double)e.getY(), (double)x, (double)y);
    }
}

