/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.flag.AbstractFlagType;
import org.simantics.diagram.flag.FlagInfoBuilder;
import org.simantics.diagram.flag.IFlagType;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.utils.Alignment;
import org.simantics.structural2.modelingRules.IModelingRules;

public class BasicFlagType
extends AbstractFlagType {
    public BasicFlagType(Resource flag, IModelingRules modelingRules) {
        super(flag, modelingRules);
    }

    @Override
    public IFlagType.FlagInfo getInfo(ReadGraph graph) throws DatabaseException {
        FlagClass.Type type = this.getType(graph);
        FlagClass.Mode mode = this.getMode(graph);
        return FlagInfoBuilder.fill(type).shape(this.getShape(graph, type, mode)).text(this.getText(graph)).textArea(this.getArea(graph, type, mode)).horizontalAlignment(Alignment.LEADING).verticalAlignment(Alignment.CENTER).create();
    }

    protected Rectangle2D getArea(ReadGraph graph, FlagClass.Type type, FlagClass.Mode mode) {
        return BasicFlagType.getArea(type, mode);
    }

    public static Rectangle2D getArea(FlagClass.Type type, FlagClass.Mode mode) {
        double beakLength = FlagClass.getBeakLength((double)6.000000000000001, (double)60.0);
        return BasicFlagType.getArea(type, mode, 21.000000000000004, 6.000000000000001, beakLength);
    }

    public static Rectangle2D getArea(FlagClass.Type type, FlagClass.Mode mode, double width, double height, double beakLength) {
        double x = 0.0;
        double y = -height / 2.0;
        double w = width;
        double h = height;
        if (type == FlagClass.Type.In) {
            if (mode instanceof FlagClass.External) {
                x = -width - beakLength;
            } else if (mode == FlagClass.Mode.Internal) {
                x = -beakLength;
                w = beakLength;
            }
        } else if (type == FlagClass.Type.Out && mode == FlagClass.Mode.Internal) {
            w = beakLength;
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    protected Shape getShape(ReadGraph graph, FlagClass.Type type, FlagClass.Mode mode) throws DatabaseException {
        return BasicFlagType.getShape(type, mode);
    }

    public static Shape getShape(FlagClass.Type type, FlagClass.Mode mode) {
        double beakLength = FlagClass.getBeakLength((double)6.000000000000001, (double)60.0);
        Path2D.Double path = new Path2D.Double();
        FlagClass.createFlagShape((Path2D)path, (FlagClass.Type)type, (FlagClass.Mode)mode, (double)21.000000000000004, (double)6.000000000000001, (double)beakLength);
        return path;
    }

    protected String[] getText(ReadGraph graph) throws DatabaseException {
        return (String[])graph.syncRequest(DiagramRequests.getFlagText(this.flag));
    }
}

