/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl.issue;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.Simantics;
import org.simantics.db.Disposable;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.common.procedure.adapter.DisposableSyncListener;
import org.simantics.db.common.procedure.adapter.SyncListenerAdapter;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.osgi.issues.SCLIssueProviderFactory;
import org.simantics.scl.osgi.issues.SCLIssuesTableEntry;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.action.DefaultActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLExpressionIssueProvider
implements SCLIssueProviderFactory.SCLIssueProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLExpressionIssueProvider.class);
    private boolean disposed = false;
    private ComponentSyncListenerAdapter listener;

    SCLExpressionIssueProvider() {
    }

    public void listenIssues(Runnable callback) {
        this.listener = new ComponentSyncListenerAdapter(callback);
        Simantics.getSession().asyncRequest((Read)new ComponentRequest(), (SyncListener)this.listener);
    }

    public List<SCLIssuesTableEntry> getIssues() {
        return this.listener.getIssues();
    }

    public void dispose() {
        this.listener.dispose();
        this.disposed = true;
    }

    private static void openResource(Shell shell, Resource resource) {
        DefaultActions.performDefaultAction((Control)shell, (Object)new StructuredSelection((Object)resource));
    }

    private static class ComponentRequest
    extends UniqueRead<Set<Resource>> {
        private ComponentRequest() {
        }

        public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            TreeSet<Resource> indexRoots = new TreeSet<Resource>();
            for (Resource ontology : Layer0Utils.listOntologies((ReadGraph)graph)) {
                if (!graph.isInstanceOf(ontology, L0.SharedOntology)) continue;
                indexRoots.add(ontology);
            }
            for (Resource child : graph.getObjects(Simantics.getProjectResource(), L0.ConsistsOf)) {
                if (!graph.isInstanceOf(child, L0.IndexRoot)) continue;
                indexRoots.add(child);
            }
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            HashSet<Resource> allComponents = new HashSet<Resource>();
            for (Resource ontology : indexRoots) {
                List<Resource> components = ModelingUtils.searchByTypeShallow(graph, ontology, STR.Component);
                allComponents.addAll(components);
            }
            return allComponents;
        }
    }

    private static class ComponentSyncListenerAdapter
    extends SyncListenerAdapter<Set<Resource>>
    implements Disposable {
        private ConcurrentHashMap<Resource, SCLValueDisposableSyncListener> currentlyListening = new ConcurrentHashMap();
        private boolean disposed;
        private Runnable callback;

        public ComponentSyncListenerAdapter(Runnable callback) {
            this.callback = callback;
        }

        public void execute(ReadGraph graph, Set<Resource> newComponents) throws DatabaseException {
            DisposableSyncListener listener;
            if (this.currentlyListening.isEmpty() && newComponents.isEmpty()) {
                return;
            }
            HashSet removedComponents = new HashSet(this.currentlyListening.keySet());
            removedComponents.removeAll(newComponents);
            HashSet<Resource> addedComponents = new HashSet<Resource>(newComponents);
            addedComponents.removeAll(this.currentlyListening.keySet());
            for (Resource removedComponent : removedComponents) {
                listener = this.currentlyListening.remove(removedComponent);
                listener.dispose();
            }
            for (Resource addedComponent : addedComponents) {
                listener = new SCLValueDisposableSyncListener(this.callback);
                this.currentlyListening.put(addedComponent, (SCLValueDisposableSyncListener)listener);
                graph.syncRequest((Read)new SCLValueRequest(addedComponent), (SyncListener)listener);
            }
        }

        public List<SCLIssuesTableEntry> getIssues() {
            ArrayList<SCLIssuesTableEntry> issues = new ArrayList<SCLIssuesTableEntry>();
            for (SCLValueDisposableSyncListener listener : this.currentlyListening.values()) {
                List<SCLIssuesTableEntry> listenerIssues = listener.getIssues();
                if (listenerIssues == null || listenerIssues.isEmpty()) continue;
                issues.addAll(listenerIssues);
            }
            return issues;
        }

        public void dispose() {
            this.currentlyListening.values().forEach(l -> l.dispose());
            this.currentlyListening.clear();
            this.disposed = true;
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }

    private static class ResourceHolder {
        Resource component;
        Resource predicate;
        Resource object;

        public ResourceHolder(Resource component, Resource predicate, Resource object) {
            this.component = Objects.requireNonNull(component);
            this.predicate = Objects.requireNonNull(predicate);
            this.object = Objects.requireNonNull(object);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.component.hashCode();
            result = 31 * result + this.object.hashCode();
            result = 31 * result + this.predicate.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceHolder other = (ResourceHolder)obj;
            if (!this.component.equals(other.component)) {
                return false;
            }
            if (!this.object.equals(other.object)) {
                return false;
            }
            return this.predicate.equals(other.predicate);
        }
    }

    public static class SCLExpressionIssueProviderFactory
    implements SCLIssueProviderFactory {
        public SCLIssueProviderFactory.SCLIssueProvider getSCLIssueProvider() {
            return new SCLExpressionIssueProvider();
        }
    }

    private static class SCLExpressionValidationRequest
    extends TernaryRead<Resource, Resource, Resource, SCLIssuesTableEntry> {
        public SCLExpressionValidationRequest(Resource component, Resource predicate, Resource object) {
            super((Object)component, (Object)predicate, (Object)object);
        }

        public SCLIssuesTableEntry perform(ReadGraph graph) throws DatabaseException {
            Resource type = graph.getPossibleType((Resource)this.parameter3, Layer0.getInstance((ReadGraph)graph).SCLValue);
            if (type == null) {
                return null;
            }
            if (!graph.hasStatement((Resource)this.parameter)) {
                return null;
            }
            Variable componentVariable = Variables.getPossibleVariable((ReadGraph)graph, (Resource)((Resource)this.parameter));
            if (componentVariable == null) {
                return null;
            }
            Variable propertyVariable = componentVariable.getProperty(graph, (Resource)this.parameter2);
            Variable typeVariable = Variables.getVariable((ReadGraph)graph, (Resource)type);
            Function1 func = (Function1)typeVariable.getPossiblePropertyValue(graph, "validator");
            if (func == null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("No validator available for " + typeVariable.getURI(graph));
                }
                return null;
            }
            SCLContext sclContext = SCLContext.getCurrent();
            Object oldGraph = sclContext.get((Object)"graph");
            try {
                sclContext.put((Object)"graph", (Object)graph);
                String validatorValue = (String)func.apply((Object)propertyVariable);
                if (validatorValue != null && !validatorValue.isEmpty()) {
                    SCLIssuesTableEntry sCLIssuesTableEntry = new SCLIssuesTableEntry(propertyVariable.getURI(graph), new CompilationError(9223372034707292160L, validatorValue.replace("\n", " "))){

                        public void openLocation() {
                            SCLExpressionIssueProvider.openResource(Display.getCurrent().getActiveShell(), (Resource)parameter);
                        }
                    };
                    return sCLIssuesTableEntry;
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to invoke type validator function " + func, t);
            }
            finally {
                sclContext.put((Object)"graph", oldGraph);
            }
            return null;
        }
    }

    private static class SCLIssuesTableEntryDisposableListener
    extends DisposableListener<SCLIssuesTableEntry> {
        private SCLIssuesTableEntry result;
        private Runnable callback;

        public SCLIssuesTableEntryDisposableListener(Runnable callback) {
            this.callback = callback;
        }

        public void execute(SCLIssuesTableEntry result) {
            if (!Objects.equals(this.result, result)) {
                this.result = result;
                if (this.callback != null) {
                    this.callback.run();
                }
            }
        }

        public void exception(Throwable t) {
            LOGGER.error("", t);
        }

        public SCLIssuesTableEntry getResult() {
            return this.result;
        }
    }

    private static class SCLValueDisposableSyncListener
    extends DisposableSyncListener<Set<ResourceHolder>> {
        private Runnable callback;
        private ConcurrentHashMap<ResourceHolder, SCLIssuesTableEntryDisposableListener> currentlyListeningSCLValues = new ConcurrentHashMap();

        public SCLValueDisposableSyncListener(Runnable callback) {
            this.callback = callback;
        }

        public void execute(ReadGraph graph, Set<ResourceHolder> newComponents) throws DatabaseException {
            DisposableListener listener;
            if (this.currentlyListeningSCLValues.isEmpty() && newComponents.isEmpty()) {
                return;
            }
            HashSet removedComponents = new HashSet(this.currentlyListeningSCLValues.keySet());
            removedComponents.removeAll(newComponents);
            HashSet<ResourceHolder> addedComponents = new HashSet<ResourceHolder>(newComponents);
            addedComponents.removeAll(this.currentlyListeningSCLValues.keySet());
            for (ResourceHolder removedComponent : removedComponents) {
                listener = this.currentlyListeningSCLValues.remove(removedComponent);
                listener.dispose();
            }
            for (ResourceHolder sclValue : addedComponents) {
                listener = new SCLIssuesTableEntryDisposableListener(this.callback);
                this.currentlyListeningSCLValues.put(sclValue, (SCLIssuesTableEntryDisposableListener)listener);
                graph.syncRequest((Read)new SCLExpressionValidationRequest(sclValue.component, sclValue.predicate, sclValue.object), (Listener)listener);
            }
            if (this.callback != null) {
                this.callback.run();
            }
        }

        public List<SCLIssuesTableEntry> getIssues() {
            if (this.currentlyListeningSCLValues.isEmpty()) {
                return null;
            }
            ArrayList<SCLIssuesTableEntry> issues = new ArrayList<SCLIssuesTableEntry>();
            for (SCLIssuesTableEntryDisposableListener listener : this.currentlyListeningSCLValues.values()) {
                if (listener.getResult() == null) continue;
                issues.add(listener.getResult());
            }
            return issues;
        }

        public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
            LOGGER.error("Could not listen", throwable);
        }

        public void dispose() {
            this.currentlyListeningSCLValues.values().forEach(l -> l.dispose());
            this.currentlyListeningSCLValues.clear();
            super.dispose();
        }
    }

    private static class SCLValueRequest
    extends UnaryRead<Resource, Set<ResourceHolder>> {
        public SCLValueRequest(Resource parameter) {
            super((Object)parameter);
        }

        public Set<ResourceHolder> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            HashSet<ResourceHolder> results = new HashSet<ResourceHolder>();
            for (Resource predicate : graph.getPredicates((Resource)this.parameter)) {
                if (!graph.isSubrelationOf(predicate, L0.HasProperty)) continue;
                for (Resource object : graph.getObjects((Resource)this.parameter, predicate)) {
                    if (!graph.isInstanceOf(object, L0.SCLValue)) continue;
                    results.add(new ResourceHolder((Resource)this.parameter, predicate, object));
                }
            }
            return results;
        }
    }
}

