/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.actions;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.request.PossibleURI;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyURI
implements ActionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyURI.class);

    public Runnable create(Object target) {
        return () -> {
            try {
                String uri = this.getPossibleURI(target);
                if (uri != null) {
                    Clipboard cb = new Clipboard(Display.getCurrent());
                    cb.setContents(new Object[]{uri}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not get URI for input {} to copy to clipboard", target, (Object)e);
            }
        };
    }

    private String getPossibleURI(Object input) throws DatabaseException {
        if (input instanceof Resource) {
            return (String)Simantics.getSession().syncRequest((Read)new PossibleURI((Resource)input));
        }
        if (input instanceof Variable) {
            return (String)Simantics.getSession().syncRequest((Read)new VariableURI((Variable)input));
        }
        return null;
    }
}

