/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.utils.ui.widgets.FileSelectionListener;

public abstract class FileOrDirectorySelectionWidget
extends Composite {
    Text fileText;
    String[] filename;
    private List<FileSelectionListener> listeners = new ArrayList<FileSelectionListener>();

    public FileOrDirectorySelectionWidget(Composite parent, String name, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this);
        Group fileGroup = new Group((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)fileGroup);
        fileGroup.setText(name);
        fileGroup.setLayout((Layout)new GridLayout(2, false));
        this.fileText = new Text((Composite)fileGroup, 2052);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.fileText.setLayoutData((Object)data);
        Button browseButton = new Button((Composite)fileGroup, 8);
        browseButton.setText("Browse");
        data = new GridData();
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] name = FileOrDirectorySelectionWidget.this.openDialog();
                if (name != null) {
                    FileOrDirectorySelectionWidget.this.setFilename(name);
                }
            }
        });
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String file = FileOrDirectorySelectionWidget.this.fileText.getText();
                FileOrDirectorySelectionWidget.this.setFilename(file.split(","));
            }
        });
    }

    protected abstract String[] openDialog();

    protected abstract boolean isValid(File var1);

    protected void setFilename(String[] filename) {
        String text = "";
        String[] stringArray = filename;
        int n = filename.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            text = String.valueOf(text) + s + ",";
            ++n2;
        }
        if (text.length() > 2) {
            text = text.substring(0, text.length() - 1);
        }
        if (!text.equals(this.fileText.getText())) {
            this.fileText.setText(text);
        }
        boolean accept = true;
        String[] stringArray2 = filename;
        int n3 = filename.length;
        n = 0;
        while (n < n3) {
            String s = stringArray2[n];
            File file = new File(s);
            if (!this.isValid(file)) {
                accept = false;
                break;
            }
            ++n;
        }
        this.filename = accept ? filename : null;
        for (FileSelectionListener l : this.listeners) {
            l.fileSelected(this, this.filename);
        }
    }

    public String[] getFilename() {
        return this.filename;
    }

    public void addListener(FileSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FileSelectionListener listener) {
        this.listeners.remove(listener);
    }
}

